/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.treeviewer.view;

import java.awt.Component;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuKeyEvent;
import javax.swing.event.MenuKeyListener;
import javax.swing.event.MenuListener;
import org.openmicroscopy.shoola.agents.treeviewer.actions.ActivationAction;
import org.openmicroscopy.shoola.agents.treeviewer.actions.AddAction;
import org.openmicroscopy.shoola.agents.treeviewer.actions.AnnotateAction;
import org.openmicroscopy.shoola.agents.treeviewer.actions.AnnotateChildrenAction;
import org.openmicroscopy.shoola.agents.treeviewer.actions.BrowserSelectionAction;
import org.openmicroscopy.shoola.agents.treeviewer.actions.ClassifierAction;
import org.openmicroscopy.shoola.agents.treeviewer.actions.ClassifyAction;
import org.openmicroscopy.shoola.agents.treeviewer.actions.ClassifyChildrenAction;
import org.openmicroscopy.shoola.agents.treeviewer.actions.ClearAction;
import org.openmicroscopy.shoola.agents.treeviewer.actions.CopyAction;
import org.openmicroscopy.shoola.agents.treeviewer.actions.CreateAction;
import org.openmicroscopy.shoola.agents.treeviewer.actions.CreateTopContainerAction;
import org.openmicroscopy.shoola.agents.treeviewer.actions.CutAction;
import org.openmicroscopy.shoola.agents.treeviewer.actions.DeleteAction;
import org.openmicroscopy.shoola.agents.treeviewer.actions.ExitApplicationAction;
import org.openmicroscopy.shoola.agents.treeviewer.actions.FinderAction;
import org.openmicroscopy.shoola.agents.treeviewer.actions.ManagerAction;
import org.openmicroscopy.shoola.agents.treeviewer.actions.PasteAction;
import org.openmicroscopy.shoola.agents.treeviewer.actions.PropertiesAction;
import org.openmicroscopy.shoola.agents.treeviewer.actions.RefreshTreeAction;
import org.openmicroscopy.shoola.agents.treeviewer.actions.RollOverAction;
import org.openmicroscopy.shoola.agents.treeviewer.actions.SwitchUserAction;
import org.openmicroscopy.shoola.agents.treeviewer.actions.TreeViewerAction;
import org.openmicroscopy.shoola.agents.treeviewer.actions.ViewAction;
import org.openmicroscopy.shoola.agents.treeviewer.browser.Browser;
import org.openmicroscopy.shoola.agents.treeviewer.browser.TreeImageDisplay;
import org.openmicroscopy.shoola.agents.treeviewer.editors.EditorFactory;
import org.openmicroscopy.shoola.agents.treeviewer.view.TreeViewer;
import org.openmicroscopy.shoola.agents.treeviewer.view.TreeViewerFactory;
import org.openmicroscopy.shoola.agents.treeviewer.view.TreeViewerWin;
import pojos.ExperimenterData;
import pojos.ImageData;

class TreeViewerControl
implements ChangeListener,
PropertyChangeListener {
    static final Integer PROPERTIES = new Integer(0);
    static final Integer VIEW = new Integer(1);
    static final Integer CREATE_OBJECT = new Integer(3);
    static final Integer COPY_OBJECT = new Integer(4);
    static final Integer PASTE_OBJECT = new Integer(5);
    static final Integer DELETE_OBJECT = new Integer(6);
    static final Integer HIERARCHY_EXPLORER = new Integer(7);
    static final Integer CATEGORY_EXPLORER = new Integer(8);
    static final Integer IMAGES_EXPLORER = new Integer(9);
    static final Integer FIND = new Integer(10);
    static final Integer CLASSIFY = new Integer(11);
    static final Integer DECLASSIFY = new Integer(12);
    static final Integer ANNOTATE = new Integer(13);
    static final Integer EXIT = new Integer(14);
    static final Integer CLEAR = new Integer(15);
    static final Integer ADD_OBJECT = new Integer(16);
    static final Integer CREATE_TOP_CONTAINER = new Integer(17);
    static final Integer REFRESH_TREE = new Integer(18);
    static final Integer MANAGER = new Integer(19);
    static final Integer CLASSIFIER = new Integer(20);
    static final Integer CUT_OBJECT = new Integer(21);
    static final Integer ACTIVATION = new Integer(22);
    static final Integer SWITCH_USER = new Integer(23);
    static final Integer ANNOTATE_CHILDREN = new Integer(24);
    static final Integer CLASSIFY_CHILDREN = new Integer(25);
    static final Integer ROLL_OVER = new Integer(26);
    private TreeViewer model;
    private TreeViewerWin view;
    private Map<Integer, TreeViewerAction> actionsMap;
    private ChangeListener tabsListener;

    private void createActions() {
        this.actionsMap.put(PROPERTIES, new PropertiesAction(this.model));
        this.actionsMap.put(VIEW, new ViewAction(this.model));
        this.actionsMap.put(CREATE_OBJECT, new CreateAction(this.model));
        this.actionsMap.put(COPY_OBJECT, new CopyAction(this.model));
        this.actionsMap.put(DELETE_OBJECT, new DeleteAction(this.model));
        this.actionsMap.put(PASTE_OBJECT, new PasteAction(this.model));
        this.actionsMap.put(HIERARCHY_EXPLORER, new BrowserSelectionAction(this.model, 100));
        this.actionsMap.put(CATEGORY_EXPLORER, new BrowserSelectionAction(this.model, 101));
        this.actionsMap.put(IMAGES_EXPLORER, new BrowserSelectionAction(this.model, 102));
        this.actionsMap.put(FIND, new FinderAction(this.model));
        this.actionsMap.put(CLASSIFY, new ClassifyAction(this.model, 0));
        this.actionsMap.put(DECLASSIFY, new ClassifyAction(this.model, 1));
        this.actionsMap.put(ANNOTATE, new AnnotateAction(this.model));
        this.actionsMap.put(CLEAR, new ClearAction(this.model));
        this.actionsMap.put(EXIT, new ExitApplicationAction(this.model));
        this.actionsMap.put(ADD_OBJECT, new AddAction(this.model));
        this.actionsMap.put(CREATE_TOP_CONTAINER, new CreateTopContainerAction(this.model));
        this.actionsMap.put(REFRESH_TREE, new RefreshTreeAction(this.model));
        this.actionsMap.put(CLASSIFIER, new ClassifierAction(this.model));
        this.actionsMap.put(MANAGER, new ManagerAction(this.model));
        this.actionsMap.put(CUT_OBJECT, new CutAction(this.model));
        this.actionsMap.put(ACTIVATION, new ActivationAction(this.model));
        this.actionsMap.put(SWITCH_USER, new SwitchUserAction(this.model));
        this.actionsMap.put(ANNOTATE_CHILDREN, new AnnotateChildrenAction(this.model));
        this.actionsMap.put(CLASSIFY_CHILDREN, new ClassifyChildrenAction(this.model));
        this.actionsMap.put(ROLL_OVER, new RollOverAction(this.model));
    }

    private void createWindowsMenuItems(JMenu menu) {
        Set viewers = TreeViewerFactory.getViewers();
        Iterator i = viewers.iterator();
        menu.removeAll();
        while (i.hasNext()) {
            menu.add(new JMenuItem(new ActivationAction((TreeViewer)i.next())));
        }
    }

    private void attachListeners() {
        Map browsers = this.model.getBrowsers();
        for (Browser browser : browsers.values()) {
            browser.addPropertyChangeListener(this);
            browser.addChangeListener(this);
        }
        this.model.addPropertyChangeListener(this);
        this.view.setDefaultCloseOperation(0);
        this.view.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                TreeViewerControl.this.model.closeWindow();
            }
        });
        JMenu menu = TreeViewerFactory.getWindowMenu();
        menu.addMenuListener(new MenuListener(){

            public void menuSelected(MenuEvent e) {
                Object source = e.getSource();
                if (source instanceof JMenu) {
                    TreeViewerControl.this.createWindowsMenuItems((JMenu)source);
                }
            }

            public void menuCanceled(MenuEvent e) {
            }

            public void menuDeselected(MenuEvent e) {
            }
        });
        menu.addMenuKeyListener(new MenuKeyListener(){

            public void menuKeyReleased(MenuKeyEvent e) {
                Object source = e.getSource();
                if (source instanceof JMenu) {
                    TreeViewerControl.this.createWindowsMenuItems((JMenu)source);
                }
            }

            public void menuKeyPressed(MenuKeyEvent e) {
            }

            public void menuKeyTyped(MenuKeyEvent e) {
            }
        });
    }

    private void resetSelectedDisplay(TreeImageDisplay d) {
        Browser b = this.model.getSelectedBrowser();
        if (b != null) {
            b.setSelectedDisplay(null);
            b.setSelectedDisplay(d);
        }
    }

    TreeViewerControl(TreeViewer model) {
        if (model == null) {
            throw new NullPointerException("No model.");
        }
        this.model = model;
        this.actionsMap = new HashMap<Integer, TreeViewerAction>();
    }

    void initialize(TreeViewerWin view) {
        if (view == null) {
            throw new NullPointerException("No view.");
        }
        this.view = view;
        this.createActions();
        this.model.addChangeListener(this);
        this.attachListeners();
        TreeViewerFactory.attachWindowMenuToTaskBar();
    }

    ChangeListener getTabbedListener() {
        if (this.tabsListener == null) {
            this.tabsListener = new ChangeListener(){

                public void stateChanged(ChangeEvent ce) {
                    JTabbedPane pane = (JTabbedPane)ce.getSource();
                    TreeViewerControl.this.model.clearFoundResults();
                    Component c = pane.getSelectedComponent();
                    if (c == null) {
                        TreeViewerControl.this.model.setSelectedBrowser(null);
                        return;
                    }
                    Map browsers = TreeViewerControl.this.model.getBrowsers();
                    Iterator i = browsers.values().iterator();
                    boolean selected = false;
                    while (i.hasNext()) {
                        Browser browser = (Browser)i.next();
                        if (!c.equals(browser.getUI())) continue;
                        TreeViewerControl.this.model.setSelectedBrowser(browser);
                        selected = true;
                        break;
                    }
                    if (!selected) {
                        TreeViewerControl.this.model.setSelectedBrowser(null);
                    }
                }
            };
        }
        return this.tabsListener;
    }

    void attachUIListeners(JTabbedPane tabs) {
        tabs.addChangeListener(this.getTabbedListener());
    }

    TreeViewerAction getAction(Integer id) {
        return this.actionsMap.get(id);
    }

    void cancel() {
        this.model.cancel();
    }

    public void propertyChange(PropertyChangeEvent pce) {
        Map m;
        Iterator i;
        String name = pce.getPropertyName();
        if (name == null) {
            return;
        }
        if (name.equals("cancelLoading")) {
            Browser browser = this.model.getSelectedBrowser();
            if (browser != null) {
                browser.cancel();
            }
        } else if (name.equals("popupMenu")) {
            Component c = (Component)pce.getNewValue();
            Browser browser = this.model.getSelectedBrowser();
            if (browser != null && c != null) {
                this.view.showPopup(c, browser.getClickPoint());
            }
        } else if (name.equals("close")) {
            Browser browser = (Browser)pce.getNewValue();
            if (browser != null) {
                this.view.removeBrowser(browser);
            }
        } else if (name.equals("closeProfileEditor")) {
            this.model.removeEditor();
            this.model.onComponentStateChange(true);
        } else if (name.equals("closeEditor")) {
            Browser b = this.model.getSelectedBrowser();
            TreeImageDisplay d = null;
            if (b != null) {
                d = b.getLastSelectedDisplay();
            }
            int editorType = this.model.getEditorType();
            this.model.removeEditor();
            this.model.onComponentStateChange(true);
            if (editorType == 100) {
                this.resetSelectedDisplay(d);
            }
        } else if (name.equals("closeClassifier")) {
            Browser b = this.model.getSelectedBrowser();
            if (b != null) {
                this.resetSelectedDisplay(b.getLastSelectedDisplay());
            }
            this.model.onComponentStateChange(true);
        } else if (name.equals("finderVisible")) {
            Boolean b = (Boolean)pce.getNewValue();
            if (!b.booleanValue()) {
                this.model.clearFoundResults();
                this.model.onComponentStateChange(true);
            }
        } else if (name.equals("selectedBrowser")) {
            Browser b = this.model.getSelectedBrowser();
            for (Browser browser : this.model.getBrowsers().values()) {
                browser.setSelected(browser.equals(b));
            }
        } else if (name.equals("thumbnailLoading")) {
            this.model.retrieveThumbnail((ImageData)pce.getNewValue());
        } else if (name.equals("selectedDisplay")) {
            int index;
            TreeImageDisplay d;
            Object oldValue = pce.getOldValue();
            Object newValue = pce.getNewValue();
            if (oldValue != null && newValue != null && !oldValue.getClass().equals(newValue.getClass()) && oldValue instanceof TreeImageDisplay && (d = (TreeImageDisplay)oldValue) != null && d.getUserObject() instanceof ImageData && (index = EditorFactory.getEditorSelectedPane()) == 2) {
                EditorFactory.setEditorSelectedPane(0);
            }
            this.model.onSelectedDisplay();
            this.view.updateMenuItems();
        } else if (name.equals("hierarchyRoot")) {
            Map browsers = this.model.getBrowsers();
            for (Browser browser : browsers.values()) {
                browser.cleanFilteredNodes();
                browser.switchUser();
            }
        } else if (name.equals("existingAdd")) {
            this.model.addExistingObjects((Set)pce.getNewValue());
        } else if (name.equals("savingDataEditor")) {
            boolean b = (Boolean)pce.getNewValue();
            this.model.saveInEditor(b);
        } else if (name.equals("annotated") || name.equals("classified")) {
            if (this.view.getDataHandler() == null) {
                return;
            }
            this.view.discardDataHandler();
            Map browsers = this.model.getBrowsers();
            Iterator i2 = browsers.values().iterator();
            while (i2.hasNext()) {
                ((Browser)i2.next()).refreshTree();
            }
        } else if (name.equals("userSwitch") && (i = (m = (Map)pce.getNewValue()).keySet().iterator()).hasNext()) {
            Long groupID = (Long)i.next();
            ExperimenterData d = (ExperimenterData)m.get(groupID);
            this.model.setHierarchyRoot(groupID, d);
        }
    }

    public void stateChanged(ChangeEvent ce) {
        switch (this.model.getState()) {
            case 2: {
                this.view.closeViewer();
                break;
            }
            case 5: {
                this.view.setStatus("Loading...", false);
                this.view.setStatusIcon(true);
                this.view.onStateChanged(false);
                break;
            }
            case 3: {
                this.view.setStatus("Saving Data", false);
                this.view.setStatusIcon(true);
                this.view.onStateChanged(false);
                break;
            }
            case 6: 
            case 7: {
                this.view.setStatus(null, true);
                this.view.setStatusIcon(false);
                this.view.onStateChanged(true);
            }
        }
    }
}

