/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.treeviewer.view;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JFrame;
import org.openmicroscopy.shoola.agents.treeviewer.IconManager;
import org.openmicroscopy.shoola.agents.treeviewer.TreeViewerAgent;
import org.openmicroscopy.shoola.agents.treeviewer.TreeViewerTranslator;
import org.openmicroscopy.shoola.agents.treeviewer.browser.Browser;
import org.openmicroscopy.shoola.agents.treeviewer.browser.TreeImageDisplay;
import org.openmicroscopy.shoola.agents.treeviewer.cmd.PropertiesCmd;
import org.openmicroscopy.shoola.agents.treeviewer.editors.Editor;
import org.openmicroscopy.shoola.agents.treeviewer.editors.EditorFactory;
import org.openmicroscopy.shoola.agents.treeviewer.editors.EditorSaverDialog;
import org.openmicroscopy.shoola.agents.treeviewer.finder.ClearVisitor;
import org.openmicroscopy.shoola.agents.treeviewer.finder.Finder;
import org.openmicroscopy.shoola.agents.treeviewer.profile.ProfileEditor;
import org.openmicroscopy.shoola.agents.treeviewer.profile.ProfileEditorFactory;
import org.openmicroscopy.shoola.agents.treeviewer.util.AddExistingObjectsDialog;
import org.openmicroscopy.shoola.agents.treeviewer.util.UserManagerDialog;
import org.openmicroscopy.shoola.agents.treeviewer.view.EditorDialog;
import org.openmicroscopy.shoola.agents.treeviewer.view.TreeViewer;
import org.openmicroscopy.shoola.agents.treeviewer.view.TreeViewerControl;
import org.openmicroscopy.shoola.agents.treeviewer.view.TreeViewerFactory;
import org.openmicroscopy.shoola.agents.treeviewer.view.TreeViewerModel;
import org.openmicroscopy.shoola.agents.treeviewer.view.TreeViewerWin;
import org.openmicroscopy.shoola.agents.util.DataHandler;
import org.openmicroscopy.shoola.env.data.events.ExitApplication;
import org.openmicroscopy.shoola.env.event.EventBus;
import org.openmicroscopy.shoola.env.ui.UserNotifier;
import org.openmicroscopy.shoola.util.ui.UIUtilities;
import org.openmicroscopy.shoola.util.ui.component.AbstractComponent;
import pojos.DataObject;
import pojos.ExperimenterData;
import pojos.ImageData;

class TreeViewerComponent
extends AbstractComponent
implements TreeViewer {
    private TreeViewerModel model;
    private TreeViewerControl controller;
    private TreeViewerWin view;
    private EditorDialog editorDialog;
    private EditorSaverDialog saverDialog;

    private void displayUserGroups(Map map) {
        JFrame f = (JFrame)((Object)TreeViewerAgent.getRegistry().getTaskBar());
        UserManagerDialog d = new UserManagerDialog(f, this.model.getUserDetails(), map, this.model.getRootID());
        d.addPropertyChangeListener(this.controller);
        d.pack();
        UIUtilities.centerAndShow(d);
    }

    TreeViewerComponent(TreeViewerModel model) {
        if (model == null) {
            throw new NullPointerException("No model.");
        }
        this.model = model;
        this.controller = new TreeViewerControl(this);
        this.view = new TreeViewerWin();
        Finder f = new Finder(this);
        model.setFinder(f);
        f.addPropertyChangeListener(this.controller);
    }

    void initialize(Rectangle bounds) {
        this.controller.initialize(this.view);
        this.view.initialize(this.controller, this.model, bounds);
    }

    TreeViewerModel getModel() {
        return this.model;
    }

    void setRecycled(boolean b) {
        this.model.setRecycled(b);
    }

    public int getState() {
        return this.model.getState();
    }

    public void activate() {
        switch (this.model.getState()) {
            case 1: {
                this.model.getSelectedBrowser().activate();
                this.view.setOnScreen();
                this.model.setState(7);
                break;
            }
            case 2: {
                throw new IllegalStateException("This method can't be invoked in the DISCARDED state.");
            }
        }
    }

    public Map getBrowsers() {
        return this.model.getBrowsers();
    }

    public void discard() {
        Map browsers = this.getBrowsers();
        Iterator i = browsers.values().iterator();
        while (i.hasNext()) {
            ((Browser)i.next()).discard();
        }
        this.model.discard();
        this.fireStateChange();
    }

    public Browser getSelectedBrowser() {
        return this.model.getSelectedBrowser();
    }

    public void setSelectedBrowser(Browser browser) {
        switch (this.model.getState()) {
            case 2: 
            case 3: {
                throw new IllegalStateException("This method cannot be invoked in the DISCARDED or SAVE state.");
            }
        }
        Browser oldBrowser = this.model.getSelectedBrowser();
        if (oldBrowser == null || !oldBrowser.equals(browser)) {
            this.model.setSelectedBrowser(browser);
            if (browser != null) {
                browser.activate();
            }
            this.removeEditor();
            this.firePropertyChange("selectedBrowser", oldBrowser, browser);
        }
        this.view.updateMenuItems();
    }

    public void displayBrowser(int browserType) {
        switch (this.model.getState()) {
            case 2: 
            case 3: {
                throw new IllegalStateException("This method cannot be invoked in the DISCARDED or SAVE state.");
            }
        }
        Map browsers = this.model.getBrowsers();
        Browser browser = (Browser)browsers.get(new Integer(browserType));
        if (browser.isDisplayed()) {
            this.view.removeBrowser(browser);
        } else {
            this.model.setSelectedBrowser(browser);
            this.view.addBrowser(browser);
        }
        browser.setDisplayed(!browser.isDisplayed());
    }

    public void showProperties(DataObject object, int editorType) {
        switch (this.model.getState()) {
            case 2: 
            case 3: {
                throw new IllegalStateException("This method cannot be invoked in the DISCARDED or SAVE state.");
            }
        }
        TreeImageDisplay parent = null;
        switch (editorType) {
            case 101: {
                break;
            }
            case 100: {
                parent = this.model.getSelectedBrowser().getLastSelectedDisplay();
                break;
            }
            default: {
                throw new IllegalArgumentException("This method only supports the PROPERTIES_EDITOR and CREATE_EDITOR.");
            }
        }
        this.removeEditor();
        if (object == null) {
            return;
        }
        if (object instanceof ExperimenterData) {
            ExperimenterData exp = (ExperimenterData)object;
            if (exp.getId() != this.model.getUserDetails().getId()) {
                return;
            }
            ProfileEditor pEditor = ProfileEditorFactory.getEditor(exp);
            pEditor.addPropertyChangeListener(this.controller);
            pEditor.activate();
            this.view.addComponent(pEditor.getUI());
            return;
        }
        this.model.setEditorType(editorType);
        Editor editor = EditorFactory.getEditor(this, object, editorType, parent);
        editor.addPropertyChangeListener(this.controller);
        editor.activate();
        this.model.setEditor(editor);
        if (editorType == 100) {
            this.editorDialog = new EditorDialog(this.view, editor);
            UIUtilities.centerAndShow(this.editorDialog);
            this.onComponentStateChange(false);
        } else {
            editor.addSiblings(this.model.getSelectedBrowser().getSelectedDataObjects());
            this.view.addComponent(editor.getUI());
            editor.setDefaultButton(this.view.getRootPane());
        }
    }

    public void cancel() {
        if (this.model.getState() != 2) {
            this.model.cancel();
            this.fireStateChange();
        }
    }

    public void removeEditor() {
        switch (this.model.getState()) {
            case 2: {
                throw new IllegalStateException("This method cannot be invoked in the DISCARDED, SAVE state.");
            }
        }
        if (this.editorDialog != null) {
            this.editorDialog.close();
        }
        this.model.setEditorType(103);
        this.view.removeAllFromWorkingPane();
        this.firePropertyChange("removeEditor", Boolean.FALSE, Boolean.TRUE);
    }

    public ExperimenterData getUserDetails() {
        return this.model.getUserDetails();
    }

    public void showFinder(boolean b) {
        switch (this.model.getState()) {
            case 2: {
                throw new IllegalStateException("This method should cannot be invoked in the DISCARDED state.");
            }
        }
        if (this.model.getSelectedBrowser() == null) {
            return;
        }
        Finder finder = this.model.getFinder();
        if (b == finder.isDisplay()) {
            return;
        }
        Boolean oldValue = finder.isDisplay() ? Boolean.TRUE : Boolean.FALSE;
        Boolean newValue = b ? Boolean.TRUE : Boolean.FALSE;
        this.view.showFinder(b);
        this.firePropertyChange("finderVisible", oldValue, newValue);
    }

    public void closeWindow() {
        this.cancel();
        if (TreeViewerFactory.isLastViewer()) {
            EventBus bus = TreeViewerAgent.getRegistry().getEventBus();
            bus.post(new ExitApplication());
        } else {
            this.discard();
        }
    }

    public void removeObject(TreeImageDisplay node) {
        if (node == null) {
            throw new IllegalArgumentException("No node to remove.");
        }
        if (!(node.getUserObject() instanceof DataObject)) {
            throw new IllegalArgumentException("Can only remove DataObject.");
        }
        this.model.fireDataObjectsDeletion(node);
        this.fireStateChange();
    }

    public void removeObjects(List nodes) {
        this.model.fireDataObjectsDeletion(nodes);
        this.fireStateChange();
    }

    public void showClassifier(ImageData[] images, int mode) {
        switch (this.model.getState()) {
            case 2: {
                throw new IllegalStateException("This method should cannot be invoked in the DISCARDED state.");
            }
        }
        if (images == null) {
            throw new IllegalArgumentException("Object cannot be null.");
        }
        if (images.length == 0) {
            throw new IllegalArgumentException("No images to classify or declassify.");
        }
        DataHandler dh = this.model.classifyImageObjects(this.view, images, mode);
        dh.addPropertyChangeListener(this.controller);
        dh.activate();
    }

    public void setThumbnail(BufferedImage thumbnail) {
        if (this.model.getState() == 4) {
            this.model.setState(7);
            Editor editor = this.model.getEditor();
            if (thumbnail != null && editor != null) {
                editor.setThumbnail(thumbnail);
            }
            this.fireStateChange();
        }
    }

    public void retrieveThumbnail(ImageData image) {
        if (this.model.getState() != 2) {
            if (image == null) {
                throw new IllegalArgumentException("No image.");
            }
            this.model.fireThumbnailLoading(image);
            this.fireStateChange();
        }
    }

    public void onSelectedDisplay() {
        switch (this.model.getState()) {
            case 2: 
            case 3: {
                throw new IllegalStateException("This method cannot be invoked in the DISCARDED, SAVE state.");
            }
        }
        int editor = this.model.getEditorType();
        this.removeEditor();
        if (editor != 100) {
            PropertiesCmd cmd = new PropertiesCmd(this);
            cmd.execute();
        }
    }

    public void onDataObjectSave(DataObject data, int operation) {
        int state = this.model.getState();
        if (operation == 302 && state != 3) {
            throw new IllegalStateException("This method can only be invoked in the SAVE state");
        }
        switch (state) {
            case 2: {
                throw new IllegalStateException("This method cannot be invoked in the DISCARDED state");
            }
        }
        if (data == null) {
            throw new IllegalArgumentException("No data object. ");
        }
        switch (operation) {
            case 300: 
            case 301: 
            case 302: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Save operation not supported.");
            }
        }
        this.model.setEditor(null);
        if (operation == 302) {
            this.model.setState(7);
            this.fireStateChange();
        }
        this.view.setCursor(Cursor.getPredefinedCursor(3));
        Browser browser = this.model.getSelectedBrowser();
        browser.refreshEdition(data, operation);
        if (operation == 301) {
            Map browsers = this.model.getBrowsers();
            Iterator i = browsers.keySet().iterator();
            while (i.hasNext()) {
                browser = (Browser)browsers.get(i.next());
                if (browser.equals(this.model.getSelectedBrowser())) continue;
                browser.refreshEdition(data, operation);
            }
        }
        this.onSelectedDisplay();
        if (this.saverDialog != null) {
            this.saverDialog.close();
            this.saverDialog = null;
        }
        this.setStatus(false, "", true);
        this.view.setCursor(Cursor.getPredefinedCursor(0));
    }

    public void onNodesRemoved() {
        if (this.model.getState() != 3) {
            throw new IllegalStateException("This method can only be invoked in the SAVE state");
        }
        this.model.setState(7);
        this.fireStateChange();
        this.view.setCursor(Cursor.getPredefinedCursor(3));
        Map browsers = this.model.getBrowsers();
        Iterator i = browsers.keySet().iterator();
        while (i.hasNext()) {
            Browser browser = (Browser)browsers.get(i.next());
            browser.refreshTree();
        }
        this.model.setEditor(null);
        this.onSelectedDisplay();
        this.setStatus(false, "", true);
        this.view.setCursor(Cursor.getPredefinedCursor(0));
    }

    public void clearFoundResults() {
        switch (this.model.getState()) {
            case 2: 
            case 3: {
                throw new IllegalStateException("This method cannot be invoked in the DISCARDED, SAVE or LOADING_THUMBNAIL state");
            }
        }
        this.removeEditor();
        Browser browser = this.model.getSelectedBrowser();
        this.view.setCursor(Cursor.getPredefinedCursor(3));
        if (browser != null) {
            browser.accept(new ClearVisitor());
            browser.setFoundInBrowser(null);
        }
        this.view.setCursor(Cursor.getPredefinedCursor(0));
    }

    public void onImageClassified(ImageData[] images, Set categories, int mode) {
        switch (this.model.getState()) {
            case 2: {
                throw new IllegalStateException("This method cannot be invoked in the DISCARDED, SAVE or LOADING_THUMBNAIL state");
            }
        }
        if (categories == null) {
            throw new IllegalArgumentException("Categories shouln't be null.");
        }
        if (images == null) {
            throw new IllegalArgumentException("No image.");
        }
        if (images.length == 0) {
            throw new IllegalArgumentException("No image.");
        }
        if (mode != 0 && mode != 1) {
            throw new IllegalArgumentException("Classification mode not supported.");
        }
        TreeImageDisplay d = this.getSelectedBrowser().getLastSelectedDisplay();
        Map browsers = this.model.getBrowsers();
        Iterator b = browsers.keySet().iterator();
        this.view.setCursor(Cursor.getPredefinedCursor(3));
        while (b.hasNext()) {
            Browser browser = (Browser)browsers.get(b.next());
            browser.refreshTree();
        }
        this.getSelectedBrowser().setSelectedDisplay(d);
        this.view.setCursor(Cursor.getPredefinedCursor(0));
    }

    public void moveToBack() {
        if (this.model.getState() == 2) {
            throw new IllegalStateException("This method cannot be invoked in the DISCARDED state.");
        }
        this.view.toBack();
    }

    public void moveToFront() {
        if (this.model.getState() == 2) {
            throw new IllegalStateException("This method cannot be invoked in the DISCARDED state.");
        }
        this.view.toFront();
    }

    public long getRootID() {
        if (this.model.getState() == 2) {
            throw new IllegalStateException("This method cannot be invoked in the DISCARDED state.");
        }
        return this.model.getRootID();
    }

    public void setHierarchyRoot(long userGroupID, ExperimenterData experimenter) {
        if (this.model.getState() == 2) {
            throw new IllegalStateException("This method cannot be invoked in the DISCARDED state.");
        }
        if (experimenter == null) {
            return;
        }
        TreeViewer viewer = TreeViewerFactory.getTreeViewer(experimenter, userGroupID, this.view.getBounds());
        EditorFactory.setEditorSelectedPane(101);
        EditorFactory.setSubSelectedPane(0);
        if (viewer != null) {
            if (viewer.isRecycled()) {
                viewer.moveToFront();
            } else {
                viewer.activate();
            }
        }
    }

    public boolean isObjectWritable(Object ho) {
        if (this.model.getState() == 2) {
            throw new IllegalStateException("This method cannot be invoked in the DISCARDED state.");
        }
        long id = this.model.getUserDetails().getId();
        long groupId = this.model.getUserDetails().getDefaultGroup().getId();
        return TreeViewerTranslator.isWritable(ho, id, groupId);
    }

    public void addExistingObjects(DataObject ho) {
        if (this.model.getState() == 2) {
            throw new IllegalStateException("This method cannot be invoked in the DISCARDED state.");
        }
        if (ho == null) {
            throw new IllegalArgumentException("No object.");
        }
        this.view.setCursor(Cursor.getPredefinedCursor(3));
        this.model.fireDataExistingObjectsLoader(ho);
        this.fireStateChange();
    }

    public void setExistingObjects(Set nodes) {
        if (this.model.getState() != 5) {
            throw new IllegalStateException("This method cannot be invoked in the LOADING_DATA state.");
        }
        if (nodes == null) {
            throw new IllegalArgumentException("Nodes cannot be null.");
        }
        this.view.setCursor(Cursor.getPredefinedCursor(0));
        Set n = TreeViewerTranslator.transformIntoCheckNodes(nodes, this.getUserDetails().getId(), this.model.getUserGroupID());
        this.model.setState(6);
        AddExistingObjectsDialog dialog = new AddExistingObjectsDialog(this.view, n);
        dialog.addPropertyChangeListener(this.controller);
        UIUtilities.centerAndShow(dialog);
    }

    public void addExistingObjects(Set set) {
        if (this.model.getState() != 6) {
            throw new IllegalStateException("This method cannot be invoked in the LOADING_DATA state.");
        }
        this.view.setCursor(Cursor.getPredefinedCursor(3));
        if (set == null || set.size() == 0) {
            this.model.setState(7);
        } else {
            this.model.fireAddExistingObjects(set);
        }
        this.fireStateChange();
    }

    public void navigate() {
        if (this.model.getState() == 2) {
            throw new IllegalStateException("This method cannot be invoked in the DISCARDED state.");
        }
        Browser b = this.model.getSelectedBrowser();
        if (b != null) {
            b.navigate(false);
        }
    }

    public void showMenu(int menuID, Component c, Point p) {
        if (this.model.getState() == 2) {
            throw new IllegalStateException("This method cannot be invoked in the DISCARDED state.");
        }
        switch (menuID) {
            case 0: 
            case 1: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Menu not supported.");
            }
        }
        this.view.showMenu(menuID, c, p);
    }

    public void setStatus(boolean enable, String text, boolean hide) {
        this.view.setStatus(text, hide);
        this.view.setStatusIcon(enable);
    }

    public void onComponentStateChange(boolean b) {
        if (this.model.getState() == 2) {
            throw new IllegalStateException("This method cannot be invoked in the DISCARDED state.");
        }
        Browser browser = this.model.getSelectedBrowser();
        if (browser != null) {
            browser.onComponentStateChange(b);
        }
        Boolean oldValue = Boolean.TRUE;
        if (b) {
            oldValue = Boolean.FALSE;
        }
        this.view.onStateChanged(b);
        this.firePropertyChange("onComponentStateChanged", oldValue, new Boolean(b));
    }

    public void setNodesToCopy(TreeImageDisplay[] nodes, int index) {
        if (this.model.getState() == 2) {
            throw new IllegalStateException("This method cannot be invoked in the DISCARDED state.");
        }
        if (nodes == null || nodes.length == 0) {
            UserNotifier un = TreeViewerAgent.getRegistry().getUserNotifier();
            un.notifyInfo("Copy action", "You first need to select the nodes to copy.");
            return;
        }
        switch (index) {
            case 400: 
            case 401: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Index not supported.");
            }
        }
        this.model.setNodesToCopy(nodes, index);
    }

    public void paste(TreeImageDisplay[] parents) {
        TreeImageDisplay[] nodes;
        if (this.model.getState() == 2) {
            throw new IllegalStateException("This method cannot be invoked in the DISCARDED state.");
        }
        UserNotifier un = TreeViewerAgent.getRegistry().getUserNotifier();
        if (parents == null || parents.length == 0) {
            un.notifyInfo("Paste action", "You first need to select the nodes to copy into");
        }
        if ((nodes = this.model.getNodesToCopy()) == null || nodes.length == 0) {
            return;
        }
        boolean b = this.model.paste(parents);
        if (!b) {
            un.notifyInfo("Paste action", "The nodes to copy cannot be added to the selected nodes.");
        } else {
            this.fireStateChange();
        }
    }

    public void saveInEditor(boolean b) {
        if (this.model.getState() == 2) {
            throw new IllegalStateException("This method cannot be invoked in the DISCARDED state.");
        }
        if (b) {
            this.model.getEditor().saveData();
            this.model.setEditor(null);
        } else {
            if (this.saverDialog != null) {
                this.saverDialog.close();
                this.saverDialog = null;
            }
            this.model.setEditor(null);
            this.removeEditor();
        }
    }

    public JFrame getUI() {
        if (this.model.getState() == 2) {
            throw new IllegalStateException("This method cannot be invoked in the DISCARDED state.");
        }
        return this.view;
    }

    public void setEditorSelectedPane(int index) {
        if (this.model.getState() == 2) {
            throw new IllegalStateException("This method cannot be invoked in the DISCARDED state.");
        }
        if (this.model.getEditorType() == 101) {
            EditorFactory.setEditorSelectedPane(index);
        }
    }

    public int getEditorType() {
        if (this.model.getState() == 2) {
            throw new IllegalStateException("This method cannot be invoked in the DISCARDED state.");
        }
        return this.model.getEditorType();
    }

    public void annotate(TreeImageDisplay[] nodes) {
        if (this.model.getState() == 2) {
            throw new IllegalStateException("This method cannot be invoked in the DISCARDED state.");
        }
        if (nodes == null) {
            throw new IllegalArgumentException("No dataObject to annotate");
        }
        if (nodes.length == 1) {
            PropertiesCmd cmd = new PropertiesCmd(this);
            cmd.execute();
            return;
        }
        DataHandler dh = this.model.annotateDataObjects(this.view, nodes);
        dh.addPropertyChangeListener(this.controller);
        dh.activate();
    }

    public boolean hasDataToSave() {
        Editor editor = this.model.getEditor();
        if (editor == null) {
            return false;
        }
        return editor.hasDataToSave();
    }

    public void showPreSavingDialog() {
        Editor editor = this.model.getEditor();
        if (editor == null) {
            return;
        }
        if (!editor.hasDataToSave()) {
            return;
        }
        IconManager icons = IconManager.getInstance();
        this.saverDialog = new EditorSaverDialog(this.view, icons.getIcon(IconManager.QUESTION));
        this.saverDialog.addPropertyChangeListener("savingDataEditor", this.controller);
        UIUtilities.centerAndShow(this.saverDialog);
    }

    public long getUserGroupID() {
        if (this.model.getState() == 2) {
            throw new IllegalStateException("This method cannot be invoked in the DISCARDED state.");
        }
        return this.model.getUserGroupID();
    }

    public void setAvailableGroups(Map map) {
        if (this.model.getState() != 5) {
            return;
        }
        this.model.setUserGroups(map);
        this.displayUserGroups(map);
        this.fireStateChange();
    }

    public void retrieveUserGroups() {
        if (this.model.getState() == 2) {
            throw new IllegalStateException("This method cannot be invoked in the DISCARDED state.");
        }
        Map m = this.model.getAvailableUserGroups();
        if (m == null) {
            this.model.fireUserGroupsRetrieval();
            this.fireStateChange();
        } else {
            this.displayUserGroups(m);
        }
    }

    public String getExperimenterNames() {
        if (this.model.getState() == 2) {
            throw new IllegalStateException("This method cannot be invoked in the DISCARDED state.");
        }
        return this.model.getExperimenterNames();
    }

    public ExperimenterData getSelectedExperimenter() {
        if (this.model.getState() == 2) {
            throw new IllegalStateException("This method cannot be invoked in the DISCARDED state.");
        }
        return this.model.getExperimenter();
    }

    public void annotateChildren(TreeImageDisplay node) {
        if (this.model.getState() == 2) {
            throw new IllegalStateException("This method cannot be invoked in the DISCARDED state.");
        }
        if (node == null) {
            throw new IllegalArgumentException("No specified container.");
        }
        DataHandler dh = this.model.annotateChildren(this.view, node);
        dh.addPropertyChangeListener(this.controller);
        dh.activate();
    }

    public void classifyChildren(TreeImageDisplay node) {
        if (this.model.getState() == 2) {
            throw new IllegalStateException("This method cannot be invoked in the DISCARDED state.");
        }
        if (node == null) {
            throw new IllegalArgumentException("No specified container.");
        }
        DataHandler dh = this.model.classifyChildren(this.view, node);
        dh.addPropertyChangeListener(this.controller);
        dh.activate();
    }

    public boolean isRecycled() {
        if (this.model.getState() == 2) {
            throw new IllegalStateException("This method cannot be invoked in the DISCARDED state.");
        }
        return this.model.isRecycled();
    }

    public boolean isRollOver() {
        if (this.model.getState() == 2) {
            throw new IllegalStateException("This method cannot be invoked in the DISCARDED state.");
        }
        return this.model.isRollOver();
    }

    public void setRollOver(boolean rollOver) {
        if (this.model.getState() == 2) {
            throw new IllegalStateException("This method cannot be invoked in the DISCARDED state.");
        }
        this.model.setRollOver(rollOver);
    }

    public boolean isForCurrentUser() {
        if (this.model.getState() == 2) {
            throw new IllegalStateException("This method cannot be invoked in the DISCARDED state.");
        }
        long userID = this.model.getUserDetails().getId();
        return userID == this.model.getRootID();
    }

    public boolean isReadable(DataObject ho) {
        if (this.model.getState() == 2) {
            throw new IllegalStateException("This method cannot be invoked in the DISCARDED state.");
        }
        long id = this.model.getUserDetails().getId();
        long groupId = this.model.getUserDetails().getDefaultGroup().getId();
        return TreeViewerTranslator.isReadable(ho, id, groupId);
    }
}

