/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.treeviewer.view;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Point;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JToolBar;
import org.openmicroscopy.shoola.agents.treeviewer.actions.ClassifierAction;
import org.openmicroscopy.shoola.agents.treeviewer.actions.ManagerAction;
import org.openmicroscopy.shoola.agents.treeviewer.actions.TreeViewerAction;
import org.openmicroscopy.shoola.agents.treeviewer.view.ClassifyPopupMenu;
import org.openmicroscopy.shoola.agents.treeviewer.view.ManagePopupMenu;
import org.openmicroscopy.shoola.agents.treeviewer.view.TreeViewerControl;
import org.openmicroscopy.shoola.util.ui.UIUtilities;

class ToolBar
extends JPanel {
    private static final Dimension HBOX = new Dimension(100, 16);
    private TreeViewerControl controller;

    private JToolBar createManagementBar() {
        JToolBar bar = new JToolBar();
        bar.setFloatable(false);
        bar.setRollover(true);
        bar.setBorder(null);
        JButton b = new JButton(this.controller.getAction(TreeViewerControl.VIEW));
        UIUtilities.unifiedButtonLookAndFeel(b);
        bar.add(b);
        b = new JButton(this.controller.getAction(TreeViewerControl.REFRESH_TREE));
        UIUtilities.unifiedButtonLookAndFeel(b);
        bar.add(b);
        bar.add(new JSeparator(1));
        TreeViewerAction a = this.controller.getAction(TreeViewerControl.MANAGER);
        b = new JButton(a);
        UIUtilities.unifiedButtonLookAndFeel(b);
        b.addMouseListener((ManagerAction)a);
        bar.add(b);
        b = new JButton(this.controller.getAction(TreeViewerControl.CREATE_TOP_CONTAINER));
        UIUtilities.unifiedButtonLookAndFeel(b);
        bar.add(b);
        b = new JButton(this.controller.getAction(TreeViewerControl.CREATE_OBJECT));
        UIUtilities.unifiedButtonLookAndFeel(b);
        bar.add(b);
        b = new JButton(this.controller.getAction(TreeViewerControl.SWITCH_USER));
        UIUtilities.unifiedButtonLookAndFeel(b);
        bar.add(b);
        bar.add(new JSeparator(1));
        return bar;
    }

    private JToolBar createEditBar() {
        JToolBar bar = new JToolBar();
        bar.setFloatable(false);
        bar.setRollover(true);
        bar.setBorder(null);
        JButton b = new JButton(this.controller.getAction(TreeViewerControl.ANNOTATE));
        UIUtilities.unifiedButtonLookAndFeel(b);
        bar.add(b);
        TreeViewerAction a = this.controller.getAction(TreeViewerControl.CLASSIFIER);
        b = new JButton(a);
        b.addMouseListener((ClassifierAction)a);
        UIUtilities.unifiedButtonLookAndFeel(b);
        bar.add(b);
        b = new JButton(this.controller.getAction(TreeViewerControl.PROPERTIES));
        UIUtilities.unifiedButtonLookAndFeel(b);
        return bar;
    }

    private void buildGUI() {
        JPanel bars = new JPanel();
        JPanel outerPanel = new JPanel();
        bars.setBorder(null);
        bars.setLayout(new BoxLayout(bars, 0));
        bars.add(this.createManagementBar());
        bars.add(this.createEditBar());
        outerPanel.setBorder(null);
        outerPanel.setLayout(new BoxLayout(outerPanel, 0));
        outerPanel.add(bars);
        outerPanel.add(Box.createRigidArea(HBOX));
        outerPanel.add(Box.createHorizontalGlue());
        this.setLayout(new FlowLayout(0));
        this.add(outerPanel);
    }

    ToolBar(TreeViewerControl controller) {
        if (controller == null) {
            throw new NullPointerException("No controller.");
        }
        this.controller = controller;
        this.buildGUI();
    }

    void showManagementMenu(Component c, Point p) {
        if (c == null) {
            throw new IllegalArgumentException("No component.");
        }
        if (p == null) {
            throw new IllegalArgumentException("No point.");
        }
        ManagePopupMenu managePopupMenu = new ManagePopupMenu(this.controller);
        managePopupMenu.show(c, p.x, p.y);
    }

    void showClassifyMenu(Component c, Point p) {
        if (c == null) {
            throw new IllegalArgumentException("No component.");
        }
        if (p == null) {
            throw new IllegalArgumentException("No point.");
        }
        ClassifyPopupMenu classifyPopupMenu = new ClassifyPopupMenu(this.controller);
        classifyPopupMenu.show(c, p.x, p.y);
    }
}

