/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.treeviewer.view;

import java.awt.Font;
import javax.swing.BorderFactory;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import org.openmicroscopy.shoola.agents.treeviewer.IconManager;
import org.openmicroscopy.shoola.agents.treeviewer.TreeViewerAgent;
import org.openmicroscopy.shoola.agents.treeviewer.actions.TreeViewerAction;
import org.openmicroscopy.shoola.agents.treeviewer.view.TreeViewerControl;

class PopupMenu
extends JPopupMenu {
    private JMenuItem properties;
    private JMenuItem annotate;
    private JMenuItem view;
    private JMenuItem existingElement;
    private JMenuItem newElement;
    private JMenuItem cutElement;
    private JMenuItem copyElement;
    private JMenuItem pasteElement;
    private JMenuItem deleteElement;
    private JMenuItem classifyElement;
    private JMenuItem declassifyElement;
    private JMenuItem classifyChildrenElement;
    private JMenuItem annotateChildrenElement;
    private TreeViewerControl controller;

    private void initMenuItem(JMenuItem item, String name) {
        item.setText(name);
        item.setBorder(null);
        item.setFont((Font)TreeViewerAgent.getRegistry().lookup("/resources/fonts/Labels"));
    }

    private void createMenuItems() {
        TreeViewerAction a = this.controller.getAction(TreeViewerControl.PROPERTIES);
        this.properties = new JMenuItem(a);
        this.initMenuItem(this.properties, a.getActionName());
        a = this.controller.getAction(TreeViewerControl.ANNOTATE);
        this.annotate = new JMenuItem(a);
        this.initMenuItem(this.annotate, a.getActionName());
        a = this.controller.getAction(TreeViewerControl.VIEW);
        this.view = new JMenuItem(a);
        this.initMenuItem(this.view, a.getActionName());
        a = this.controller.getAction(TreeViewerControl.CREATE_OBJECT);
        this.newElement = new JMenuItem(a);
        this.initMenuItem(this.newElement, a.getActionName());
        a = this.controller.getAction(TreeViewerControl.CUT_OBJECT);
        this.cutElement = new JMenuItem(a);
        this.initMenuItem(this.cutElement, a.getActionName());
        a = this.controller.getAction(TreeViewerControl.COPY_OBJECT);
        this.copyElement = new JMenuItem(a);
        this.initMenuItem(this.copyElement, a.getActionName());
        a = this.controller.getAction(TreeViewerControl.PASTE_OBJECT);
        this.pasteElement = new JMenuItem(a);
        this.initMenuItem(this.pasteElement, a.getActionName());
        a = this.controller.getAction(TreeViewerControl.DELETE_OBJECT);
        this.deleteElement = new JMenuItem(a);
        this.initMenuItem(this.deleteElement, a.getActionName());
        a = this.controller.getAction(TreeViewerControl.ADD_OBJECT);
        this.existingElement = new JMenuItem(a);
        this.initMenuItem(this.existingElement, a.getActionName());
        a = this.controller.getAction(TreeViewerControl.CLASSIFY);
        this.classifyElement = new JMenuItem(a);
        this.initMenuItem(this.classifyElement, a.getActionName());
        a = this.controller.getAction(TreeViewerControl.DECLASSIFY);
        this.declassifyElement = new JMenuItem(a);
        this.initMenuItem(this.declassifyElement, a.getActionName());
        a = this.controller.getAction(TreeViewerControl.ANNOTATE_CHILDREN);
        this.annotateChildrenElement = new JMenuItem(a);
        this.initMenuItem(this.annotateChildrenElement, a.getActionName());
        a = this.controller.getAction(TreeViewerControl.CLASSIFY_CHILDREN);
        this.classifyChildrenElement = new JMenuItem(a);
        this.initMenuItem(this.classifyChildrenElement, a.getActionName());
    }

    private JMenu createManagementMenu() {
        JMenu managementMenu = new JMenu();
        this.initMenuItem(managementMenu, "Manage");
        IconManager im = IconManager.getInstance();
        managementMenu.setIcon(im.getIcon(IconManager.TRANSPARENT));
        managementMenu.add(this.newElement);
        managementMenu.add(this.cutElement);
        managementMenu.add(this.copyElement);
        managementMenu.add(this.pasteElement);
        managementMenu.add(this.deleteElement);
        return managementMenu;
    }

    private void buildGUI() {
        this.setBorder(BorderFactory.createBevelBorder(0));
        this.add(this.view);
        this.add(this.createManagementMenu());
        this.add(new JSeparator(0));
        this.add(this.classifyElement);
        this.add(this.declassifyElement);
        this.add(this.classifyChildrenElement);
        this.add(new JSeparator(0));
        this.add(this.annotate);
        this.add(this.annotateChildrenElement);
        this.add(new JSeparator(0));
        this.add(this.properties);
    }

    PopupMenu(TreeViewerControl controller) {
        if (controller == null) {
            throw new IllegalArgumentException("No control.");
        }
        this.controller = controller;
        this.createMenuItems();
        this.buildGUI();
    }
}

