/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.treeviewer.util;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import layout.TableLayout;
import org.openmicroscopy.shoola.agents.treeviewer.IconManager;
import org.openmicroscopy.shoola.agents.treeviewer.TreeViewerAgent;
import org.openmicroscopy.shoola.agents.treeviewer.util.GroupsRenderer;
import org.openmicroscopy.shoola.agents.treeviewer.util.UserListRenderer;
import org.openmicroscopy.shoola.agents.util.ViewerSorter;
import org.openmicroscopy.shoola.env.ui.UserNotifier;
import org.openmicroscopy.shoola.util.ui.TitlePanel;
import org.openmicroscopy.shoola.util.ui.UIUtilities;
import pojos.ExperimenterData;
import pojos.GroupData;

public class UserManagerDialog
extends JDialog {
    public static final String USER_SWITCH_PROPERTY = "userSwitch";
    private static final String TITLE = "Switch user";
    private static final String TEXT = "Select a user.";
    private static final String CANCEL_DESCRIPTION = "Close the window.";
    private static final String APPLY_DESCRIPTION = "View selected user's data.";
    private static final String MYSELF_DESCRIPTION = "View my data.";
    private static final Dimension H_SPACER_SIZE = new Dimension(5, 10);
    private JButton cancel;
    private JButton apply;
    private JButton mySelf;
    private JComboBox groups;
    private JList users;
    private ExperimenterData loggedUser;
    private ViewerSorter sorter;
    private Map<GroupData, Object[]> orderedMap;

    private void cancel() {
        this.setVisible(false);
        this.dispose();
    }

    private void apply() {
        HashMap<Long, ExperimenterData> r = new HashMap<Long, ExperimenterData>(1);
        GroupData g = (GroupData)this.groups.getSelectedItem();
        Object user = this.users.getSelectedValue();
        if (user == null) {
            UserNotifier un = TreeViewerAgent.getRegistry().getUserNotifier();
            un.notifyInfo(TITLE, "Please select a user first.");
            return;
        }
        r.put(new Long(g.getId()), (ExperimenterData)user);
        this.firePropertyChange(USER_SWITCH_PROPERTY, null, r);
        this.cancel();
    }

    private void setProperties() {
        this.setModal(true);
        this.setTitle(TITLE);
    }

    private void fillList(Object[] data) {
        if (data == null) {
            return;
        }
        DefaultListModel model = (DefaultListModel)this.users.getModel();
        int index = 0;
        for (int i = 0; i < data.length; ++i) {
            ExperimenterData d = (ExperimenterData)data[i];
            if (d.getId() == this.loggedUser.getId()) continue;
            model.add(index, d);
            ++index;
        }
    }

    private void attachListeners() {
        this.setDefaultCloseOperation(0);
        this.cancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                UserManagerDialog.this.cancel();
            }
        });
        this.apply.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                UserManagerDialog.this.apply();
            }
        });
        this.mySelf.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                HashMap<Long, ExperimenterData> r = new HashMap<Long, ExperimenterData>(1);
                r.put(new Long(UserManagerDialog.this.loggedUser.getDefaultGroup().getId()), UserManagerDialog.this.loggedUser);
                UserManagerDialog.this.firePropertyChange(UserManagerDialog.USER_SWITCH_PROPERTY, null, r);
                UserManagerDialog.this.cancel();
            }
        });
        this.groups.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DefaultListModel model = (DefaultListModel)UserManagerDialog.this.users.getModel();
                model.clear();
                UserManagerDialog.this.fillList((Object[])UserManagerDialog.this.orderedMap.get(UserManagerDialog.this.groups.getSelectedItem()));
            }
        });
        this.users.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                ListSelectionModel lsm = (ListSelectionModel)e.getSource();
                UserManagerDialog.this.apply.setEnabled(!lsm.isSelectionEmpty());
            }
        });
    }

    private void initComponents(Map map, long userID) {
        this.sorter = new ViewerSorter();
        this.orderedMap = new HashMap<GroupData, Object[]>();
        this.cancel = new JButton("Cancel");
        this.cancel.setToolTipText(UIUtilities.formatToolTipText(CANCEL_DESCRIPTION));
        this.apply = new JButton("Apply");
        this.apply.setEnabled(false);
        this.apply.setToolTipText(UIUtilities.formatToolTipText(APPLY_DESCRIPTION));
        this.getRootPane().setDefaultButton(this.apply);
        this.mySelf = new JButton("Myself");
        this.mySelf.setToolTipText(UIUtilities.formatToolTipText(MYSELF_DESCRIPTION));
        this.mySelf.setEnabled(userID != this.loggedUser.getId());
        GroupData defaultGroup = this.loggedUser.getDefaultGroup();
        long groupID = defaultGroup.getId();
        Iterator i = map.keySet().iterator();
        GroupData[] objects = new GroupData[map.size()];
        int selectedIndex = 0;
        int index = 0;
        GroupData selectedGroup = defaultGroup;
        while (i.hasNext()) {
            GroupData g;
            objects[index] = g = (GroupData)i.next();
            if (g.getId() == groupID) {
                selectedIndex = index;
                selectedGroup = g;
            }
            Object[] children = this.sorter.sortArray((Set)map.get(g));
            this.orderedMap.put(g, children);
            ++index;
        }
        this.groups = new JComboBox<GroupData>(objects);
        this.groups.setRenderer(new GroupsRenderer());
        if (objects.length != 0) {
            this.groups.setSelectedIndex(selectedIndex);
        }
        DefaultListModel model = new DefaultListModel();
        this.users = new JList(model);
        this.fillList(this.orderedMap.get(selectedGroup));
        this.users.setSelectionMode(1);
        this.users.setLayoutOrientation(0);
        this.users.setCellRenderer(new UserListRenderer());
    }

    private JPanel buildContent() {
        double[][] tl = new double[][]{{-2.0, -1.0}, {-2.0, 5.0, -2.0, -1.0}};
        JPanel content = new JPanel();
        content.setBorder(BorderFactory.createEmptyBorder(5, 10, 5, 10));
        content.setLayout((LayoutManager)new TableLayout((double[][])tl));
        JLabel label = UIUtilities.setTextFont("Groups");
        label.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        content.add((Component)label, "0, 0, l, c");
        content.add((Component)this.groups, "1, 0, f, c");
        content.add((Component)new JLabel(), "0, 1, 1, 1");
        label = UIUtilities.setTextFont("Users");
        label.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        content.add((Component)label, "0, 2, l, c");
        content.add((Component)new JScrollPane(this.users), "1, 2, 1, 3");
        return content;
    }

    private JPanel buildToolBar() {
        JPanel bar = new JPanel();
        bar.setBorder(null);
        bar.add(this.mySelf);
        bar.add(Box.createRigidArea(H_SPACER_SIZE));
        bar.add(this.cancel);
        bar.add(Box.createRigidArea(H_SPACER_SIZE));
        bar.add(this.apply);
        return UIUtilities.buildComponentPanelRight(bar);
    }

    private void buildGUI() {
        IconManager im = IconManager.getInstance();
        TitlePanel titlePanel = new TitlePanel(TITLE, TEXT, im.getIcon(IconManager.OWNER_48));
        Container c = this.getContentPane();
        c.setLayout(new BorderLayout(0, 0));
        c.add((Component)titlePanel, "North");
        c.add((Component)this.buildContent(), "Center");
        c.add((Component)this.buildToolBar(), "South");
    }

    public UserManagerDialog(JFrame parent, ExperimenterData loggedUser, Map groups, long userID) {
        super(parent);
        this.setProperties();
        this.loggedUser = loggedUser;
        this.initComponents(groups, userID);
        this.attachListeners();
        this.buildGUI();
    }
}

