/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.treeviewer.util;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import javax.swing.Icon;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeCellRenderer;
import org.openmicroscopy.shoola.agents.treeviewer.IconManager;
import org.openmicroscopy.shoola.agents.treeviewer.browser.TreeImageDisplay;
import org.openmicroscopy.shoola.util.ui.UIUtilities;
import pojos.CategoryData;
import pojos.CategoryGroupData;
import pojos.DatasetData;
import pojos.ExperimenterData;
import pojos.ImageData;
import pojos.ProjectData;

public class TreeCellRenderer
extends DefaultTreeCellRenderer {
    private IconManager icons;
    private boolean numberChildrenVisible;

    private void setIcon(Object usrObject) {
        Icon icon = this.icons.getIcon(IconManager.OWNER);
        if (usrObject instanceof ProjectData) {
            icon = this.icons.getIcon(IconManager.PROJECT);
        } else if (usrObject instanceof DatasetData) {
            Long i = ((DatasetData)usrObject).getAnnotationCount();
            icon = i == null || i == 0L ? this.icons.getIcon(IconManager.DATASET) : this.icons.getIcon(IconManager.ANNOTATED_DATASET);
        } else if (usrObject instanceof ImageData) {
            ImageData img = (ImageData)usrObject;
            Long a = img.getAnnotationCount();
            Long c = img.getClassificationCount();
            long n = 0L;
            long m = 0L;
            if (a != null) {
                n = a;
            }
            if (c != null) {
                m = c;
            }
            if (n == 0L && m == 0L) {
                icon = this.icons.getIcon(IconManager.IMAGE);
            } else if (n == 0L && m != 0L) {
                icon = this.icons.getIcon(IconManager.CLASSIFIED_IMAGE);
            } else if (n != 0L && m == 0L) {
                icon = this.icons.getIcon(IconManager.ANNOTATED_IMAGE);
            } else if (n != 0L && m != 0L) {
                icon = this.icons.getIcon(IconManager.ANNOTATED_CLASSIFIED_IMAGE);
            }
        } else if (usrObject instanceof CategoryGroupData) {
            icon = this.icons.getIcon(IconManager.CATEGORY_GROUP);
        } else if (usrObject instanceof CategoryData) {
            icon = this.icons.getIcon(IconManager.CATEGORY);
        } else if (usrObject instanceof String) {
            icon = this.icons.getIcon(IconManager.ROOT);
        }
        this.setIcon(icon);
    }

    private void setTextColor(Color c) {
        if (c == null) {
            return;
        }
        if (UIUtilities.isDarkColor(c)) {
            this.setForeground(UIUtilities.DEFAULT_TEXT);
        }
    }

    public TreeCellRenderer(boolean b) {
        this.numberChildrenVisible = b;
        this.icons = IconManager.getInstance();
    }

    public TreeCellRenderer() {
        this(true);
    }

    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
        if (!(value instanceof TreeImageDisplay)) {
            return this;
        }
        TreeImageDisplay node = (TreeImageDisplay)value;
        int w = 0;
        FontMetrics fm = this.getFontMetrics(this.getFont());
        if (node.getLevel() == 0) {
            if (node.getUserObject() instanceof ExperimenterData) {
                this.setIcon(this.icons.getIcon(IconManager.OWNER));
            } else {
                this.setIcon(this.icons.getIcon(IconManager.ROOT));
            }
            if (this.getIcon() != null) {
                w += this.getIcon().getIconWidth();
            }
            w += this.getIconTextGap();
            this.setPreferredSize(new Dimension(w += fm.stringWidth(this.getText()), fm.getHeight()));
            if (sel) {
                this.setTextColor(this.getBackgroundSelectionColor());
            }
            return this;
        }
        if (this.numberChildrenVisible) {
            this.setText(node.getNodeText());
        } else {
            this.setText(node.getNodeName());
        }
        this.setToolTipText(node.getToolTip());
        this.setIcon(node.getUserObject());
        Color c = node.getHighLight();
        if (c == null) {
            c = tree.getForeground();
        }
        this.setForeground(c);
        if (!sel) {
            this.setBorderSelectionColor(this.getBackground());
        } else {
            this.setTextColor(this.getBackgroundSelectionColor());
        }
        if (this.getIcon() != null) {
            w += this.getIcon().getIconWidth();
        }
        w += this.getIconTextGap();
        w = node.getUserObject() instanceof ImageData ? (w += fm.stringWidth(node.getNodeName())) : (w += fm.stringWidth(this.getText()));
        this.setPreferredSize(new Dimension(w, fm.getHeight() + 4));
        return this;
    }
}

