/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.treeviewer.util;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import layout.TableLayout;
import org.openmicroscopy.shoola.agents.treeviewer.IconManager;
import org.openmicroscopy.shoola.agents.treeviewer.TreeViewerAgent;
import org.openmicroscopy.shoola.agents.util.ViewerSorter;
import org.openmicroscopy.shoola.env.ui.UserNotifier;
import org.openmicroscopy.shoola.util.ui.TitlePanel;
import org.openmicroscopy.shoola.util.ui.UIUtilities;
import org.openmicroscopy.shoola.util.ui.clsf.TreeCheck;
import org.openmicroscopy.shoola.util.ui.clsf.TreeCheckNode;
import pojos.CategoryData;
import pojos.DatasetData;

public class FilterWindow
extends JDialog
implements PropertyChangeListener {
    public static final int DATASET = 0;
    public static final int CATEGORY = 1;
    public static final String CLOSE_PROPERTY = "close";
    private static final String DATASET_MSG = "datasets";
    private static final String CATEGORY_MSG = "categories";
    private static final String TITLE = "Filter images retrieval";
    private static final String NOTE = "Select items in the following list.";
    private static final String MESSAGE = "No items available.";
    private static final String NOTE_MESSAGE = "Limit the images retrieval by selecting items in the following list of ";
    private static final Dimension WINDOW_SIZE = new Dimension(500, 500);
    private static final Dimension H_SPACER_SIZE = new Dimension(5, 10);
    private int containerType;
    private JButton cancelButton;
    private JButton setButton;
    private JButton selectAll;
    private JButton clearAll;
    private TreeCheck tree;
    private Object parent;

    private void checkType(int type) {
        switch (type) {
            case 0: 
            case 1: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Container not supported");
            }
        }
    }

    private String getContainerString() {
        switch (this.containerType) {
            case 0: {
                return "Limit the images retrieval by selecting items in the following list of datasets";
            }
            case 1: {
                return "Limit the images retrieval by selecting items in the following list of categories";
            }
        }
        return "";
    }

    private void initComponents() {
        IconManager im = IconManager.getInstance();
        this.tree = new TreeCheck("", im.getIcon(IconManager.ROOT));
        this.tree.setRootVisible(false);
        this.selectAll = new JButton("Select All");
        this.selectAll.setToolTipText(UIUtilities.formatToolTipText("Select all items."));
        this.clearAll = new JButton("Deselect All");
        this.clearAll.setToolTipText(UIUtilities.formatToolTipText("Clear selection."));
        this.cancelButton = new JButton("Cancel");
        this.cancelButton.setToolTipText(UIUtilities.formatToolTipText("Close the window."));
        this.setButton = new JButton("Apply");
        this.setButton.setEnabled(false);
        this.setButton.setToolTipText(UIUtilities.formatToolTipText("Apply the selection."));
    }

    private JPanel buildRightToolBar() {
        JPanel bar = new JPanel();
        bar.setBorder(null);
        bar.add(this.setButton);
        bar.add(Box.createRigidArea(H_SPACER_SIZE));
        bar.add(this.cancelButton);
        return bar;
    }

    private JPanel buildLeftToolBar() {
        JPanel bar = new JPanel();
        bar.setBorder(null);
        bar.add(this.selectAll);
        bar.add(Box.createRigidArea(H_SPACER_SIZE));
        bar.add(this.clearAll);
        return bar;
    }

    private JComponent getFilterComponent(Set nodes) {
        if (nodes.size() == 0) {
            this.setButton.setEnabled(false);
            JPanel p = new JPanel();
            p.setBorder(BorderFactory.createEmptyBorder(5, 10, 5, 10));
            p.add((Component)UIUtilities.setTextFont(MESSAGE), "Center");
            return p;
        }
        DefaultTreeModel dtm = (DefaultTreeModel)this.tree.getModel();
        TreeCheckNode r = (TreeCheckNode)dtm.getRoot();
        Iterator i = nodes.iterator();
        while (i.hasNext()) {
            r.addChildDisplay((TreeCheckNode)i.next());
        }
        ViewerSorter sorter = new ViewerSorter();
        List sortedNodes = sorter.sort(nodes);
        for (TreeCheckNode n : sortedNodes) {
            r.addChildDisplay(n);
            dtm.insertNodeInto(n, r, r.getChildCount());
        }
        dtm.reload();
        this.tree.expandPath(new TreePath(r.getPath()));
        JPanel content = new JPanel();
        double[][] tl = new double[][]{{-1.0}, {400.0}};
        content.setBorder(BorderFactory.createEmptyBorder(5, 10, 5, 10));
        content.setLayout((LayoutManager)new TableLayout((double[][])tl));
        content.add((Component)new JScrollPane(this.tree), "0, 0");
        return content;
    }

    private void buildGUI(JComponent filterComponent) {
        JPanel contentPanel = new JPanel();
        contentPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        contentPanel.setLayout(new BoxLayout(contentPanel, 1));
        IconManager im = IconManager.getInstance();
        TitlePanel tp = new TitlePanel(TITLE, NOTE, this.getContainerString(), im.getIcon(IconManager.FILTER_BIG));
        Container c = this.getContentPane();
        c.setLayout(new BorderLayout(0, 0));
        c.add((Component)tp, "North");
        c.add((Component)filterComponent, "Center");
        JPanel p = new JPanel();
        p.setLayout(new BoxLayout(p, 0));
        p.add(UIUtilities.buildComponentPanel(this.buildLeftToolBar()));
        p.add(UIUtilities.buildComponentPanelRight(this.buildRightToolBar()));
        p.setOpaque(true);
        c.add((Component)p, "South");
    }

    private void attachListeners() {
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent we) {
                FilterWindow.this.close();
            }
        });
        this.selectAll.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FilterWindow.this.tree.selectAllNodes();
            }
        });
        this.clearAll.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FilterWindow.this.tree.deselectAllNodes();
            }
        });
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FilterWindow.this.close();
            }
        });
        this.setButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FilterWindow.this.setValues();
            }
        });
    }

    private void close() {
        this.firePropertyChange(CLOSE_PROPERTY, Boolean.FALSE, Boolean.TRUE);
        this.setVisible(false);
        this.dispose();
    }

    private void setValues() {
        Set nodes = this.tree.getSelectedNodes();
        if (nodes == null || nodes.size() == 0) {
            UserNotifier un = TreeViewerAgent.getRegistry().getUserNotifier();
            un.notifyInfo("Categorization", "No category selected.");
            return;
        }
        HashSet<Object> paths = new HashSet<Object>(nodes.size());
        Iterator i = nodes.iterator();
        while (i.hasNext()) {
            Object object = ((TreeCheckNode)i.next()).getUserObject();
            if (!(object instanceof CategoryData) && !(object instanceof DatasetData)) continue;
            paths.add(object);
        }
        HashMap<Object, HashSet<Object>> map = new HashMap<Object, HashSet<Object>>(1);
        map.put(this.parent, paths);
        this.firePropertyChange("filterNodes", null, map);
        this.setVisible(false);
        this.dispose();
    }

    public FilterWindow(Object parent, JFrame owner, int containerType, Set nodes) {
        super(owner, "Filter Images Retrieval", true);
        if (nodes == null) {
            throw new IllegalArgumentException("No nodes.");
        }
        if (parent == null) {
            throw new IllegalArgumentException("Parent cannot be null.");
        }
        this.checkType(containerType);
        this.parent = parent;
        this.containerType = containerType;
        this.initComponents();
        this.tree.addPropertyChangeListener("nodeSelected", this);
        this.buildGUI(this.getFilterComponent(nodes));
        this.attachListeners();
        this.setSize(WINDOW_SIZE);
    }

    public void propertyChange(PropertyChangeEvent pce) {
        String name = pce.getPropertyName();
        if ("nodeSelected".equals(name)) {
            int i = (Integer)pce.getNewValue();
            this.setButton.setEnabled(i > 0);
        }
    }
}

