/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.treeviewer.profile;

import java.awt.Component;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.border.EtchedBorder;
import layout.TableLayout;
import org.openmicroscopy.shoola.agents.treeviewer.TreeViewerAgent;
import org.openmicroscopy.shoola.agents.treeviewer.profile.ProfileEditorControl;
import org.openmicroscopy.shoola.agents.treeviewer.profile.ProfileEditorModel;
import org.openmicroscopy.shoola.agents.treeviewer.profile.ProfileEditorUtil;
import org.openmicroscopy.shoola.agents.treeviewer.util.GroupsRenderer;
import org.openmicroscopy.shoola.env.ui.UserNotifier;
import org.openmicroscopy.shoola.util.ui.UIUtilities;
import pojos.ExperimenterData;
import pojos.GroupData;

class UserProfile
extends JPanel {
    private static final String PASSWORD_OLD = "Old password";
    private static final String PASSWORD_NEW = "New password";
    private static final String PASSWORD_CONFIRMATION = "Confirm password";
    private Map<String, JTextField> items;
    private JComboBox groups;
    private JPasswordField passwordNew;
    private JPasswordField passwordConfirm;
    private JPasswordField oldPassword;
    private JButton saveButton;
    private JButton passwordButton;
    private ProfileEditorModel model;
    private ProfileEditorControl controller;

    private JLabel setFontToItalic(String s) {
        JLabel label = new JLabel(s);
        Font font = label.getFont();
        Font newFont = font.deriveFont(2);
        label.setFont(newFont);
        return label;
    }

    private void showRequiredField() {
        UserNotifier un = TreeViewerAgent.getRegistry().getUserNotifier();
        un.notifyInfo("Edit Profile", "The required fields cannot be left blank.");
    }

    private void save() {
        ExperimenterData original = this.model.getUser();
        ExperimenterData newOne = new ExperimenterData();
        JTextField f = this.items.get("Last Name");
        String v = f.getText();
        if (v == null || v.trim().length() == 0) {
            this.showRequiredField();
        }
        newOne.setLastName(v);
        f = this.items.get("E-mail");
        v = f.getText();
        if (v == null || v.trim().length() == 0) {
            this.showRequiredField();
        }
        newOne.setEmail(v);
        f = this.items.get("Institution");
        v = f.getText();
        if (v == null) {
            v = "";
        }
        newOne.setInstitution(v.trim());
        f = this.items.get("First Name");
        v = f.getText();
        if (v == null) {
            v = "";
        }
        newOne.setFirstName(v.trim());
        newOne.setId(original.getId());
        newOne.setDefaultGroup((GroupData)this.groups.getSelectedItem());
        this.controller.save(newOne);
    }

    private void changePassword() {
        StringBuffer buf = new StringBuffer();
        buf.append(this.passwordNew.getPassword());
        String pass = buf.toString();
        buf = new StringBuffer();
        buf.append(this.passwordConfirm.getPassword());
        String confirm = buf.toString();
        buf = new StringBuffer();
        buf.append(this.oldPassword.getPassword());
        String old = buf.toString();
        if (old == null || old.trim().length() == 0) {
            UserNotifier un = TreeViewerAgent.getRegistry().getUserNotifier();
            un.notifyInfo("Change Password", "Please specify your old password.");
            return;
        }
        if (pass == null || confirm == null || !pass.equals(confirm)) {
            UserNotifier un = TreeViewerAgent.getRegistry().getUserNotifier();
            un.notifyInfo("Change Password", "The passwords entered don't match. Please try again.");
            this.passwordNew.setText("");
            this.passwordConfirm.setText("");
            return;
        }
        this.controller.changePassword(old, confirm);
    }

    private void initComponents() {
        GroupData g;
        this.saveButton = new JButton("Save");
        this.saveButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                UserProfile.this.save();
            }
        });
        this.saveButton.setEnabled(this.model.isEditable());
        this.passwordButton = new JButton("Change password");
        this.passwordButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                UserProfile.this.changePassword();
            }
        });
        this.passwordNew = new JPasswordField();
        this.passwordConfirm = new JPasswordField();
        this.oldPassword = new JPasswordField();
        this.items = new HashMap<String, JTextField>();
        ExperimenterData user = this.model.getUser();
        Set userGroups = user.getGroups();
        GroupData defaultGroup = user.getDefaultGroup();
        long groupID = defaultGroup.getId();
        Iterator i = userGroups.iterator();
        ArrayList<GroupData> validGroups = new ArrayList<GroupData>();
        while (i.hasNext()) {
            g = (GroupData)i.next();
            if (!this.model.isValidGroup(g)) continue;
            validGroups.add(g);
        }
        GroupData[] objects = new GroupData[validGroups.size()];
        int selectedIndex = 0;
        int index = 0;
        i = validGroups.iterator();
        while (i.hasNext()) {
            objects[index] = g = (GroupData)i.next();
            if (g.getId() == groupID) {
                selectedIndex = index;
            }
            ++index;
        }
        this.groups = new JComboBox<GroupData>(objects);
        this.groups.setEnabled(this.model.isEditable());
        this.groups.setRenderer(new GroupsRenderer());
        if (objects.length != 0) {
            this.groups.setSelectedIndex(selectedIndex);
        }
    }

    private JPanel buildContentPanel() {
        int j;
        JLabel label;
        boolean editable = this.model.isEditable();
        Map<String, String> details = ProfileEditorUtil.manageExperimenterData(this.model.getUser());
        JPanel content = new JPanel();
        content.setBorder(BorderFactory.createEmptyBorder(5, 10, 5, 10));
        double[] columns = new double[]{150.0, 200.0};
        double[] rows = new double[2 * (details.size() + 2)];
        for (int i = 0; i < rows.length; ++i) {
            rows[i] = i % 2 == 0 ? 5.0 : -1.0;
        }
        TableLayout layout = new TableLayout();
        layout.setColumn(columns);
        layout.setRow(rows);
        content.setLayout((LayoutManager)layout);
        Iterator<String> i = details.keySet().iterator();
        int index = 1;
        while (i.hasNext()) {
            String key = i.next();
            String value = details.get(key);
            label = key.equals("Last Name") || key.equals("E-mail") ? UIUtilities.setTextFont(key + " *") : UIUtilities.setTextFont(key);
            JTextField area = new JTextField(value);
            j = index - 1;
            content.add((Component)new JLabel(""), "0, " + j + ", 1, " + j);
            content.add((Component)label, "0, " + index);
            area.setEditable(editable);
            label.setLabelFor(area);
            content.add((Component)area, "1, " + index);
            this.items.put(key, area);
            index += 2;
        }
        label = UIUtilities.setTextFont("Default Group");
        j = index - 1;
        content.add((Component)new JLabel(""), "0, " + j + ", 1, " + j);
        content.add((Component)label, "0, " + index);
        content.add((Component)this.groups, "1, " + index);
        content.add((Component)new JLabel(""), "0, " + j + ", 1, " + j);
        content.add((Component)this.setFontToItalic("* indicates the required fields."), "0, " + (index += 2) + ", 1, " + index);
        JPanel p = new JPanel();
        p.setLayout(new BoxLayout(p, 1));
        p.add(content);
        p.add(UIUtilities.buildComponentPanel(this.saveButton));
        return p;
    }

    private JPanel buildPasswordPanel() {
        JPanel content = new JPanel();
        content.setBorder(BorderFactory.createEmptyBorder(5, 10, 5, 10));
        double[][] tl = new double[][]{{150.0, 5.0, 100.0}, {-1.0, 5.0, -1.0, 5.0, -1.0}};
        content.setLayout((LayoutManager)new TableLayout((double[][])tl));
        JLabel label = UIUtilities.setTextFont(PASSWORD_OLD);
        content.add((Component)label, "0, 0, f, t");
        label = new JLabel();
        content.add((Component)label, "1, 0");
        content.add((Component)this.oldPassword, "2, 0");
        label = new JLabel();
        content.add((Component)label, "0, 1, 2, 1");
        label = UIUtilities.setTextFont(PASSWORD_NEW);
        content.add((Component)label, "0, 2, f, t");
        label = new JLabel();
        content.add((Component)label, "1, 2");
        content.add((Component)this.passwordNew, "2, 2");
        label = new JLabel();
        content.add((Component)label, "0, 3, 2, 3");
        label = UIUtilities.setTextFont(PASSWORD_CONFIRMATION);
        content.add((Component)label, "0, 4, f, t");
        label = new JLabel();
        content.add((Component)label, "1, 4");
        content.add((Component)this.passwordConfirm, "2, 4");
        JPanel p = new JPanel();
        p.setLayout(new BoxLayout(p, 1));
        p.add(content);
        p.add(UIUtilities.buildComponentPanel(this.passwordButton));
        return p;
    }

    private void buildGUI() {
        this.setBorder(new EtchedBorder());
        JPanel contentPanel = this.buildContentPanel();
        double[][] tl = new double[][]{{-1.0}, {-2.0, -2.0}};
        this.setLayout((LayoutManager)new TableLayout((double[][])tl));
        this.add((Component)contentPanel, "0, 0, f, t");
        this.add((Component)this.buildPasswordPanel(), "0, 1, f, t");
    }

    UserProfile(ProfileEditorModel model, ProfileEditorControl controller) {
        if (model == null) {
            throw new IllegalArgumentException("No model.");
        }
        if (controller == null) {
            throw new IllegalArgumentException("No control.");
        }
        this.model = model;
        this.controller = controller;
        this.initComponents();
        this.buildGUI();
    }

    void passwordChanged() {
        this.oldPassword.setText("");
        this.passwordNew.setText("");
        this.passwordConfirm.setText("");
    }
}

