/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.treeviewer.profile;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.openmicroscopy.shoola.agents.treeviewer.IconManager;
import org.openmicroscopy.shoola.agents.treeviewer.profile.ProfileEditorControl;
import org.openmicroscopy.shoola.agents.treeviewer.profile.ProfileEditorModel;
import org.openmicroscopy.shoola.agents.treeviewer.profile.UserProfile;
import org.openmicroscopy.shoola.util.ui.TitlePanel;
import org.openmicroscopy.shoola.util.ui.UIUtilities;
import org.openmicroscopy.shoola.util.ui.login.ServerEditor;

class ProfileEditorUI
extends JPanel {
    static final String DIALOG_TITLE = "Change Password";
    private static final String TITLE = "Profile Editor";
    private static final String NOTE = "Edit My Profile";
    private static final String USER_TITLE = "My Profile";
    private static final String SERVER_TITLE = "My Servers";
    private static final Dimension H_SPACER_SIZE = new Dimension(5, 10);
    private ProfileEditorModel model;
    private ProfileEditorControl controller;
    private JButton finishButton;
    private JButton cancelButton;
    private JTabbedPane tabs;
    private JLayeredPane titleLayer;
    private TitlePanel titlePanel;
    private UserProfile userProfile;
    private ServerEditor serverProfile;

    private void initComponents() {
        this.cancelButton = new JButton("Close");
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ProfileEditorUI.this.controller.close();
            }
        });
        this.finishButton = new JButton("Save");
        this.finishButton.setEnabled(false);
        this.finishButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
            }
        });
        this.userProfile = new UserProfile(this.model, this.controller);
        this.serverProfile = new ServerEditor(this.model.getHostName());
        this.serverProfile.initFocus();
        IconManager im = IconManager.getInstance();
        this.titlePanel = new TitlePanel(TITLE, NOTE, im.getIcon(IconManager.OWNER_48));
        this.titleLayer = new JLayeredPane();
        this.titleLayer.add((Component)this.titlePanel, new Integer(0));
        this.tabs = new JTabbedPane(1, 0);
        this.tabs.setAlignmentX(0.0f);
        this.tabs.addTab(USER_TITLE, im.getIcon(IconManager.OWNER), this.userProfile);
        this.tabs.addTab(SERVER_TITLE, im.getIcon(IconManager.SERVER), this.serverProfile);
        this.tabs.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                int index = ProfileEditorUI.this.tabs.getSelectedIndex();
                if (index == 1) {
                    ProfileEditorUI.this.serverProfile.setVisible(true);
                    ProfileEditorUI.this.serverProfile.initFocus();
                }
            }
        });
    }

    private JPanel buildToolBar() {
        JPanel bar = new JPanel();
        bar.setBorder(null);
        bar.add(Box.createRigidArea(H_SPACER_SIZE));
        bar.add(this.cancelButton);
        return bar;
    }

    private void buildGUI() {
        this.setLayout(new BorderLayout(0, 0));
        this.setOpaque(true);
        this.add((Component)this.titleLayer, "North");
        this.add((Component)this.tabs, "Center");
        JPanel p = UIUtilities.buildComponentPanelRight(this.buildToolBar());
        p.setOpaque(true);
        this.add((Component)p, "South");
    }

    ProfileEditorUI() {
    }

    void initialize(ProfileEditorModel model, ProfileEditorControl controller) {
        if (controller == null) {
            throw new NullPointerException("No control.");
        }
        if (model == null) {
            throw new NullPointerException("No model.");
        }
        this.controller = controller;
        this.model = model;
        this.initComponents();
        this.serverProfile.addPropertyChangeListener(controller);
        this.buildGUI();
    }

    void passwordChanged() {
        this.userProfile.passwordChanged();
    }

    void showMessage(boolean b, JComponent component) {
        if (b) {
            this.titleLayer.add((Component)component, new Integer(1));
            this.titleLayer.validate();
            this.titleLayer.repaint();
        } else {
            if (component == null) {
                return;
            }
            this.titleLayer.remove(component);
            this.titleLayer.repaint();
        }
    }

    public void setSize(int width, int height) {
        super.setSize(width, height);
        Dimension d = new Dimension(width, 70);
        this.titlePanel.setSize(d);
        this.titlePanel.setPreferredSize(d);
        this.titleLayer.setSize(d);
        this.titleLayer.setPreferredSize(d);
    }

    public void setSize(Dimension d) {
        this.setSize(d.width, d.height);
    }
}

