/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.treeviewer.profile;

import org.openmicroscopy.shoola.agents.treeviewer.ExperimenterEditor;
import org.openmicroscopy.shoola.agents.treeviewer.PasswordEditor;
import org.openmicroscopy.shoola.agents.treeviewer.ProfileEditorLoader;
import org.openmicroscopy.shoola.agents.treeviewer.TreeViewerAgent;
import org.openmicroscopy.shoola.agents.treeviewer.profile.ProfileEditor;
import pojos.ExperimenterData;
import pojos.GroupData;

class ProfileEditorModel {
    private int state;
    private ProfileEditorLoader currentLoader;
    private ExperimenterData experimenter;
    private ProfileEditor component;

    ProfileEditorModel(ExperimenterData experimenter) {
        this.experimenter = experimenter;
    }

    void initialize(ProfileEditor component) {
        this.component = component;
    }

    boolean isEditable() {
        ExperimenterData exp = (ExperimenterData)TreeViewerAgent.getRegistry().lookup("/current_user/details");
        return exp.getId() == this.experimenter.getId();
    }

    boolean isValidGroup(GroupData g) {
        if (g == null) {
            return false;
        }
        String name = g.getName();
        return !"user".equals(name) && !"default".equals(name);
    }

    ExperimenterData getUser() {
        return this.experimenter;
    }

    int getState() {
        return this.state;
    }

    void discard() {
        this.cancel();
        this.state = 2;
    }

    void cancel() {
        if (this.currentLoader != null) {
            this.currentLoader.cancel();
            this.currentLoader = null;
        }
        this.state = 4;
    }

    void firePasswordChange(String oldPassword, String password) {
        this.currentLoader = new PasswordEditor(this.component, oldPassword, password);
        this.currentLoader.load();
        this.state = 3;
    }

    void fireEditionSave(ExperimenterData exp) {
        this.currentLoader = new ExperimenterEditor(this.component, exp);
        this.currentLoader.load();
        this.state = 3;
    }

    void setState(int state) {
        this.state = state;
    }

    void setExperimenter(ExperimenterData experimenter) {
        this.experimenter = experimenter;
        this.state = 4;
    }

    String getHostName() {
        return TreeViewerAgent.getRegistry().getDataService().getServerName();
    }
}

