/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.treeviewer.profile;

import org.openmicroscopy.shoola.agents.treeviewer.profile.ProfileEditor;
import org.openmicroscopy.shoola.agents.treeviewer.profile.ProfileEditorComponent;
import org.openmicroscopy.shoola.agents.treeviewer.profile.ProfileEditorModel;
import pojos.ExperimenterData;

public class ProfileEditorFactory {
    private static final ProfileEditorFactory singleton = new ProfileEditorFactory();
    private ProfileEditor editor = null;

    public static ProfileEditor getEditor(ExperimenterData exp) {
        if (exp == null) {
            throw new IllegalArgumentException("No experimenter sepcified.");
        }
        return singleton.createEditor(exp);
    }

    private ProfileEditorFactory() {
    }

    private ProfileEditor createEditor(ExperimenterData exp) {
        if (this.editor != null) {
            return this.editor;
        }
        ProfileEditorModel model = new ProfileEditorModel(exp);
        ProfileEditorComponent c = new ProfileEditorComponent(model);
        model.initialize(c);
        c.initialize();
        this.editor = c;
        return c;
    }
}

