/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.treeviewer.profile;

import javax.swing.JComponent;
import org.openmicroscopy.shoola.agents.treeviewer.TreeViewerAgent;
import org.openmicroscopy.shoola.agents.treeviewer.profile.ProfileEditor;
import org.openmicroscopy.shoola.agents.treeviewer.profile.ProfileEditorControl;
import org.openmicroscopy.shoola.agents.treeviewer.profile.ProfileEditorModel;
import org.openmicroscopy.shoola.agents.treeviewer.profile.ProfileEditorUI;
import org.openmicroscopy.shoola.env.ui.UserNotifier;
import org.openmicroscopy.shoola.util.ui.component.AbstractComponent;
import pojos.ExperimenterData;

class ProfileEditorComponent
extends AbstractComponent
implements ProfileEditor {
    private ProfileEditorModel model;
    private ProfileEditorControl controller;
    private ProfileEditorUI view;

    ProfileEditorComponent(ProfileEditorModel model) {
        if (model == null) {
            throw new NullPointerException("No model.");
        }
        this.model = model;
        this.controller = new ProfileEditorControl(this);
        this.view = new ProfileEditorUI();
    }

    void initialize() {
        this.controller.initialize(this.view);
        this.view.initialize(this.model, this.controller);
    }

    public void activate() {
    }

    public void cancel() {
        if (this.model.getState() != 2) {
            this.model.cancel();
            this.fireStateChange();
        }
    }

    public void close() {
        if (this.model.getState() == 2) {
            throw new IllegalStateException("This method cannot be invoked in the DISCARDED state.");
        }
        this.firePropertyChange("closeProfileEditor", Boolean.FALSE, Boolean.TRUE);
    }

    public void discard() {
        if (this.model.getState() != 2) {
            this.model.discard();
            this.fireStateChange();
        }
    }

    public int getState() {
        return this.model.getState();
    }

    public JComponent getUI() {
        return this.view;
    }

    public void changePassword(String oldPassword, String password) {
        if (this.model.getState() == 2) {
            throw new IllegalStateException("This method cannot be invoked in the DISCARDED state.");
        }
        this.model.firePasswordChange(oldPassword, password);
        this.fireStateChange();
    }

    public void save(ExperimenterData exp) {
        if (this.model.getState() == 2) {
            throw new IllegalStateException("This method cannot be invoked in the DISCARDED state.");
        }
        this.model.fireEditionSave(exp);
        this.fireStateChange();
    }

    public void passwordChanged(Boolean result) {
        if (this.model.getState() != 3) {
            return;
        }
        UserNotifier un = TreeViewerAgent.getRegistry().getUserNotifier();
        if (result.booleanValue()) {
            un.notifyInfo("Change Password", "The password has been successfully modified.");
        } else {
            un.notifyInfo("Change Password", "The password couldn't be modified. Please try again.");
        }
        this.model.setState(4);
        this.view.passwordChanged();
        this.fireStateChange();
    }

    public void experimenterChanged(ExperimenterData exp) {
        if (this.model.getState() != 3) {
            return;
        }
        this.model.setExperimenter(exp);
        this.fireStateChange();
    }
}

