/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.treeviewer.finder;

import java.awt.event.ActionEvent;
import org.openmicroscopy.shoola.agents.treeviewer.IconManager;
import org.openmicroscopy.shoola.agents.treeviewer.finder.Finder;
import org.openmicroscopy.shoola.agents.treeviewer.finder.FinderAction;
import org.openmicroscopy.shoola.util.ui.UIUtilities;

public class FindPreviousAction
extends FinderAction {
    private static final String NAME = "Find Previous";
    private static final String DESCRIPTION = "Finds the previous occurence of the phrase.";

    protected void onTextChanged() {
        this.setEnabled(!this.model.isTextEmpty());
    }

    protected void onLevelChanged() {
        if (!(this.model.isNameSelected() || this.model.isDescriptionSelected() || this.model.isAnnotationSelected())) {
            this.setEnabled(false);
        } else {
            this.setEnabled(true);
        }
    }

    protected void onRetrievedChanged(int n) {
        this.setEnabled(n != 0);
    }

    public FindPreviousAction(Finder model) {
        super(model);
        this.putValue("Name", NAME);
        this.putValue("ShortDescription", UIUtilities.formatToolTipText(DESCRIPTION));
        IconManager im = IconManager.getInstance();
        this.putValue("SmallIcon", im.getIcon(IconManager.FIND_PREVIOUS));
        model.addPropertyChangeListener("textEntered", this);
        model.addPropertyChangeListener("level", this);
        model.addPropertyChangeListener("retrieved", this);
    }

    public void actionPerformed(ActionEvent e) {
        this.model.findPrevious();
    }
}

