/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.treeviewer.finder;

import java.awt.event.ActionEvent;
import org.openmicroscopy.shoola.agents.treeviewer.finder.Finder;
import org.openmicroscopy.shoola.agents.treeviewer.finder.FinderAction;
import org.openmicroscopy.shoola.util.ui.UIUtilities;

public class FindAction
extends FinderAction {
    private static final String NAME = "Find";
    private static final String DESCRIPTION = "Finds all occurences of the phrase.";

    protected void onTextChanged() {
        this.setEnabled(!this.model.isTextEmpty());
    }

    protected void onLevelChanged() {
        if (!(this.model.isNameSelected() || this.model.isDescriptionSelected() || this.model.isAnnotationSelected())) {
            this.setEnabled(false);
        } else {
            this.setEnabled(true);
        }
    }

    public FindAction(Finder model) {
        super(model);
        this.putValue("Name", NAME);
        this.putValue("ShortDescription", UIUtilities.formatToolTipText(DESCRIPTION));
        model.addPropertyChangeListener("textEntered", this);
        model.addPropertyChangeListener("level", this);
    }

    public void actionPerformed(ActionEvent e) {
        this.model.find();
    }
}

