/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.treeviewer.editors;

import java.sql.Timestamp;
import java.text.NumberFormat;
import java.util.LinkedHashMap;
import java.util.Map;
import org.openmicroscopy.shoola.agents.treeviewer.TreeViewerTranslator;
import pojos.ExperimenterData;
import pojos.ImageData;
import pojos.PixelsData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class EditorUtil {
    static final String GROUPS = "Belongs to the following groups: ";
    static final String WAVELENGTHS = "Emissions wavelengths";
    private static final String MICRONS = "(in \u00b5)";
    private static final String SIZE_X = "Size X";
    private static final String SIZE_Y = "Size Y";
    private static final String PIXEL_SIZE_X = "Pixel size X (in \u00b5)";
    private static final String PIXEL_SIZE_Y = "Pixel size Y (in \u00b5)";
    private static final String PIXEL_SIZE_Z = "Pixel size Z (in \u00b5)";
    private static final String SECTIONS = "Number of sections";
    private static final String TIMEPOINTS = "Number of timepoints";
    private static final String PIXEL_TYPE = "Pixel Type";
    private static final String ACQUISITION_DATE = "Acquisition date";
    private static final String NAME = "Owner";
    private static final String EMAIL = "E-mail";

    EditorUtil() {
    }

    static Map<String, String> transformExperimenterData(ExperimenterData data) {
        LinkedHashMap<String, String> details = new LinkedHashMap<String, String>(2);
        if (data == null) {
            details.put(NAME, "");
            details.put(EMAIL, "");
        } else {
            try {
                details.put(NAME, data.getFirstName() + " " + data.getLastName());
                details.put(EMAIL, data.getEmail());
            }
            catch (Exception e) {
                details.put(NAME, "");
                details.put(EMAIL, "");
            }
        }
        return details;
    }

    static Map<String, String> transformPixelsData(PixelsData data) {
        LinkedHashMap<String, String> details = new LinkedHashMap<String, String>(9);
        if (data == null) {
            details.put(SIZE_X, "");
            details.put(SIZE_Y, "");
            details.put(SECTIONS, "");
            details.put(TIMEPOINTS, "");
            details.put(PIXEL_SIZE_X, "");
            details.put(PIXEL_SIZE_Y, "");
            details.put(PIXEL_SIZE_Z, "");
            details.put(PIXEL_TYPE, "");
        } else {
            NumberFormat nf = NumberFormat.getInstance();
            details.put(SIZE_X, "" + data.getSizeX());
            details.put(SIZE_Y, "" + data.getSizeY());
            details.put(SECTIONS, "" + data.getSizeZ());
            details.put(TIMEPOINTS, "" + data.getSizeT());
            try {
                details.put(PIXEL_SIZE_X, nf.format(data.getPixelSizeX()));
                details.put(PIXEL_SIZE_Y, nf.format(data.getPixelSizeY()));
                details.put(PIXEL_SIZE_Z, nf.format(data.getPixelSizeZ()));
                details.put(PIXEL_TYPE, "" + data.getPixelType());
            }
            catch (Exception e) {
                details.put(PIXEL_SIZE_X, "");
                details.put(PIXEL_SIZE_Y, "");
                details.put(PIXEL_SIZE_Z, "");
                details.put(PIXEL_TYPE, "");
            }
        }
        details.put(WAVELENGTHS, "");
        return details;
    }

    static Map<String, String> transformImageData(ImageData image) {
        PixelsData data;
        LinkedHashMap<String, String> details = new LinkedHashMap<String, String>(10);
        if (image == null) {
            details.put(SIZE_X, "");
            details.put(SIZE_Y, "");
            details.put(SECTIONS, "");
            details.put(TIMEPOINTS, "");
            details.put(PIXEL_SIZE_X, "");
            details.put(PIXEL_SIZE_Y, "");
            details.put(PIXEL_SIZE_Z, "");
            details.put(PIXEL_TYPE, "");
            details.put(WAVELENGTHS, "");
            details.put(ACQUISITION_DATE, "Date not available");
        }
        if ((data = image.getDefaultPixels()) == null) {
            details.put(SIZE_X, "");
            details.put(SIZE_Y, "");
            details.put(SECTIONS, "");
            details.put(TIMEPOINTS, "");
            details.put(PIXEL_SIZE_X, "");
            details.put(PIXEL_SIZE_Y, "");
            details.put(PIXEL_SIZE_Z, "");
            details.put(PIXEL_TYPE, "");
        } else {
            NumberFormat nf = NumberFormat.getInstance();
            details.put(SIZE_X, "" + data.getSizeX());
            details.put(SIZE_Y, "" + data.getSizeY());
            details.put(SECTIONS, "" + data.getSizeZ());
            details.put(TIMEPOINTS, "" + data.getSizeT());
            try {
                details.put(PIXEL_SIZE_X, nf.format(data.getPixelSizeX()));
                details.put(PIXEL_SIZE_Y, nf.format(data.getPixelSizeY()));
                details.put(PIXEL_SIZE_Z, nf.format(data.getPixelSizeZ()));
                details.put(PIXEL_TYPE, "" + data.getPixelType());
            }
            catch (Exception e) {
                details.put(PIXEL_SIZE_X, "");
                details.put(PIXEL_SIZE_Y, "");
                details.put(PIXEL_SIZE_Z, "");
                details.put(PIXEL_TYPE, "");
            }
        }
        details.put(WAVELENGTHS, "");
        Timestamp date = null;
        try {
            date = image.getInserted();
        }
        catch (Exception e) {
            // empty catch block
        }
        if (date == null) {
            details.put(ACQUISITION_DATE, "Date not available");
        } else {
            details.put(ACQUISITION_DATE, TreeViewerTranslator.formatTime(date));
        }
        return details;
    }
}

