/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.treeviewer.editors;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import org.openmicroscopy.shoola.agents.treeviewer.IconManager;
import org.openmicroscopy.shoola.agents.treeviewer.TreeViewerAgent;
import org.openmicroscopy.shoola.agents.treeviewer.editors.DOBasic;
import org.openmicroscopy.shoola.agents.treeviewer.editors.DOInfo;
import org.openmicroscopy.shoola.agents.treeviewer.editors.EditorControl;
import org.openmicroscopy.shoola.agents.treeviewer.editors.EditorModel;
import org.openmicroscopy.shoola.agents.treeviewer.editors.EditorUtil;
import org.openmicroscopy.shoola.agents.util.annotator.view.AnnotatorEditor;
import org.openmicroscopy.shoola.env.data.model.ChannelMetadata;
import org.openmicroscopy.shoola.env.ui.UserNotifier;
import org.openmicroscopy.shoola.util.ui.TitlePanel;
import org.openmicroscopy.shoola.util.ui.UIUtilities;
import org.openmicroscopy.shoola.util.ui.border.PartialLineBorder;
import pojos.CategoryData;
import pojos.CategoryGroupData;
import pojos.DataObject;
import pojos.DatasetData;
import pojos.ExperimenterData;
import pojos.ImageData;
import pojos.ProjectData;

class EditorUI
extends JPanel {
    public static final int TITLE_HEIGHT = 80;
    static final Dimension SMALL_V_SPACER_SIZE = new Dimension(1, 6);
    static final int MAX_INDEX = 3;
    private static final Dimension H_SPACER_SIZE = new Dimension(5, 10);
    private static final String PROJECT_PARENT_MSG = " to project: ";
    private static final String DATASET_PARENT_MSG = " to dataset: ";
    private static final String CATEGORY_GROUP_PARENT_MSG = " to category group: ";
    private static final String CATEGORY_PARENT_MSG = " to category : ";
    private static final String PROJECT_MSG = "Project";
    private static final String DATASET_MSG = "Dataset";
    private static final String CATEGORY_GROUP_MSG = "Category group";
    private static final String CATEGORY_MSG = "Category";
    private static final String IMAGE_MSG = "Image";
    private static final String EMPTY_MSG = "The name is empty.";
    private static final String PROPERTIES_TITLE = "Properties";
    private static final String OWNER_TITLE = "Permissions";
    private static final String INFO_TITLE = "Info";
    private JButton finishButton;
    private JButton cancelButton;
    private JPanel emptyMessagePanel;
    private JLayeredPane titleLayer;
    private TitlePanel titlePanel;
    private String message;
    private String messageParent;
    private boolean warning = false;
    private boolean edit = false;
    private JTabbedPane tabs;
    private DOBasic doBasic;
    private AnnotatorEditor annotator;
    private EditorModel model;
    private EditorControl controller;

    private void initComponents() {
        this.titleLayer = new JLayeredPane();
        this.cancelButton = new JButton("Close");
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                EditorUI.this.controller.close(true);
            }
        });
        this.finishButton = new JButton("Save");
        this.finishButton.setEnabled(false);
        this.finishButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                EditorUI.this.finish();
            }
        });
        this.doBasic = new DOBasic(this, this.model, this.controller);
        if (this.model.isAnnotatable()) {
            this.annotator = this.model.createAnnotator();
            this.annotator.addPropertyChangeListener(this.controller);
        }
    }

    private void getMessage() {
        Class<?> nodeType = this.model.getHierarchyObject().getClass();
        if (nodeType.equals(ProjectData.class)) {
            this.messageParent = null;
            this.message = PROJECT_MSG;
        } else if (nodeType.equals(DatasetData.class)) {
            this.messageParent = PROJECT_PARENT_MSG;
            this.message = DATASET_MSG;
        } else if (nodeType.equals(CategoryData.class)) {
            this.messageParent = CATEGORY_GROUP_PARENT_MSG;
            this.message = CATEGORY_MSG;
        } else if (nodeType.equals(CategoryGroupData.class)) {
            this.messageParent = null;
            this.message = CATEGORY_GROUP_MSG;
        } else if (nodeType.equals(ImageData.class)) {
            Class parentType = this.model.getParentClass();
            this.messageParent = null;
            if (parentType != null) {
                if (parentType.equals(DatasetData.class)) {
                    this.messageParent = DATASET_PARENT_MSG;
                } else if (parentType.equals(CategoryData.class)) {
                    this.messageParent = CATEGORY_PARENT_MSG;
                }
            }
            this.message = IMAGE_MSG;
        }
    }

    private void buildTitlePanel() {
        IconManager im = IconManager.getInstance();
        switch (this.model.getEditorType()) {
            case 100: {
                String subTitle = "Add a new " + this.message.toLowerCase();
                if (this.messageParent != null) {
                    subTitle = subTitle + this.messageParent + this.model.getParentName() + ".";
                }
                this.titlePanel = new TitlePanel(this.message, subTitle, im.getIcon(IconManager.CREATE_BIG));
                break;
            }
            case 101: {
                this.titlePanel = new TitlePanel(this.message, "Edit the " + this.message.toLowerCase() + ": " + this.model.getDataObjectName(), im.getIcon(IconManager.PROPERTIES_BIG));
            }
        }
        this.titleLayer.add((Component)this.titlePanel, new Integer(0));
    }

    private JPanel buildToolBar() {
        JPanel bar = new JPanel();
        bar.setBorder(null);
        bar.add(this.finishButton);
        bar.add(Box.createRigidArea(H_SPACER_SIZE));
        bar.add(this.cancelButton);
        JPanel p = UIUtilities.buildComponentPanelRight(bar);
        p.setOpaque(true);
        return p;
    }

    JPanel buildBasicToolBar(JButton button) {
        JPanel bar = new JPanel();
        bar.setBorder(null);
        if (button != null) {
            bar.add(button);
            bar.add(Box.createRigidArea(H_SPACER_SIZE));
        }
        bar.add(this.finishButton);
        JPanel p = UIUtilities.buildComponentPanelRight(bar);
        p.setOpaque(true);
        return p;
    }

    private void buildEmptyPanel() {
        if (this.emptyMessagePanel != null) {
            return;
        }
        this.emptyMessagePanel = new JPanel();
        this.emptyMessagePanel.setOpaque(true);
        this.emptyMessagePanel.setBorder(new PartialLineBorder(Color.BLACK));
        Rectangle r = this.titlePanel.getBounds();
        this.emptyMessagePanel.setLayout(new BoxLayout(this.emptyMessagePanel, 0));
        IconManager im = IconManager.getInstance();
        JLabel label = new JLabel(im.getIcon(IconManager.ERROR));
        this.emptyMessagePanel.add(label);
        int w = label.getWidth();
        label = new JLabel(EMPTY_MSG);
        int h = label.getFontMetrics(label.getFont()).getHeight();
        this.emptyMessagePanel.add(label);
        Insets i = this.emptyMessagePanel.getInsets();
        this.emptyMessagePanel.setBounds(0, r.height - (h += i.top + i.bottom + 2), 3 * (w += this.getFontMetrics(this.getFont()).stringWidth(EMPTY_MSG)) / 2, h);
    }

    private JComponent buildCenterComponent() {
        switch (this.model.getEditorType()) {
            case 100: {
                return this.doBasic;
            }
            case 101: {
                DataObject hierarchyObject;
                IconManager im = IconManager.getInstance();
                this.tabs = new JTabbedPane(1, 0);
                this.tabs.setAlignmentX(0.0f);
                this.tabs.addTab(PROPERTIES_TITLE, im.getIcon(IconManager.PROPERTIES), this.doBasic);
                if (this.annotator != null) {
                    this.tabs.addTab("Annotation", im.getIcon(IconManager.ANNOTATION), this.annotator.getUI());
                }
                if ((hierarchyObject = this.model.getHierarchyObject()) instanceof ImageData) {
                    ExperimenterData exp = this.model.getDataObjectOwner();
                    Map<String, String> details = EditorUtil.transformExperimenterData(exp);
                    details = EditorUtil.transformImageData((ImageData)hierarchyObject);
                    DOInfo info = new DOInfo(this, this.model, details, false, 1);
                    this.tabs.addTab(INFO_TITLE, im.getIcon(IconManager.IMAGE), info);
                }
                this.tabs.addChangeListener(this.controller);
                int index = this.model.getSelectedTabbedIndex();
                switch (index) {
                    case 0: {
                        this.tabs.setSelectedIndex(index);
                        break;
                    }
                    case 1: {
                        if (this.annotator != null) {
                            this.tabs.setSelectedIndex(index);
                            break;
                        }
                        this.setEditorSelectedPane(0);
                        this.tabs.setSelectedIndex(0);
                        break;
                    }
                    case 2: {
                        if (hierarchyObject instanceof ImageData) {
                            this.tabs.setSelectedIndex(index);
                            break;
                        }
                        this.setEditorSelectedPane(0);
                        this.tabs.setSelectedIndex(0);
                    }
                }
                return this.tabs;
            }
        }
        return null;
    }

    private void buildGUI() {
        this.buildTitlePanel();
        this.setLayout(new BorderLayout(0, 0));
        this.setOpaque(true);
        this.add((Component)this.titleLayer, "North");
        JComponent c = this.buildCenterComponent();
        c.setOpaque(true);
        c.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        JScrollPane pane = new JScrollPane(c);
        c.setPreferredSize(pane.getViewport().getExtentSize());
        this.add((Component)pane, "Center");
        if (this.model.getEditorType() == 100) {
            this.add((Component)this.buildToolBar(), "South");
        }
    }

    private void finishEdit() {
        if (this.edit) {
            this.controller.updateObject(this.fillDataObject());
        }
    }

    private DataObject fillDataObject() {
        DataObject hierarchyObject = this.model.getHierarchyObject();
        if (hierarchyObject instanceof ProjectData) {
            ProjectData p = (ProjectData)hierarchyObject;
            p.setName(this.doBasic.getNameText());
            p.setDescription(this.doBasic.descriptionArea.getText());
            return p;
        }
        if (hierarchyObject instanceof DatasetData) {
            DatasetData d = (DatasetData)hierarchyObject;
            d.setName(this.doBasic.getNameText());
            d.setDescription(this.doBasic.descriptionArea.getText());
            return d;
        }
        if (hierarchyObject instanceof CategoryData) {
            CategoryData c = (CategoryData)hierarchyObject;
            c.setName(this.doBasic.getNameText());
            c.setDescription(this.doBasic.descriptionArea.getText());
            return c;
        }
        if (hierarchyObject instanceof CategoryGroupData) {
            CategoryGroupData cg = (CategoryGroupData)hierarchyObject;
            cg.setName(this.doBasic.getNameText());
            cg.setDescription(this.doBasic.descriptionArea.getText());
            return cg;
        }
        if (hierarchyObject instanceof ImageData) {
            ImageData i = (ImageData)hierarchyObject;
            i.setName(this.doBasic.getNameText());
            i.setDescription(this.doBasic.descriptionArea.getText());
            return i;
        }
        return null;
    }

    private void setTitlePanelIcon() {
        Class<?> nodeType = this.model.getHierarchyObject().getClass();
        if (nodeType.equals(ImageData.class) && this.model.getEditorType() == 101) {
            IconManager icons = IconManager.getInstance();
            JLabel label = new JLabel(icons.getImageIcon(IconManager.IMAGE_48));
            this.titlePanel.setIconComponent(label);
        }
    }

    EditorUI() {
    }

    void initialize(EditorControl controller, EditorModel model) {
        if (controller == null) {
            throw new NullPointerException("No control.");
        }
        if (model == null) {
            throw new NullPointerException("No model.");
        }
        this.controller = controller;
        this.model = model;
        this.initComponents();
        this.getMessage();
        this.buildGUI();
        this.setTitlePanelIcon();
    }

    void handleNameAreaRemove(int length) {
        if (length == 0) {
            this.warning = true;
            this.finishButton.setEnabled(false);
            this.buildEmptyPanel();
            this.titleLayer.add((Component)this.emptyMessagePanel, new Integer(1));
        } else {
            this.finishButton.setEnabled(true);
        }
    }

    void handleNameAreaInsert() {
        this.finishButton.setEnabled(true);
        this.edit = true;
        if (this.warning) {
            this.titleLayer.remove(this.emptyMessagePanel);
            this.titleLayer.repaint();
        }
        this.warning = false;
    }

    void handleDescriptionAreaInsert() {
        if (this.doBasic == null) {
            return;
        }
        if (this.doBasic.hasDataToSave()) {
            this.finishButton.setEnabled(true);
            this.edit = true;
        } else {
            this.finishButton.setEnabled(false);
            this.edit = false;
        }
    }

    void setThumbnail(BufferedImage thumbnail) {
        JLabel label = new JLabel(new ImageIcon(thumbnail));
        label.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    EditorUI.this.model.browse(EditorUI.this.model.getHierarchyObject());
                }
            }
        });
        this.titlePanel.setIconComponent(label);
    }

    void setEdit(boolean b) {
        this.edit = b;
        this.finishButton.setEnabled(b);
    }

    void showClassifications() {
        if (this.doBasic != null) {
            this.doBasic.showClassifications();
        }
    }

    void onStateChanged(boolean b) {
        if (this.model.getHierarchyObject() instanceof ImageData && this.tabs != null) {
            if (b) {
                this.tabs.addChangeListener(this.controller);
            } else {
                this.tabs.removeChangeListener(this.controller);
            }
        }
    }

    boolean hasDataToSave() {
        if (this.model.getEditorType() == 100) {
            String s = this.doBasic.getNameText();
            return s != null && s.length() != 0;
        }
        return this.edit && this.doBasic.hasDataToSave();
    }

    void finish() {
        String s = this.doBasic.getNameText();
        if (s == null || s.length() == 0) {
            this.doBasic.resetNameArea();
            this.handleNameAreaRemove(0);
            return;
        }
        if (s.length() > 255) {
            UserNotifier un = TreeViewerAgent.getRegistry().getUserNotifier();
            un.notifyInfo("Editor", "The name is too long. Cannot be more than 255 characters long.");
            this.doBasic.resetName();
            return;
        }
        this.finishButton.setEnabled(false);
        switch (this.model.getEditorType()) {
            case 100: {
                this.controller.createObject(this.fillDataObject());
                break;
            }
            case 101: {
                this.finishEdit();
            }
        }
    }

    void setChannelsData() {
        if (this.tabs == null) {
            return;
        }
        for (int i = 0; i < this.tabs.getComponentCount(); ++i) {
            Component c = this.tabs.getComponentAt(i);
            DataObject ho = this.model.getHierarchyObject();
            if (!(c instanceof DOInfo) || !(ho instanceof ImageData)) continue;
            ImageData img = (ImageData)ho;
            Map<String, String> details = EditorUtil.transformImageData(img);
            List waves = this.model.getChannelsData();
            if (waves == null) {
                return;
            }
            String s = "";
            Iterator k = waves.iterator();
            int j = 0;
            while (k.hasNext()) {
                s = s + ((ChannelMetadata)k.next()).getEmissionWavelength();
                if (j != waves.size() - 1) {
                    s = s + ", ";
                }
                ++j;
            }
            details.put("Emissions wavelengths", s);
            ((DOInfo)c).setChannelsData(details);
        }
    }

    void setEditorSelectedPane(int selectedIndex) {
        if (this.model.getEditorType() == 101) {
            this.model.setEditorSelectedPane(selectedIndex);
        }
    }

    void setFocusOnName() {
        this.doBasic.nameArea.requestFocus();
    }

    void setDefaultButton(JRootPane rootPane) {
        rootPane.setDefaultButton(this.finishButton);
    }

    JFrame getParentUI() {
        return this.model.getParentModel().getUI();
    }

    void setStatus(boolean b, String text, boolean hide) {
        this.model.getParentModel().setStatus(b, text, hide);
    }

    void addSelectedNodes(List nodes) {
        if (this.annotator != null) {
            this.annotator.addSelectedNodes(nodes);
        }
    }

    public void setSize(int width, int height) {
        super.setSize(width, height);
        Dimension d = new Dimension(width, 80);
        this.titlePanel.setSize(d);
        this.titlePanel.setPreferredSize(d);
        this.titleLayer.setSize(d);
        this.titleLayer.setPreferredSize(d);
    }

    public void setSize(Dimension d) {
        this.setSize(d.width, d.height);
    }
}

