/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.treeviewer.editors;

import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.openmicroscopy.shoola.util.ui.MultilineLabel;

public class EditorSaverDialog
extends JDialog {
    public static final String SAVING_DATA_EDITOR_PROPERTY = "savingDataEditor";
    private static final String MESSAGE = "Do you want to save the modified data before selecting a new item?";
    protected static final Dimension MSG_AREA_SIZE = new Dimension(300, 50);
    protected static final Dimension H_SPACER_SIZE = new Dimension(20, 1);
    protected static final Dimension V_SPACER_SIZE = new Dimension(1, 20);
    protected JPanel contentPanel;
    protected JPanel messagePanel;
    protected JPanel buttonPanel;
    private JButton noButton;
    private JButton yesButton;

    private void yesSelection() {
        this.setCursor(Cursor.getPredefinedCursor(3));
        this.firePropertyChange(SAVING_DATA_EDITOR_PROPERTY, Boolean.FALSE, Boolean.TRUE);
    }

    private void noSelection() {
        this.firePropertyChange(SAVING_DATA_EDITOR_PROPERTY, Boolean.TRUE, Boolean.FALSE);
        this.close();
    }

    private void createComponents() {
        this.contentPanel = new JPanel();
        this.messagePanel = new JPanel();
        this.buttonPanel = new JPanel();
        this.noButton = new JButton("No");
        this.yesButton = new JButton("Yes");
    }

    private void attachListeners() {
        this.setDefaultCloseOperation(0);
        this.noButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                EditorSaverDialog.this.noSelection();
            }
        });
        this.yesButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                EditorSaverDialog.this.yesSelection();
            }
        });
    }

    private void buildMessagePanel(String msg, Icon msgIcon) {
        this.messagePanel.setLayout(new BoxLayout(this.messagePanel, 0));
        if (msgIcon != null) {
            JLabel iconLabel = new JLabel(msgIcon);
            iconLabel.setAlignmentY(0.0f);
            this.messagePanel.add(iconLabel);
            this.messagePanel.add(Box.createRigidArea(H_SPACER_SIZE));
        }
        MultilineLabel message = new MultilineLabel(msg);
        message.setPreferredSize(MSG_AREA_SIZE);
        message.setAlignmentY(0.0f);
        this.messagePanel.add(message);
    }

    private void buildButtonsPanel() {
        this.buttonPanel.setLayout(new BoxLayout(this.buttonPanel, 0));
        this.buttonPanel.add(Box.createHorizontalGlue());
        this.buttonPanel.add(this.yesButton);
        this.buttonPanel.add(Box.createRigidArea(H_SPACER_SIZE));
        this.buttonPanel.add(this.noButton);
    }

    private void buildGUI(String message, Icon messageIcon) {
        this.contentPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEtchedBorder(), BorderFactory.createEmptyBorder(5, 5, 15, 10)));
        this.contentPanel.setLayout(new BoxLayout(this.contentPanel, 1));
        this.buildMessagePanel(message, messageIcon);
        this.contentPanel.add(this.messagePanel);
        JPanel vSpacer = new JPanel();
        vSpacer.add(Box.createRigidArea(V_SPACER_SIZE));
        this.contentPanel.add(vSpacer);
        this.buildButtonsPanel();
        this.contentPanel.add(this.buttonPanel);
        this.getContentPane().add(this.contentPanel);
        this.pack();
    }

    public EditorSaverDialog(JFrame owner, Icon icon) {
        super(owner, "Save Edited data", true);
        this.createComponents();
        this.attachListeners();
        this.buildGUI(MESSAGE, icon);
    }

    public void close() {
        this.setVisible(false);
        this.dispose();
    }
}

