/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.treeviewer.editors;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.openmicroscopy.shoola.agents.treeviewer.ChannelDataLoader;
import org.openmicroscopy.shoola.agents.treeviewer.ClassificationPathsLoader;
import org.openmicroscopy.shoola.agents.treeviewer.DataObjectCreator;
import org.openmicroscopy.shoola.agents.treeviewer.DataObjectEditor;
import org.openmicroscopy.shoola.agents.treeviewer.EditorLoader;
import org.openmicroscopy.shoola.agents.treeviewer.TreeViewerAgent;
import org.openmicroscopy.shoola.agents.treeviewer.browser.Browser;
import org.openmicroscopy.shoola.agents.treeviewer.browser.TreeImageDisplay;
import org.openmicroscopy.shoola.agents.treeviewer.cmd.ViewCmd;
import org.openmicroscopy.shoola.agents.treeviewer.editors.Editor;
import org.openmicroscopy.shoola.agents.treeviewer.editors.EditorFactory;
import org.openmicroscopy.shoola.agents.treeviewer.view.TreeViewer;
import org.openmicroscopy.shoola.agents.util.annotator.view.AnnotatorEditor;
import org.openmicroscopy.shoola.agents.util.annotator.view.AnnotatorFactory;
import pojos.CategoryData;
import pojos.CategoryGroupData;
import pojos.DataObject;
import pojos.DatasetData;
import pojos.ExperimenterData;
import pojos.ImageData;
import pojos.PermissionData;
import pojos.ProjectData;

class EditorModel {
    private int state;
    private DataObject hierarchyObject;
    private int editorType;
    private TreeImageDisplay parent;
    private TreeViewer parentModel;
    private EditorLoader currentLoader;
    private Set classifications;
    private List emissionWaves;
    private boolean thumbnailLoaded;
    private AnnotatorEditor annotator;
    protected Editor component;

    protected EditorModel(TreeViewer parentModel, int editorType, DataObject hierarchyObject, TreeImageDisplay parent) {
        if (parentModel == null) {
            throw new NullPointerException("No parent model.");
        }
        if (editorType != 100 && editorType != 101) {
            throw new IllegalArgumentException("editor not supported.");
        }
        if (hierarchyObject == null) {
            throw new IllegalArgumentException("No Data object.");
        }
        this.state = 1;
        this.editorType = editorType;
        this.parentModel = parentModel;
        this.hierarchyObject = hierarchyObject;
        this.parent = editorType == 100 ? parent : null;
        this.thumbnailLoaded = false;
    }

    void initialize(Editor component) {
        this.component = component;
    }

    AnnotatorEditor createAnnotator() {
        if (this.annotator == null && this.isAnnotatable()) {
            this.annotator = AnnotatorFactory.getEditor(TreeViewerAgent.getRegistry(), this.hierarchyObject, 0);
        }
        return this.annotator;
    }

    String getParentName() {
        if (this.parent == null) {
            return null;
        }
        return this.parent.getNodeName();
    }

    Class getParentClass() {
        if (this.parent == null) {
            return null;
        }
        if (this.parent.getUserObject() == null) {
            return null;
        }
        return this.parent.getUserObject().getClass();
    }

    TreeViewer getParentModel() {
        return this.parentModel;
    }

    int getState() {
        return this.state;
    }

    void setState(int state) {
        this.state = state;
    }

    DataObject getHierarchyObject() {
        return this.hierarchyObject;
    }

    int getEditorType() {
        return this.editorType;
    }

    boolean hasThumbnail() {
        if (this.hierarchyObject == null) {
            return false;
        }
        return this.hierarchyObject instanceof ImageData;
    }

    boolean isAnnotatable() {
        if (this.hierarchyObject == null) {
            return false;
        }
        return this.hierarchyObject instanceof DatasetData || this.hierarchyObject instanceof ImageData;
    }

    boolean isClassified() {
        if (this.hierarchyObject == null || !(this.hierarchyObject instanceof ImageData)) {
            return false;
        }
        Long i = ((ImageData)this.hierarchyObject).getClassificationCount();
        return i != null && i != 0L;
    }

    ExperimenterData getDataObjectOwner() {
        if (this.hierarchyObject == null) {
            return null;
        }
        ExperimenterData exp = this.hierarchyObject.getOwner();
        if (exp == null) {
            return null;
        }
        if (exp.isLoaded()) {
            return exp;
        }
        ExperimenterData selectedExp = this.parentModel.getSelectedExperimenter();
        if (exp.getId() == selectedExp.getId()) {
            return selectedExp;
        }
        return exp;
    }

    String getDataObjectName() {
        if (this.hierarchyObject == null) {
            return null;
        }
        if (this.hierarchyObject instanceof DatasetData) {
            return ((DatasetData)this.hierarchyObject).getName();
        }
        if (this.hierarchyObject instanceof ProjectData) {
            return ((ProjectData)this.hierarchyObject).getName();
        }
        if (this.hierarchyObject instanceof CategoryData) {
            return ((CategoryData)this.hierarchyObject).getName();
        }
        if (this.hierarchyObject instanceof CategoryGroupData) {
            return ((CategoryGroupData)this.hierarchyObject).getName();
        }
        if (this.hierarchyObject instanceof ImageData) {
            return ((ImageData)this.hierarchyObject).getName();
        }
        if (this.hierarchyObject instanceof ExperimenterData) {
            ExperimenterData exp = (ExperimenterData)this.hierarchyObject;
            return exp.getFirstName() + " " + exp.getLastName();
        }
        return null;
    }

    long getDataObjectID() {
        if (this.hierarchyObject == null) {
            return -1L;
        }
        return this.hierarchyObject.getId();
    }

    String getDataObjectDescription() {
        if (this.hierarchyObject == null) {
            return null;
        }
        if (this.hierarchyObject instanceof DatasetData) {
            return ((DatasetData)this.hierarchyObject).getDescription();
        }
        if (this.hierarchyObject instanceof ProjectData) {
            return ((ProjectData)this.hierarchyObject).getDescription();
        }
        if (this.hierarchyObject instanceof CategoryData) {
            return ((CategoryData)this.hierarchyObject).getDescription();
        }
        if (this.hierarchyObject instanceof CategoryGroupData) {
            return ((CategoryGroupData)this.hierarchyObject).getDescription();
        }
        if (this.hierarchyObject instanceof ImageData) {
            return ((ImageData)this.hierarchyObject).getDescription();
        }
        return null;
    }

    void discard() {
        this.cancel();
        this.state = 2;
    }

    void cancel() {
        if (this.currentLoader != null) {
            this.currentLoader.cancel();
            this.currentLoader = null;
        }
        this.state = 8;
    }

    void browse(DataObject object) {
        if (object != null) {
            ViewCmd cmd = new ViewCmd(this.parentModel, object);
            cmd.execute();
        }
    }

    ExperimenterData getUserDetails() {
        return this.parentModel.getUserDetails();
    }

    boolean isClassificationLoaded() {
        return this.classifications != null;
    }

    void setClassifications(Set classifications) {
        this.state = 8;
        this.classifications = classifications;
    }

    Set getClassifications() {
        return this.classifications;
    }

    void fireAnnotationsLoading() {
        if (this.annotator != null) {
            this.annotator.activate();
        }
    }

    void fireClassificationLoading() {
        this.state = 4;
        long imageID = ((ImageData)this.hierarchyObject).getId();
        HashSet<Long> ids = new HashSet<Long>(1);
        ids.add(new Long(imageID));
        this.currentLoader = new ClassificationPathsLoader(this.component, ids, this.parentModel.getRootID());
        this.currentLoader.load();
    }

    void fireDataObjectCreation(DataObject object) {
        Browser b = this.parentModel.getSelectedBrowser();
        if (b == null) {
            return;
        }
        this.state = 6;
        TreeImageDisplay node = b.getLastSelectedDisplay();
        DataObject data = null;
        if (node != null) {
            Object p = node.getUserObject();
            if (!(object instanceof ProjectData) && !(object instanceof CategoryGroupData)) {
                data = (DataObject)p;
            }
        }
        this.currentLoader = new DataObjectCreator(this.component, object, data);
        this.currentLoader.load();
    }

    void fireDataObjectUpdate(DataObject object) {
        this.state = 6;
        this.currentLoader = new DataObjectEditor(this.component, object);
        this.currentLoader.load();
    }

    void setSaveResult(DataObject object, int operation) {
        this.state = 8;
        this.parentModel.onDataObjectSave(object, operation);
    }

    boolean isObjectOwner() {
        return this.hierarchyObject.getOwner().getId() == this.getUserDetails().getId();
    }

    boolean isWritable() {
        return this.parentModel.isObjectWritable(this.hierarchyObject);
    }

    PermissionData getObjectPermissions() {
        return this.hierarchyObject.getPermissions();
    }

    void retrieveChannelsData() {
        this.state = 5;
        ImageData img = (ImageData)this.hierarchyObject;
        long pixelsID = img.getDefaultPixels().getId();
        this.currentLoader = new ChannelDataLoader(this.component, pixelsID);
        this.currentLoader.load();
    }

    void setChannelsData(List emissionWaves) {
        this.emissionWaves = emissionWaves;
        this.state = 8;
    }

    List getChannelsData() {
        return this.emissionWaves;
    }

    int getSelectedTabbedIndex() {
        return EditorFactory.getEditorSelectedPane();
    }

    void setEditorSelectedPane(int index) {
        EditorFactory.setEditorSelectedPane(index);
    }

    int getSelectedSubPane() {
        return EditorFactory.getSubSelectedPane();
    }

    void setThumbnailLoaded(boolean b) {
        this.thumbnailLoaded = b;
    }

    boolean isThumbnailLoaded() {
        return this.thumbnailLoaded;
    }

    long getPixelsID() {
        if (this.hierarchyObject instanceof ImageData) {
            ImageData img = (ImageData)this.hierarchyObject;
            return img.getDefaultPixels().getId();
        }
        return -1L;
    }

    public boolean isReadable() {
        return this.parentModel.isReadable(this.hierarchyObject);
    }
}

