/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.treeviewer.editors;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.openmicroscopy.shoola.agents.treeviewer.browser.TreeImageDisplay;
import org.openmicroscopy.shoola.agents.treeviewer.editors.Editor;
import org.openmicroscopy.shoola.agents.treeviewer.editors.EditorComponent;
import org.openmicroscopy.shoola.agents.treeviewer.editors.EditorModel;
import org.openmicroscopy.shoola.agents.treeviewer.view.TreeViewer;
import pojos.DataObject;

public class EditorFactory
implements PropertyChangeListener {
    private static final EditorFactory singleton = new EditorFactory();
    private Editor editor = null;
    private int editorSelectedPane;
    private int subSelectedPane;

    public static void setEditorSelectedPane(int index) {
        switch (index) {
            case 0: 
            case 1: 
            case 2: {
                break;
            }
            default: {
                index = 0;
            }
        }
        EditorFactory.singleton.editorSelectedPane = index;
    }

    public static int getEditorSelectedPane() {
        return EditorFactory.singleton.editorSelectedPane;
    }

    public static int getSubSelectedPane() {
        return EditorFactory.singleton.subSelectedPane;
    }

    public static void setSubSelectedPane(int index) {
        switch (index) {
            case 0: 
            case 1: {
                break;
            }
            default: {
                index = 0;
            }
        }
        EditorFactory.singleton.subSelectedPane = index;
    }

    public static Editor getEditor(TreeViewer model, DataObject hierarchyObject, int editorType, TreeImageDisplay parent) {
        return singleton.getDOEditor(model, hierarchyObject, editorType, parent);
    }

    private EditorFactory() {
    }

    private Editor getDOEditor(TreeViewer model, DataObject ho, int editorType, TreeImageDisplay parent) {
        model.addPropertyChangeListener(this);
        EditorModel m = new EditorModel(model, editorType, ho, parent);
        EditorComponent component = new EditorComponent(m);
        m.initialize(component);
        component.initialize();
        this.editor = component;
        return this.editor;
    }

    public void propertyChange(PropertyChangeEvent pce) {
        String name = pce.getPropertyName();
        if (name.equals("removeEditor") && this.editor != null) {
            this.editor.discard();
            this.editor = null;
        }
    }
}

