/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.treeviewer.editors;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.openmicroscopy.shoola.agents.treeviewer.editors.Editor;
import org.openmicroscopy.shoola.agents.treeviewer.editors.EditorUI;
import pojos.DataObject;

public class EditorControl
implements ChangeListener,
PropertyChangeListener {
    private Editor model;
    private EditorUI view;

    EditorControl(Editor model) {
        if (model == null) {
            throw new NullPointerException("No model.");
        }
        this.model = model;
    }

    void initialize(EditorUI view) {
        if (view == null) {
            throw new NullPointerException("No view.");
        }
        this.view = view;
        this.model.addChangeListener(this);
    }

    void browse(DataObject object) {
        if (object == null) {
            throw new IllegalArgumentException("No object to browse.");
        }
    }

    void close(boolean b) {
        if (b) {
            this.model.close();
        }
    }

    void createObject(DataObject object) {
        if (object == null) {
            throw new IllegalArgumentException("No Data object to create.");
        }
        this.model.saveObject(object, 300);
    }

    void updateObject(DataObject object) {
        if (object == null) {
            throw new IllegalArgumentException("No Data object to update.");
        }
        this.model.saveObject(object, 301);
    }

    void loadClassifications() {
        this.model.loadClassifications();
    }

    void retrieveAnnotations() {
        this.model.retrieveAnnotations();
    }

    public void stateChanged(ChangeEvent e) {
        if (e.getSource() instanceof JTabbedPane) {
            JTabbedPane tab = (JTabbedPane)e.getSource();
            int index = tab.getSelectedIndex();
            switch (index) {
                case 1: {
                    this.view.setEditorSelectedPane(index);
                    this.retrieveAnnotations();
                    break;
                }
                case 2: {
                    this.model.retrieveChannelsData();
                    this.view.setEditorSelectedPane(index);
                    break;
                }
                case 0: {
                    this.view.setEditorSelectedPane(index);
                }
            }
        } else {
            this.view.onStateChanged(this.model.getState() == 8);
        }
    }

    public void propertyChange(PropertyChangeEvent evt) {
        String name = evt.getPropertyName();
        if ("annotated".equals(name)) {
            DataObject r = (DataObject)evt.getNewValue();
            this.model.setSaveResult(r, 301);
        } else if ("annotationLoaded".equals(name)) {
            this.view.setStatus(false, null, true);
        }
    }
}

