/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.treeviewer.editors;

import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.util.List;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JRootPane;
import org.openmicroscopy.shoola.agents.treeviewer.TreeViewerTranslator;
import org.openmicroscopy.shoola.agents.treeviewer.editors.Editor;
import org.openmicroscopy.shoola.agents.treeviewer.editors.EditorControl;
import org.openmicroscopy.shoola.agents.treeviewer.editors.EditorModel;
import org.openmicroscopy.shoola.agents.treeviewer.editors.EditorUI;
import org.openmicroscopy.shoola.util.ui.component.AbstractComponent;
import pojos.DataObject;

class EditorComponent
extends AbstractComponent
implements Editor {
    private EditorModel model;
    private EditorControl controller;
    private EditorUI view;

    private void checkDataObjectOperation(int i) {
        switch (i) {
            case 300: 
            case 301: {
                break;
            }
            default: {
                throw new IllegalArgumentException("DataObject operation not supported");
            }
        }
    }

    EditorComponent(EditorModel model) {
        if (model == null) {
            throw new NullPointerException("No model.");
        }
        this.model = model;
        this.controller = new EditorControl(this);
        this.view = new EditorUI();
    }

    void initialize() {
        this.controller.initialize(this.view);
        this.view.initialize(this.controller, this.model);
    }

    public int getState() {
        return this.model.getState();
    }

    public void activate() {
        switch (this.model.getState()) {
            case 1: {
                if (this.model.getEditorType() != 101) break;
                switch (this.model.getSelectedTabbedIndex()) {
                    case 0: {
                        int subIndex = this.model.getSelectedSubPane();
                        if (this.model.isAnnotatable() && subIndex == 0) {
                            this.retrieveAnnotations();
                            break;
                        }
                        if (!this.model.isClassified() || subIndex != 1) break;
                        this.loadClassifications();
                        break;
                    }
                    case 1: {
                        this.retrieveThumbnail();
                        break;
                    }
                    default: {
                        this.model.setState(8);
                    }
                }
                this.fireStateChange();
                break;
            }
            case 2: {
                throw new IllegalStateException("This method can't be invoked in the DISCARDED state.");
            }
        }
    }

    public void discard() {
        if (this.model.getState() != 2) {
            this.model.discard();
            this.fireStateChange();
        }
    }

    public void setThumbnail(BufferedImage thumbnail) {
        if (this.model.getState() != 2) {
            if (thumbnail == null) {
                return;
            }
            this.model.setThumbnailLoaded(true);
            this.view.setThumbnail(thumbnail);
            this.model.setState(8);
            this.fireStateChange();
        }
    }

    public void setRetrievedClassification(Set paths) {
        if (this.model.getState() != 4) {
            return;
        }
        if (paths == null) {
            throw new IllegalArgumentException("No paths to set.");
        }
        long userID = this.model.getUserDetails().getId();
        Set set = TreeViewerTranslator.transformHierarchy(paths, userID, -1L);
        this.model.setClassifications(set);
        this.view.showClassifications();
        this.retrieveThumbnail();
        this.model.getParentModel().setStatus(false, "", true);
        this.fireStateChange();
    }

    public void cancel() {
        if (this.model.getState() != 2) {
            this.model.cancel();
            this.fireStateChange();
        }
    }

    public JComponent getUI() {
        if (this.model.getState() == 2) {
            throw new IllegalStateException("This method cannot be invoked in the DISCARDED state.");
        }
        return this.view;
    }

    public void close() {
        if (this.model.getState() == 2) {
            throw new IllegalStateException("This method cannot be invoked in the DISCARDED state.");
        }
        this.firePropertyChange("closeEditor", Boolean.FALSE, Boolean.TRUE);
    }

    public void setSaveResult(DataObject object, int operation) {
        this.checkDataObjectOperation(operation);
        if (object == null) {
            throw new IllegalArgumentException("No DataObject to save.");
        }
        this.model.setSaveResult(object, operation);
        this.fireStateChange();
    }

    public void saveObject(DataObject object, int operation) {
        switch (this.model.getState()) {
            case 2: 
            case 4: {
                throw new IllegalStateException("This method cannot be invoked in the DISCARDED, LOADING_ANNOTATION or LOADING_CLASSIFICATION state.");
            }
        }
        if (object == null) {
            throw new IllegalArgumentException("No DataObject.");
        }
        this.checkDataObjectOperation(operation);
        switch (operation) {
            case 300: {
                this.model.fireDataObjectCreation(object);
                break;
            }
            case 301: {
                this.model.fireDataObjectUpdate(object);
            }
        }
        this.model.getParentModel().setStatus(false, "", true);
        this.fireStateChange();
    }

    public void loadClassifications() {
        switch (this.model.getState()) {
            default: 
        }
        if (!this.model.isClassified()) {
            return;
        }
        if (this.model.isClassificationLoaded()) {
            return;
        }
        this.model.fireClassificationLoading();
        this.model.getParentModel().setStatus(true, "Loading...", false);
        this.fireStateChange();
    }

    public boolean hasDataToSave() {
        if (this.model.getState() == 2) {
            return false;
        }
        return this.view.hasDataToSave();
    }

    public void saveData() {
        if (this.model.getState() == 2) {
            throw new IllegalStateException("This method cannot be invoked in the DISCARDED state.");
        }
        this.view.finish();
    }

    public void retrieveChannelsData() {
        if (this.model.getState() == 2) {
            throw new IllegalStateException("This method cannot be invoked in the DISCARDED state.");
        }
        if (this.model.getChannelsData() != null) {
            return;
        }
        this.model.retrieveChannelsData();
        this.fireStateChange();
    }

    public void setChannelsData(List emissionWaves) {
        if (this.model.getState() != 5) {
            return;
        }
        this.model.setChannelsData(emissionWaves);
        this.retrieveThumbnail();
        this.fireStateChange();
        this.view.setChannelsData();
    }

    public void retrieveAnnotations() {
        if (this.model.getEditorType() != 101) {
            return;
        }
        if (this.model.isAnnotatable() && this.model.getSelectedTabbedIndex() == 1) {
            this.model.fireAnnotationsLoading();
            this.model.getParentModel().setStatus(true, "Loading...", false);
        }
        this.retrieveThumbnail();
    }

    public int getSelectedSubPane() {
        return this.model.getSelectedSubPane();
    }

    public void retrieveThumbnail() {
        if (this.model.hasThumbnail() && !this.model.isThumbnailLoaded()) {
            this.firePropertyChange("thumbnailLoading", null, this.model.getHierarchyObject());
        }
    }

    public void setFocusOnName() {
        if (this.model.getEditorType() != 100) {
            return;
        }
        this.view.setFocusOnName();
    }

    public void setSize(Dimension d) {
        if (this.model.getEditorType() != 100) {
            return;
        }
        this.view.setSize(d);
    }

    public void setDefaultButton(JRootPane rootPane) {
        if (rootPane == null) {
            return;
        }
        this.view.setDefaultButton(rootPane);
    }

    public void addSiblings(List nodes) {
        this.view.addSelectedNodes(nodes);
    }
}

