/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.treeviewer.editors;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Iterator;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import layout.TableLayout;
import org.openmicroscopy.shoola.agents.treeviewer.editors.EditorModel;
import org.openmicroscopy.shoola.agents.treeviewer.editors.EditorUI;
import org.openmicroscopy.shoola.util.ui.UIUtilities;
import pojos.PermissionData;

class DOInfo
extends JPanel {
    static final int OWNER_TYPE = 0;
    static final int INFO_TYPE = 1;
    private static final String OWNER = "Owner: ";
    private static final String GROUP = "Group: ";
    private static final String WORLD = "Others: ";
    private static final String READ = "Read";
    private static final String WRITE = "Write";
    private JPanel contentPanel;
    private EditorModel model;
    private EditorUI view;
    private int infoType;

    private void checkType(int t) {
        switch (t) {
            case 0: 
            case 1: {
                this.infoType = t;
                return;
            }
        }
        throw new IllegalArgumentException("Type not supported");
    }

    private JPanel buildContentPanel(Map details) {
        JPanel content = new JPanel();
        content.setLayout(new GridBagLayout());
        content.setBorder(BorderFactory.createEmptyBorder(5, 10, 5, 10));
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 2;
        c.anchor = 17;
        c.insets = new Insets(3, 3, 3, 3);
        Iterator i = details.keySet().iterator();
        while (i.hasNext()) {
            ++c.gridy;
            c.gridx = 0;
            String key = (String)i.next();
            String value = (String)details.get(key);
            JLabel label = UIUtilities.setTextFont(key);
            c.gridwidth = -1;
            c.weightx = 0.0;
            content.add((Component)label, c);
            JTextField area = new JTextField(value);
            area.setEditable(false);
            area.setEnabled(false);
            label.setLabelFor(area);
            c.gridx = 1;
            c.gridwidth = 0;
            c.fill = 2;
            c.weightx = 1.0;
            content.add((Component)area, c);
        }
        return content;
    }

    private JPanel buildPermissions(final PermissionData permissions) {
        JPanel content = new JPanel();
        double[][] tl = new double[][]{{-2.0, -1.0}, {-2.0, -2.0, -2.0}};
        content.setLayout((LayoutManager)new TableLayout((double[][])tl));
        content.setBorder(BorderFactory.createEmptyBorder(5, 10, 5, 10));
        JLabel label = UIUtilities.setTextFont(OWNER);
        JPanel p = new JPanel();
        JCheckBox box = new JCheckBox(READ);
        box.setSelected(permissions.isUserRead());
        box.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JCheckBox source = (JCheckBox)e.getSource();
                permissions.setUserRead(source.isSelected());
                DOInfo.this.view.setEdit(true);
            }
        });
        box.setEnabled(false);
        p.add(box);
        box = new JCheckBox(WRITE);
        box.setSelected(permissions.isUserWrite());
        box.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JCheckBox source = (JCheckBox)e.getSource();
                permissions.setUserWrite(source.isSelected());
                DOInfo.this.view.setEdit(true);
            }
        });
        box.setEnabled(false);
        p.add(box);
        content.add((Component)label, "0, 0, l, c");
        content.add((Component)p, "1, 0, l, c");
        label = UIUtilities.setTextFont(GROUP);
        p = new JPanel();
        box = new JCheckBox(READ);
        box.setSelected(permissions.isGroupRead());
        box.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JCheckBox source = (JCheckBox)e.getSource();
                permissions.setGroupRead(source.isSelected());
                DOInfo.this.view.setEdit(true);
            }
        });
        box.setEnabled(false);
        p.add(box);
        box = new JCheckBox(WRITE);
        box.setSelected(permissions.isGroupWrite());
        box.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JCheckBox source = (JCheckBox)e.getSource();
                permissions.setGroupWrite(source.isSelected());
                DOInfo.this.view.setEdit(true);
            }
        });
        box.setEnabled(false);
        p.add(box);
        content.add((Component)label, "0, 1, l, c");
        content.add((Component)p, "1,1, l, c");
        label = UIUtilities.setTextFont(WORLD);
        p = new JPanel();
        box = new JCheckBox(READ);
        box.setSelected(permissions.isWorldRead());
        box.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JCheckBox source = (JCheckBox)e.getSource();
                permissions.setWorldRead(source.isSelected());
                DOInfo.this.view.setEdit(true);
            }
        });
        box.setEnabled(false);
        p.add(box);
        box = new JCheckBox(WRITE);
        box.setSelected(permissions.isWorldWrite());
        box.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JCheckBox source = (JCheckBox)e.getSource();
                permissions.setWorldWrite(source.isSelected());
                DOInfo.this.view.setEdit(true);
            }
        });
        box.setEnabled(false);
        p.add(box);
        content.add((Component)label, "0, 2, l, c");
        content.add((Component)p, "1, 2, l, c");
        return content;
    }

    private void buildGUI(Map details, boolean permission) {
        this.contentPanel = this.buildContentPanel(details);
        if (this.model.getObjectPermissions() != null && permission) {
            double[][] tl = new double[][]{{-1.0}, {-2.0, -2.0}};
            this.setLayout((LayoutManager)new TableLayout((double[][])tl));
            JPanel p = new JPanel();
            p.setLayout(new BoxLayout(p, 1));
            p.setBorder(BorderFactory.createEmptyBorder(0, 10, 0, 10));
            p.add(new JSeparator());
            p.add(Box.createRigidArea(EditorUI.SMALL_V_SPACER_SIZE));
            p.add(this.buildPermissions(this.model.getObjectPermissions()));
            p.add(Box.createVerticalGlue());
            this.add((Component)this.contentPanel, "0, 0, f, t");
            this.add((Component)p, "0, 1, f, t");
        } else {
            double[][] tl = new double[][]{{-1.0}, {-2.0}};
            this.setLayout((LayoutManager)new TableLayout((double[][])tl));
            this.add((Component)this.contentPanel, "0, 0, f, t");
        }
    }

    DOInfo(EditorUI view, EditorModel model, Map details, boolean permission, int type) {
        if (view == null) {
            throw new IllegalArgumentException("No model.");
        }
        if (model == null) {
            throw new IllegalArgumentException("No model.");
        }
        if (details == null) {
            throw new IllegalArgumentException("Visualization map cannot be null");
        }
        this.view = view;
        this.model = model;
        this.checkType(type);
        this.buildGUI(details, permission);
    }

    int getInfoType() {
        return this.infoType;
    }

    void setChannelsData(Map details) {
        if (details == null) {
            throw new IllegalArgumentException("Visualization map cannot be null");
        }
        if (this.infoType != 1) {
            return;
        }
        this.remove(this.contentPanel);
        this.contentPanel = this.buildContentPanel(details);
        this.add((Component)this.contentPanel, "North");
        this.validate();
        this.repaint();
    }
}

