/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.treeviewer.editors;

import java.awt.Component;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import org.openmicroscopy.shoola.agents.treeviewer.browser.TreeImageDisplay;
import org.openmicroscopy.shoola.agents.treeviewer.browser.TreeImageSet;
import org.openmicroscopy.shoola.agents.treeviewer.editors.EditorControl;
import org.openmicroscopy.shoola.agents.treeviewer.editors.EditorModel;
import org.openmicroscopy.shoola.agents.treeviewer.util.TreeCellRenderer;
import org.openmicroscopy.shoola.agents.util.ViewerSorter;
import org.openmicroscopy.shoola.util.ui.UIUtilities;
import pojos.DataObject;

class DOClassification
extends JPanel {
    private static final String PANEL_NOTE = "The image is currently categorised in the following categories.";
    private static final String PANEL_SUBNOTE = "Double click on the name to browse the group or the category.";
    private static final String NO_CLASSIFICATION_TEXT = "The selected image has not been categorised. ";
    private static final String ROOT = "";
    private EditorModel model;
    private EditorControl controller;
    private JTree treeDisplay;
    private JButton refreshButton;
    private ViewerSorter sorter;

    private void buildTreeNode(DefaultMutableTreeNode parent, List nodes) {
        DefaultTreeModel tm = (DefaultTreeModel)this.treeDisplay.getModel();
        for (TreeImageDisplay display : nodes) {
            Set children;
            tm.insertNodeInto(display, parent, parent.getChildCount());
            if (!(display instanceof TreeImageSet) || (children = display.getChildrenDisplay()).size() == 0) continue;
            this.buildTreeNode(display, this.sorter.sort(children));
        }
    }

    private void onClick(MouseEvent me) {
        Point p = me.getPoint();
        int row = this.treeDisplay.getRowForLocation(p.x, p.y);
        if (row != -1) {
            this.treeDisplay.setSelectionRow(row);
            if (me.getClickCount() != 2) {
                return;
            }
            Object node = this.treeDisplay.getLastSelectedPathComponent();
            if (!(node instanceof TreeImageDisplay)) {
                return;
            }
            Object userObject = ((TreeImageDisplay)node).getUserObject();
            if (userObject instanceof DataObject) {
                this.model.browse((DataObject)userObject);
            }
        }
    }

    private void initComponents() {
        this.refreshButton = new JButton("Refresh");
        this.refreshButton.setEnabled(false);
        this.refreshButton.setToolTipText(UIUtilities.formatToolTipText("Reload data."));
        this.refreshButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DOClassification.this.refreshButton.setEnabled(false);
                DOClassification.this.controller.loadClassifications();
            }
        });
        this.treeDisplay = new JTree();
        this.treeDisplay.setRootVisible(false);
        this.treeDisplay.setCellRenderer(new TreeCellRenderer(false));
        this.treeDisplay.setShowsRootHandles(true);
        this.treeDisplay.putClientProperty("JTree.lineStyle", "Angled");
        this.treeDisplay.getSelectionModel().setSelectionMode(1);
        TreeImageSet root = new TreeImageSet(ROOT);
        this.treeDisplay.setModel(new DefaultTreeModel(root));
        this.treeDisplay.expandPath(new TreePath(root.getPath()));
        this.treeDisplay.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                DOClassification.this.onClick(e);
            }

            public void mouseReleased(MouseEvent e) {
                DOClassification.this.onClick(e);
            }
        });
    }

    private JPanel createToolBar() {
        JPanel bar = new JPanel();
        bar.setBorder(null);
        bar.add(this.refreshButton);
        return UIUtilities.buildComponentPanel(bar);
    }

    private void buildGUI() {
        this.setLayout(new BoxLayout(this, 1));
        JPanel labels = new JPanel();
        labels.setLayout(new BoxLayout(labels, 1));
        labels.add(new JLabel(PANEL_NOTE));
        labels.add(new JLabel(PANEL_SUBNOTE));
        JPanel p = new JPanel();
        p.setLayout(new BoxLayout(p, 0));
        p.add(UIUtilities.buildComponentPanel(labels));
        p.add(this.createToolBar());
        this.add((Component)UIUtilities.buildComponentPanel(p), "North");
        this.add((Component)new JScrollPane(this.treeDisplay), "Center");
    }

    private void buildGUINoClassifications() {
        this.setLayout(new BoxLayout(this, 1));
        JPanel p = new JPanel();
        p.add(new JLabel(NO_CLASSIFICATION_TEXT));
        p.setLayout(new BoxLayout(p, 1));
        this.add((Component)UIUtilities.buildComponentPanel(p), "North");
    }

    DOClassification(EditorModel model, EditorControl controller) {
        if (model == null) {
            throw new IllegalArgumentException("No Model.");
        }
        if (controller == null) {
            throw new IllegalArgumentException("No Control.");
        }
        this.model = model;
        this.controller = controller;
        this.sorter = new ViewerSorter();
        if (!model.isClassified()) {
            this.buildGUINoClassifications();
        } else {
            this.initComponents();
            this.buildGUI();
        }
    }

    void showClassifications() {
        if (!this.model.isClassificationLoaded()) {
            return;
        }
        this.refreshButton.setEnabled(true);
        Set nodes = this.model.getClassifications();
        DefaultTreeModel dtm = (DefaultTreeModel)this.treeDisplay.getModel();
        TreeImageDisplay root = (TreeImageDisplay)dtm.getRoot();
        root.removeAllChildren();
        root.removeAllChildrenDisplay();
        if (nodes.size() != 0) {
            Iterator i = nodes.iterator();
            while (i.hasNext()) {
                root.addChildDisplay((TreeImageDisplay)i.next());
            }
            this.buildTreeNode(root, this.sorter.sort(nodes));
        }
        dtm.reload();
    }
}

