/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.treeviewer.editors;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import layout.TableLayout;
import org.openmicroscopy.shoola.agents.treeviewer.TreeViewerAgent;
import org.openmicroscopy.shoola.agents.treeviewer.editors.DOInfo;
import org.openmicroscopy.shoola.agents.treeviewer.editors.EditorControl;
import org.openmicroscopy.shoola.agents.treeviewer.editors.EditorFactory;
import org.openmicroscopy.shoola.agents.treeviewer.editors.EditorModel;
import org.openmicroscopy.shoola.agents.treeviewer.editors.EditorUI;
import org.openmicroscopy.shoola.agents.treeviewer.editors.EditorUtil;
import org.openmicroscopy.shoola.agents.util.archived.view.Downloader;
import org.openmicroscopy.shoola.agents.util.archived.view.DownloaderFactory;
import org.openmicroscopy.shoola.util.ui.MultilineLabel;
import org.openmicroscopy.shoola.util.ui.UIUtilities;
import pojos.ExperimenterData;
import pojos.ImageData;

class DOBasic
extends JPanel {
    static final String ANNOTATION = "Annotation";
    static final String CLASSIFICATION = "Categorisation";
    private final String DOWNLOAD = "Download";
    private final String DOWNLOAD_DESCRIPTION = "Download the archived files";
    JTextField nameArea;
    JTextArea descriptionArea;
    private JButton download;
    private JTabbedPane tabbedPane;
    private DOInfo permissionsInfo;
    private DocumentListener nameAreaListener;
    private EditorUI view;
    private EditorModel model;
    private EditorControl controller;

    void download() {
        Downloader dl = DownloaderFactory.getDownloader(this.model.getParentModel().getUI(), TreeViewerAgent.getRegistry(), this.model.getPixelsID());
        dl.activate();
    }

    private void initComponents() {
        this.tabbedPane = new JTabbedPane();
        this.nameArea = new JTextField();
        UIUtilities.setTextAreaDefault(this.nameArea);
        this.descriptionArea = new MultilineLabel();
        UIUtilities.setTextAreaDefault(this.descriptionArea);
        if (this.model.getEditorType() == 101) {
            this.nameArea.setText(this.model.getDataObjectName());
            this.descriptionArea.setText(this.model.getDataObjectDescription());
            boolean b = this.model.isWritable();
            this.nameArea.setEnabled(b);
            this.descriptionArea.setEnabled(b);
            this.descriptionArea.getDocument().addDocumentListener(new DocumentListener(){

                public void insertUpdate(DocumentEvent de) {
                    DOBasic.this.view.handleDescriptionAreaInsert();
                }

                public void removeUpdate(DocumentEvent de) {
                    DOBasic.this.view.handleDescriptionAreaInsert();
                }

                public void changedUpdate(DocumentEvent de) {
                }
            });
            if (this.model.getHierarchyObject() instanceof ImageData) {
                this.download = new JButton("Download");
                this.download.setToolTipText("Download the archived files");
                this.download.setEnabled(this.model.isReadable());
                this.download.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        DOBasic.this.download();
                    }
                });
            }
            ExperimenterData exp = this.model.getDataObjectOwner();
            Map<String, String> details = EditorUtil.transformExperimenterData(exp);
            this.permissionsInfo = new DOInfo(this.view, this.model, details, true, 0);
        }
        this.nameAreaListener = new DocumentListener(){

            public void insertUpdate(DocumentEvent de) {
                DOBasic.this.view.handleNameAreaInsert();
            }

            public void removeUpdate(DocumentEvent de) {
                DOBasic.this.view.handleNameAreaRemove(de.getDocument().getLength());
            }

            public void changedUpdate(DocumentEvent de) {
            }
        };
        this.nameArea.getDocument().addDocumentListener(this.nameAreaListener);
        this.nameArea.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                JTextField field;
                Object source;
                if (e.getKeyCode() == 10 && (source = e.getSource()) instanceof JTextField && (field = (JTextField)source).getText() != null && field.getText().length() > 0) {
                    DOBasic.this.view.finish();
                }
            }
        });
        if (this.tabbedPane == null) {
            return;
        }
        this.tabbedPane.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent ce) {
                JTabbedPane pane = (JTabbedPane)ce.getSource();
                int index = pane.getSelectedIndex();
                EditorFactory.setSubSelectedPane(index);
                switch (index) {
                    case 0: {
                        if (!DOBasic.this.model.isAnnotatable()) break;
                        DOBasic.this.controller.retrieveAnnotations();
                        break;
                    }
                    case 1: {
                        if (!DOBasic.this.model.isClassified() || DOBasic.this.model.isClassificationLoaded()) break;
                        DOBasic.this.controller.loadClassifications();
                    }
                }
            }
        });
    }

    private JPanel buildContentPanel() {
        JLabel l;
        JPanel content = new JPanel();
        int height = 100;
        if (this.model.isAnnotatable()) {
            height = 50;
        }
        double[][] tl = new double[][]{{-2.0, -1.0}, {0.0, -2.0, 5.0, 0.0, height}};
        TableLayout layout = new TableLayout((double[][])tl);
        content.setLayout((LayoutManager)layout);
        content.setBorder(BorderFactory.createEmptyBorder(5, 10, 5, 10));
        if (this.model.getEditorType() != 100) {
            layout.setRow(0, -2.0);
            content.add((Component)UIUtilities.setTextFont("ID"), "0, 0, l, c");
            l = new JLabel("" + this.model.getDataObjectID());
            l.setBorder(BorderFactory.createEmptyBorder(5, 0, 5, 5));
            content.add((Component)l, "1, 0, f, c");
        }
        content.add((Component)UIUtilities.setTextFont("Name"), "0, 1, l, c");
        content.add((Component)this.nameArea, "1, 1, f, c");
        content.add((Component)new JLabel(), "0, 2, 1, 2");
        l = UIUtilities.setTextFont("Description");
        int h = l.getFontMetrics(l.getFont()).getHeight() + 5;
        layout.setRow(3, (double)h);
        content.add((Component)l, "0, 3, l, c");
        JScrollPane pane = new JScrollPane(this.descriptionArea);
        content.add((Component)pane, "1, 3, 1, 4");
        return content;
    }

    private void buildGUI() {
        this.setLayout(new BorderLayout());
        if (this.permissionsInfo != null) {
            JPanel p = new JPanel();
            p.setLayout(new BoxLayout(p, 1));
            p.add(this.buildContentPanel());
            p.add(this.permissionsInfo);
            this.add((Component)p, "North");
        } else {
            this.add((Component)this.buildContentPanel(), "North");
        }
        this.add((Component)this.view.buildBasicToolBar(this.download), "South");
    }

    DOBasic(EditorUI view, EditorModel model, EditorControl controller) {
        if (view == null) {
            throw new IllegalArgumentException("No View.");
        }
        if (model == null) {
            throw new IllegalArgumentException("No Model.");
        }
        if (controller == null) {
            throw new IllegalArgumentException("No Control.");
        }
        this.view = view;
        this.model = model;
        this.controller = controller;
        this.initComponents();
        this.buildGUI();
    }

    String getNameText() {
        return this.nameArea.getText().trim();
    }

    String getDescriptionText() {
        return this.descriptionArea.getText().trim();
    }

    void resetNameArea() {
        this.nameArea.getDocument().removeDocumentListener(this.nameAreaListener);
        this.nameArea.setText(null);
        this.nameArea.getDocument().addDocumentListener(this.nameAreaListener);
    }

    void showClassifications() {
    }

    void resetName() {
        this.nameArea.getDocument().removeDocumentListener(this.nameAreaListener);
        if (this.model.getEditorType() == 101) {
            this.nameArea.setText(this.model.getDataObjectName());
        } else {
            this.nameArea.setText("");
        }
        this.nameArea.getDocument().addDocumentListener(this.nameAreaListener);
    }

    boolean hasDataToSave() {
        String s = this.getNameText();
        String name = this.model.getDataObjectName();
        if (!name.equals(s)) {
            return true;
        }
        String d = this.getDescriptionText();
        String description = this.model.getDataObjectDescription();
        if (d == null) {
            return description != null;
        }
        return !d.equals(description);
    }

    void addSiblings(List nodes) {
    }
}

