/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.treeviewer.cmd;

import java.awt.Rectangle;
import java.util.HashSet;
import org.openmicroscopy.shoola.agents.events.hiviewer.Browse;
import org.openmicroscopy.shoola.agents.events.iviewer.ViewImage;
import org.openmicroscopy.shoola.agents.treeviewer.TreeViewerAgent;
import org.openmicroscopy.shoola.agents.treeviewer.browser.Browser;
import org.openmicroscopy.shoola.agents.treeviewer.browser.TreeImageDisplay;
import org.openmicroscopy.shoola.agents.treeviewer.cmd.ActionCmd;
import org.openmicroscopy.shoola.agents.treeviewer.view.TreeViewer;
import org.openmicroscopy.shoola.env.event.EventBus;
import org.openmicroscopy.shoola.env.ui.UserNotifier;
import pojos.CategoryData;
import pojos.CategoryGroupData;
import pojos.DataObject;
import pojos.DatasetData;
import pojos.ExperimenterData;
import pojos.ImageData;
import pojos.ProjectData;

public class ViewCmd
implements ActionCmd {
    private TreeViewer model;
    private DataObject hierarchyObject;

    public ViewCmd(TreeViewer model) {
        if (model == null) {
            throw new IllegalArgumentException("No model.");
        }
        this.model = model;
    }

    public ViewCmd(TreeViewer model, DataObject hierarchyObject) {
        if (model == null) {
            throw new IllegalArgumentException("No model.");
        }
        this.model = model;
        if (hierarchyObject == null) {
            throw new IllegalArgumentException("No hierarchyObject.");
        }
        this.hierarchyObject = hierarchyObject;
    }

    public void execute() {
        Browser browser = this.model.getSelectedBrowser();
        if (browser == null) {
            return;
        }
        Object ho = null;
        EventBus bus = TreeViewerAgent.getRegistry().getEventBus();
        Rectangle bounds = this.model.getUI().getBounds();
        ExperimenterData exp = this.model.getSelectedExperimenter();
        if (this.hierarchyObject != null) {
            ho = this.hierarchyObject;
        } else {
            TreeImageDisplay[] nodes = browser.getSelectedDisplays();
            if (nodes.length > 1) {
                TreeImageDisplay n = nodes[0];
                if (n.getUserObject() instanceof ImageData) {
                    HashSet<Long> ids = new HashSet<Long>(nodes.length);
                    for (int i = 0; i < nodes.length; ++i) {
                        ImageData data = (ImageData)nodes[i].getUserObject();
                        ids.add(new Long(data.getId()));
                    }
                    bus.post(new Browse(ids, 4, exp, this.model.getUserGroupID(), bounds));
                    return;
                }
                if (n.getUserObject() instanceof DatasetData) {
                    HashSet<Long> ids = new HashSet<Long>(nodes.length);
                    for (int i = 0; i < nodes.length; ++i) {
                        DatasetData data = (DatasetData)nodes[i].getUserObject();
                        ids.add(new Long(data.getId()));
                    }
                    bus.post(new Browse(ids, 5, exp, this.model.getUserGroupID(), bounds));
                    return;
                }
                if (n.getUserObject() instanceof CategoryData) {
                    HashSet<Long> ids = new HashSet<Long>(nodes.length);
                    for (int i = 0; i < nodes.length; ++i) {
                        CategoryData data = (CategoryData)nodes[i].getUserObject();
                        ids.add(new Long(data.getId()));
                    }
                    bus.post(new Browse(ids, 6, exp, this.model.getUserGroupID(), bounds));
                    return;
                }
                if (n.getUserObject() instanceof ProjectData) {
                    HashSet<Long> ids = new HashSet<Long>(nodes.length);
                    for (int i = 0; i < nodes.length; ++i) {
                        ProjectData data = (ProjectData)nodes[i].getUserObject();
                        ids.add(new Long(data.getId()));
                    }
                    bus.post(new Browse(ids, 7, exp, this.model.getUserGroupID(), bounds));
                    return;
                }
                if (n.getUserObject() instanceof CategoryGroupData) {
                    HashSet<Long> ids = new HashSet<Long>(nodes.length);
                    for (int i = 0; i < nodes.length; ++i) {
                        CategoryGroupData data = (CategoryGroupData)nodes[i].getUserObject();
                        ids.add(new Long(data.getId()));
                    }
                    bus.post(new Browse(ids, 8, exp, this.model.getUserGroupID(), bounds));
                    return;
                }
            } else {
                TreeImageDisplay display = browser.getLastSelectedDisplay();
                if (display == null) {
                    return;
                }
                if (display.getParentDisplay() == null && browser.getBrowserType() == 102) {
                    bus.post(new Browse(browser.getLeaves(), 4, exp, this.model.getUserGroupID(), bounds));
                    return;
                }
                ho = display.getUserObject();
            }
        }
        if (ho instanceof ImageData) {
            ImageData data = (ImageData)ho;
            long pixelsID = -1L;
            try {
                pixelsID = data.getDefaultPixels().getId();
            }
            catch (Exception e) {
                UserNotifier un = TreeViewerAgent.getRegistry().getUserNotifier();
                un.notifyInfo("View Image", "No pixels set associated to this image.");
                return;
            }
            bus.post(new ViewImage(data.getId(), pixelsID, data.getName(), bounds));
        } else if (ho instanceof DatasetData) {
            bus.post(new Browse(((DatasetData)ho).getId(), 1, exp, this.model.getUserGroupID(), bounds));
        } else if (ho instanceof ProjectData) {
            bus.post(new Browse(((ProjectData)ho).getId(), 0, exp, this.model.getUserGroupID(), bounds));
        } else if (ho instanceof CategoryData) {
            bus.post(new Browse(((CategoryData)ho).getId(), 3, exp, this.model.getUserGroupID(), bounds));
        } else if (ho instanceof CategoryGroupData) {
            bus.post(new Browse(((CategoryGroupData)ho).getId(), 2, exp, this.model.getUserGroupID(), bounds));
        }
    }
}

