/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.treeviewer.cmd;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openmicroscopy.shoola.agents.treeviewer.browser.Browser;
import org.openmicroscopy.shoola.agents.treeviewer.browser.TreeImageDisplay;
import org.openmicroscopy.shoola.agents.treeviewer.browser.TreeImageSet;
import org.openmicroscopy.shoola.agents.treeviewer.cmd.BrowserVisitor;
import pojos.CategoryData;
import pojos.CategoryGroupData;
import pojos.DataObject;
import pojos.DatasetData;
import pojos.ProjectData;

public class RefreshVisitor
extends BrowserVisitor {
    private List<DataObject> foundNodes = new ArrayList<DataObject>();
    private Map<Class, List> expandedTopNodes = new HashMap<Class, List>();

    public RefreshVisitor(Browser model) {
        super(model);
    }

    public List getFoundNodes() {
        return this.foundNodes;
    }

    public Map getExpandedTopNodes() {
        return this.expandedTopNodes;
    }

    public void visit(TreeImageSet node) {
        Object userObject = node.getUserObject();
        if (userObject instanceof DatasetData) {
            if (node.isChildrenLoaded() && node.isExpanded()) {
                TreeImageDisplay parent = node.getParentDisplay();
                if (parent.isExpanded()) {
                    this.foundNodes.add((DataObject)userObject);
                }
                if (!(parent.getUserObject() instanceof ProjectData)) {
                    long id = ((DataObject)userObject).getId();
                    ArrayList<Long> l = this.expandedTopNodes.get(DatasetData.class);
                    if (l == null) {
                        l = new ArrayList<Long>();
                        this.expandedTopNodes.put(DatasetData.class, l);
                    }
                    l.add(new Long(id));
                }
            }
        } else if (userObject instanceof CategoryData) {
            if (node.isChildrenLoaded() && node.isExpanded()) {
                TreeImageDisplay parent = node.getParentDisplay();
                if (parent.isExpanded()) {
                    this.foundNodes.add((DataObject)userObject);
                }
                if (!(parent.getUserObject() instanceof CategoryGroupData)) {
                    long id = ((DataObject)userObject).getId();
                    ArrayList<Long> l = this.expandedTopNodes.get(CategoryData.class);
                    if (l == null) {
                        l = new ArrayList<Long>();
                        this.expandedTopNodes.put(CategoryData.class, l);
                    }
                    l.add(new Long(id));
                }
            }
        } else if (userObject instanceof CategoryGroupData) {
            if (node.isExpanded()) {
                long id = ((DataObject)userObject).getId();
                ArrayList<Long> l = this.expandedTopNodes.get(CategoryGroupData.class);
                if (l == null) {
                    l = new ArrayList<Long>();
                    this.expandedTopNodes.put(CategoryGroupData.class, l);
                }
                l.add(new Long(id));
            }
        } else if (userObject instanceof ProjectData && node.isExpanded()) {
            long id = ((DataObject)userObject).getId();
            ArrayList<Long> l = this.expandedTopNodes.get(ProjectData.class);
            if (l == null) {
                l = new ArrayList<Long>();
                this.expandedTopNodes.put(ProjectData.class, l);
            }
            l.add(new Long(id));
        }
    }
}

