/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.treeviewer.cmd;

import org.openmicroscopy.shoola.agents.treeviewer.browser.Browser;
import org.openmicroscopy.shoola.agents.treeviewer.browser.TreeImageDisplay;
import org.openmicroscopy.shoola.agents.treeviewer.cmd.ActionCmd;
import org.openmicroscopy.shoola.agents.treeviewer.view.TreeViewer;
import pojos.ImageData;

public class ClassifyCmd
implements ActionCmd {
    public static final int CLASSIFY = 0;
    public static final int DECLASSIFY = 1;
    private TreeViewer viewer;
    private int mode;

    private void checkMode(int m) {
        switch (m) {
            case 0: 
            case 1: {
                return;
            }
        }
        throw new IllegalArgumentException("Mode not supported.");
    }

    public ClassifyCmd(TreeViewer viewer, int mode) {
        if (viewer == null) {
            throw new IllegalArgumentException("No model.");
        }
        this.checkMode(mode);
        this.viewer = viewer;
        this.mode = mode;
    }

    public void execute() {
        Browser browser = this.viewer.getSelectedBrowser();
        if (browser == null) {
            return;
        }
        TreeImageDisplay node = browser.getLastSelectedDisplay();
        if (node == null) {
            return;
        }
        Object data = node.getUserObject();
        if (data instanceof ImageData) {
            TreeImageDisplay[] nodes = browser.getSelectedDisplays();
            ImageData[] images = new ImageData[nodes.length];
            for (int i = 0; i < nodes.length; ++i) {
                images[i] = (ImageData)nodes[i].getUserObject();
            }
            this.viewer.showClassifier(images, this.mode);
        }
    }
}

