/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.treeviewer.cmd;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.openmicroscopy.shoola.agents.treeviewer.browser.Browser;
import org.openmicroscopy.shoola.agents.treeviewer.browser.TreeImageDisplay;
import org.openmicroscopy.shoola.agents.treeviewer.browser.TreeImageNode;
import org.openmicroscopy.shoola.agents.treeviewer.cmd.BrowserVisitor;
import pojos.CategoryData;
import pojos.ImageData;

public class ClassificationVisitor
extends BrowserVisitor {
    private ImageData image;
    private List<Long> dataObjects;
    private List<TreeImageDisplay> foundNodes;

    public ClassificationVisitor(Browser model, ImageData image, Set categories) {
        super(model);
        if (image == null) {
            throw new IllegalArgumentException("Image cannot be null");
        }
        if (categories == null) {
            throw new IllegalArgumentException("Categories cannot be null");
        }
        this.image = image;
        Iterator i = categories.iterator();
        this.dataObjects = new ArrayList<Long>(categories.size());
        while (i.hasNext()) {
            CategoryData element = (CategoryData)i.next();
            this.dataObjects.add(new Long(element.getId()));
        }
        this.foundNodes = new ArrayList<TreeImageDisplay>();
    }

    public List getFoundNodes() {
        return this.foundNodes;
    }

    public void visit(TreeImageNode node) {
        ImageData o = (ImageData)node.getUserObject();
        if (o.getId() == this.image.getId()) {
            TreeImageDisplay display = node.getParentDisplay();
            Object p = display.getUserObject();
            if (p instanceof CategoryData) {
                long id = ((CategoryData)p).getId();
                if (this.dataObjects.contains(new Long(id))) {
                    this.foundNodes.add(node);
                }
            } else {
                this.foundNodes.add(node);
            }
        }
    }
}

