/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.treeviewer.clsf;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import org.openmicroscopy.shoola.agents.treeviewer.IconManager;
import org.openmicroscopy.shoola.agents.treeviewer.TreeViewerAgent;
import org.openmicroscopy.shoola.agents.treeviewer.clsf.ClassifierControl;
import org.openmicroscopy.shoola.agents.treeviewer.clsf.ClassifierModel;
import org.openmicroscopy.shoola.agents.util.ViewerSorter;
import org.openmicroscopy.shoola.env.ui.UserNotifier;
import org.openmicroscopy.shoola.util.ui.TitlePanel;
import org.openmicroscopy.shoola.util.ui.UIUtilities;
import org.openmicroscopy.shoola.util.ui.clsf.TreeCheck;
import org.openmicroscopy.shoola.util.ui.clsf.TreeCheckNode;
import pojos.CategoryData;
import pojos.DataObject;

class ClassifierUI
extends JPanel {
    private static final Dimension H_SPACER_SIZE = new Dimension(5, 10);
    private static final String ADD_PANEL_TITLE = "Categorise";
    private static final String ADD_PANEL_TEXT = "Categorise the following image: ";
    private static final String PANEL_NOTE = "Expand list to select the categories to add the image to. Double-click on the name to browse the CategoryGroup or the Category.";
    private static final String ADD_PANEL_NOTE = "Expand list to select the categories to add the image to. Double-click on the name to browse the CategoryGroup or the Category.";
    private static final String ADD_UNCLASSIFIED_TEXT = "The image cannot be categorised. Please first create a category.";
    private static final String REMOVE_PANEL_TITLE = "Remove From Category";
    private static final String REMOVE_PANEL_TEXT = "Decategorises the following image: ";
    private static final String REMOVE_PANEL_NOTE = "The image is currently classified under the following categories. Expand list to select the categories to add the image to. Double-click on the name to browse the CategoryGroup or the Category.";
    private static final String REMOVE_UNCLASSIFIED_TEXT = "The selected image hasn't been categorised.";
    private ClassifierModel model;
    private ClassifierControl controller;
    private JButton finishButton;
    private JButton cancelButton;
    private TitlePanel titlePanel;
    private ViewerSorter sorter;
    private TreeCheck tree;
    private JPanel centerPanel;

    private void finish() {
        Set nodes = this.tree.getSelectedNodes();
        if (nodes == null || nodes.size() == 0) {
            UserNotifier un = TreeViewerAgent.getRegistry().getUserNotifier();
            un.notifyInfo("Categorisation", "No category selected.");
            return;
        }
        HashSet<CategoryData> paths = new HashSet<CategoryData>(nodes.size());
        Iterator i = nodes.iterator();
        while (i.hasNext()) {
            Object object = ((TreeCheckNode)i.next()).getUserObject();
            if (!(object instanceof CategoryData)) continue;
            paths.add((CategoryData)object);
        }
        this.controller.classifyImages(paths);
    }

    private void initComponents() {
        this.sorter = new ViewerSorter();
        IconManager im = IconManager.getInstance();
        this.titlePanel = new TitlePanel(this.getPanelTitle(), this.getPanelText(), this.getPanelNote(), im.getIcon(IconManager.CATEGORY_BIG));
        this.tree = new TreeCheck("", im.getIcon(IconManager.ROOT));
        this.tree.setRootVisible(false);
        this.tree.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                ClassifierUI.this.onClick(e);
            }

            public void mouseReleased(MouseEvent e) {
                ClassifierUI.this.onClick(e);
            }
        });
        this.finishButton = new JButton("Save");
        this.finishButton.setEnabled(false);
        this.finishButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ClassifierUI.this.finish();
            }
        });
        this.cancelButton = new JButton("Close");
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ClassifierUI.this.controller.closeClassifier(true);
            }
        });
        this.tree.addPropertyChangeListener("nodeSelected", this.controller);
    }

    private void onClick(MouseEvent me) {
        Point p = me.getPoint();
        int row = this.tree.getRowForLocation(p.x, p.y);
        if (row != -1) {
            this.tree.setSelectionRow(row);
            if (me.getClickCount() != 2) {
                return;
            }
            Object node = this.tree.getLastSelectedPathComponent();
            if (!(node instanceof TreeCheckNode)) {
                return;
            }
            Object object = ((TreeCheckNode)node).getUserObject();
            if (object instanceof DataObject) {
                this.model.browse((DataObject)object);
            }
        }
    }

    private JPanel buildToolBar() {
        JPanel bar = new JPanel();
        bar.setBorder(null);
        bar.add(this.finishButton);
        bar.add(Box.createRigidArea(H_SPACER_SIZE));
        bar.add(this.cancelButton);
        return bar;
    }

    private void buildGUI() {
        this.setLayout(new BorderLayout(0, 0));
        this.setOpaque(true);
        this.add((Component)this.titlePanel, "North");
        this.centerPanel = new JPanel();
        this.centerPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.add((Component)this.centerPanel, "Center");
        JPanel p = UIUtilities.buildComponentPanelRight(this.buildToolBar());
        p.setBorder(BorderFactory.createEtchedBorder());
        this.add((Component)p, "South");
    }

    private void buildTreeNode(TreeCheckNode parent, List nodes) {
        DefaultTreeModel tm = (DefaultTreeModel)this.tree.getModel();
        for (TreeCheckNode display : nodes) {
            tm.insertNodeInto(display, parent, parent.getChildCount());
            this.tree.expandPath(new TreePath(display.getPath()));
            Set children = display.getChildrenDisplay();
            if (children.size() == 0) continue;
            this.buildTreeNode(display, this.sorter.sort(children));
        }
    }

    private JComponent getClassificationComponent() {
        Set paths = this.model.getPaths();
        if (paths.size() == 0) {
            this.finishButton.setEnabled(false);
            JPanel p = new JPanel();
            p.setBorder(BorderFactory.createEmptyBorder(5, 5, 10, 10));
            p.add((Component)UIUtilities.setTextFont(this.getUnclassifiedNote()), "Center");
            return p;
        }
        DefaultTreeModel dtm = (DefaultTreeModel)this.tree.getModel();
        TreeCheckNode root = (TreeCheckNode)dtm.getRoot();
        Iterator i = paths.iterator();
        while (i.hasNext()) {
            root.addChildDisplay((TreeCheckNode)i.next());
        }
        this.buildTreeNode(root, this.sorter.sort(paths));
        dtm.reload();
        return new JScrollPane(this.tree);
    }

    private String getPanelTitle() {
        switch (this.model.getMode()) {
            case 0: {
                return ADD_PANEL_TITLE;
            }
            case 1: {
                return REMOVE_PANEL_TITLE;
            }
        }
        return "";
    }

    private String getPanelText() {
        switch (this.model.getMode()) {
            case 0: {
                return "Categorise the following image:  " + this.model.getDataObject().getName();
            }
            case 1: {
                return "Decategorises the following image:  " + this.model.getDataObject().getName();
            }
        }
        return "";
    }

    private String getPanelNote() {
        switch (this.model.getMode()) {
            case 0: {
                return "Expand list to select the categories to add the image to. Double-click on the name to browse the CategoryGroup or the Category.";
            }
            case 1: {
                return REMOVE_PANEL_NOTE;
            }
        }
        return "";
    }

    private String getUnclassifiedNote() {
        switch (this.model.getMode()) {
            case 0: {
                return ADD_UNCLASSIFIED_TEXT;
            }
            case 1: {
                return REMOVE_UNCLASSIFIED_TEXT;
            }
        }
        return "";
    }

    ClassifierUI() {
    }

    void initialize(ClassifierControl controller, ClassifierModel model) {
        if (model == null) {
            throw new IllegalArgumentException("No model.");
        }
        if (controller == null) {
            throw new IllegalArgumentException("No control.");
        }
        this.model = model;
        this.controller = controller;
        this.initComponents();
        this.buildGUI();
    }

    void setThumbnail(BufferedImage thumbnail) {
        JLabel label = new JLabel(new ImageIcon(thumbnail));
        label.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    ClassifierUI.this.model.browse((DataObject)ClassifierUI.this.model.getDataObject());
                }
            }
        });
        this.titlePanel.setIconComponent(label);
    }

    void showClassifications() {
        this.remove(this.centerPanel);
        this.add((Component)this.getClassificationComponent(), "Center");
        this.validate();
        this.repaint();
    }

    void notify(boolean b, String text, boolean hide) {
        this.model.getParentModel().setStatus(b, text, hide);
    }

    void handleButton(boolean b) {
        this.finishButton.setEnabled(b);
    }
}

