/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.treeviewer.clsf;

import java.util.HashSet;
import java.util.Set;
import org.openmicroscopy.shoola.agents.treeviewer.ClassificationSaver;
import org.openmicroscopy.shoola.agents.treeviewer.ClassifierLoader;
import org.openmicroscopy.shoola.agents.treeviewer.ClassifierPathsLoader;
import org.openmicroscopy.shoola.agents.treeviewer.clsf.Classifier;
import org.openmicroscopy.shoola.agents.treeviewer.cmd.ViewCmd;
import org.openmicroscopy.shoola.agents.treeviewer.view.TreeViewer;
import pojos.DataObject;
import pojos.ImageData;

class ClassifierModel {
    private int mode;
    private ImageData[] images;
    private int state;
    private Set paths;
    private TreeViewer parentModel;
    private ClassifierLoader currentLoader;
    protected Classifier component;

    ClassifierModel(TreeViewer parentModel, int mode, ImageData[] images) {
        if (parentModel == null) {
            throw new IllegalArgumentException("No parent model.");
        }
        if (images == null) {
            throw new IllegalArgumentException("No image.");
        }
        if (images.length == 0) {
            throw new IllegalArgumentException("No image.");
        }
        if (mode != 0 && mode != 1) {
            throw new IllegalArgumentException("Classification mode not supported.");
        }
        this.parentModel = parentModel;
        this.images = images;
        this.mode = mode;
        this.state = 1;
    }

    void initialize(Classifier component) {
        this.component = component;
    }

    TreeViewer getParentModel() {
        return this.parentModel;
    }

    int getState() {
        return this.state;
    }

    Set getPaths() {
        return this.paths;
    }

    int getMode() {
        return this.mode;
    }

    void setPaths(Set paths) {
        this.paths = paths;
    }

    ImageData getDataObject() {
        return this.images[0];
    }

    ImageData[] getDataObjects() {
        return this.images;
    }

    void fireClassificationLoading() {
        this.state = 2;
        HashSet<Long> ids = new HashSet<Long>(this.images.length);
        for (int i = 0; i < this.images.length; ++i) {
            ids.add(new Long(this.images[i].getId()));
        }
        this.currentLoader = new ClassifierPathsLoader(this.component, ids, this.mode, this.parentModel.getRootID());
        this.currentLoader.load();
    }

    void fireClassificationSaving(Set categories) {
        this.state = 5;
        this.currentLoader = new ClassificationSaver(this.component, 0, this.images, categories);
        this.currentLoader.load();
    }

    void fireDeclassificationSaving(Set categories) {
        this.state = 5;
        this.currentLoader = new ClassificationSaver(this.component, 1, this.images, categories);
        this.currentLoader.load();
    }

    void browse(DataObject object) {
        if (object != null) {
            ViewCmd cmd = new ViewCmd(this.parentModel, object);
            cmd.execute();
        }
    }

    void discard() {
        this.cancel();
        this.state = 4;
    }

    void cancel() {
        if (this.currentLoader != null) {
            this.currentLoader.cancel();
            this.currentLoader = null;
        }
        this.state = 3;
    }

    void saveClassification(ImageData[] images, Set categories, int mode) {
        this.state = 3;
        this.parentModel.onImageClassified(images, categories, mode);
    }

    long getUserID() {
        return this.parentModel.getUserDetails().getId();
    }
}

