/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.treeviewer.clsf;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.openmicroscopy.shoola.agents.treeviewer.clsf.Classifier;
import org.openmicroscopy.shoola.agents.treeviewer.clsf.ClassifierComponent;
import org.openmicroscopy.shoola.agents.treeviewer.clsf.ClassifierModel;
import org.openmicroscopy.shoola.agents.treeviewer.view.TreeViewer;
import pojos.ImageData;

public class ClassifierFactory
implements PropertyChangeListener {
    private static final ClassifierFactory singleton = new ClassifierFactory();
    private Classifier classifier = null;

    public static Classifier getClassifier(TreeViewer model, int m, ImageData[] images) {
        return singleton.createClassifier(model, m, images);
    }

    private ClassifierFactory() {
    }

    private Classifier createClassifier(TreeViewer model, int mode, ImageData[] images) {
        if (this.classifier != null) {
            if (mode == this.classifier.getMode()) {
                return this.classifier;
            }
            this.classifier.discard();
            this.classifier = null;
        }
        model.addPropertyChangeListener(this);
        ClassifierModel m = new ClassifierModel(model, mode, images);
        ClassifierComponent component = new ClassifierComponent(m);
        m.initialize(component);
        component.initialize();
        this.classifier = component;
        return this.classifier;
    }

    public void propertyChange(PropertyChangeEvent pce) {
        String name = pce.getPropertyName();
        if (name.equals("removeEditor") && this.classifier != null) {
            this.classifier.discard();
            this.classifier = null;
        }
    }
}

