/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.treeviewer.clsf;

import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Set;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.openmicroscopy.shoola.agents.treeviewer.clsf.Classifier;
import org.openmicroscopy.shoola.agents.treeviewer.clsf.ClassifierUI;

class ClassifierControl
implements ChangeListener,
PropertyChangeListener {
    private static final String LOADING = "Retrieve the classifications";
    private static final String SAVING = "Save classification";
    private Classifier model;
    private ClassifierUI view;

    ClassifierControl(Classifier model) {
        if (model == null) {
            throw new IllegalArgumentException("No model.");
        }
        this.model = model;
    }

    void initialize(ClassifierUI view) {
        if (view == null) {
            throw new IllegalArgumentException("No view.");
        }
        this.view = view;
    }

    void closeClassifier(boolean b) {
        if (b) {
            this.model.close();
        }
    }

    void classifyImages(Set paths) {
        this.model.classifyImages(paths);
    }

    public void stateChanged(ChangeEvent e) {
        switch (this.model.getState()) {
            case 5: {
                this.view.notify(true, SAVING, false);
                break;
            }
            case 2: {
                this.view.notify(true, LOADING, false);
                break;
            }
            case 3: {
                this.view.notify(false, "", true);
            }
        }
    }

    public void propertyChange(PropertyChangeEvent pce) {
        String name = pce.getPropertyName();
        if ("nodeSelected".equals(name)) {
            int i = (Integer)pce.getNewValue();
            this.view.handleButton(i > 0);
        } else {
            this.model.setThumbnail((BufferedImage)pce.getNewValue());
        }
    }
}

