/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.treeviewer.clsf;

import java.awt.image.BufferedImage;
import java.util.Set;
import javax.swing.JComponent;
import org.openmicroscopy.shoola.agents.treeviewer.TreeViewerAgent;
import org.openmicroscopy.shoola.agents.treeviewer.TreeViewerTranslator;
import org.openmicroscopy.shoola.agents.treeviewer.clsf.Classifier;
import org.openmicroscopy.shoola.agents.treeviewer.clsf.ClassifierControl;
import org.openmicroscopy.shoola.agents.treeviewer.clsf.ClassifierModel;
import org.openmicroscopy.shoola.agents.treeviewer.clsf.ClassifierUI;
import org.openmicroscopy.shoola.env.ui.UserNotifier;
import org.openmicroscopy.shoola.util.ui.component.AbstractComponent;
import pojos.ImageData;

class ClassifierComponent
extends AbstractComponent
implements Classifier {
    private static final String TITLE = "Classification";
    private ClassifierModel model;
    private ClassifierControl controller;
    private ClassifierUI view;

    ClassifierComponent(ClassifierModel model) {
        if (model == null) {
            throw new NullPointerException("No model.");
        }
        this.model = model;
        this.controller = new ClassifierControl(this);
        this.view = new ClassifierUI();
    }

    void initialize() {
        this.controller.initialize(this.view);
        this.view.initialize(this.controller, this.model);
    }

    public int getState() {
        return this.model.getState();
    }

    public void activate() {
        switch (this.model.getState()) {
            case 1: {
                this.model.fireClassificationLoading();
                this.fireStateChange();
                break;
            }
            case 4: {
                throw new IllegalStateException("This method can't be invoked in the DISCARDED state.");
            }
        }
    }

    public void discard() {
        if (this.model.getState() != 4) {
            this.model.discard();
            this.fireStateChange();
        }
    }

    public JComponent getUI() {
        if (this.model.getState() == 4) {
            throw new IllegalStateException("This method cannot be invoked in the DISCARDED state.");
        }
        return this.view;
    }

    public void setThumbnail(BufferedImage thumbnail) {
        if (this.model.getState() != 4) {
            if (thumbnail == null) {
                throw new IllegalArgumentException("No thumbnail.");
            }
            this.view.setThumbnail(thumbnail);
        }
    }

    public void setClassifications(Set paths) {
        if (this.model.getState() != 2) {
            throw new IllegalStateException("This method should only be invoked in the LOADING_CLASSIFICATION state.");
        }
        if (paths == null || paths.size() == 0) {
            UserNotifier un = TreeViewerAgent.getRegistry().getUserNotifier();
            un.notifyInfo(TITLE, "No classifications paths");
            return;
        }
        long userID = this.model.getUserID();
        Set nodes = TreeViewerTranslator.transformDataObjectsCheckNode(paths, userID, -1L);
        this.model.setPaths(nodes);
        this.view.showClassifications();
        this.fireStateChange();
        if (this.model.getDataObjects().length == 1) {
            this.firePropertyChange("thumbnailLoading", null, this.model.getDataObject());
        }
        this.model.getParentModel().setStatus(false, "", true);
    }

    public void saveClassification(ImageData[] images, Set categories, int mode) {
        if (this.model.getState() != 5) {
            throw new IllegalStateException("This method should only be invoked in the SAVE_CLASSIFICATION state.");
        }
        if (categories == null) {
            throw new IllegalArgumentException("Categories shouln't be null.");
        }
        if (images == null) {
            throw new IllegalArgumentException("No image.");
        }
        if (images.length == 0) {
            throw new IllegalArgumentException("No image.");
        }
        if (mode != 0 && mode != 1) {
            throw new IllegalArgumentException("Classification mode not supported.");
        }
        this.model.saveClassification(images, categories, mode);
        this.fireStateChange();
        this.firePropertyChange("closeClassifier", Boolean.class, Boolean.TRUE);
    }

    public int getMode() {
        if (this.model.getState() == 4) {
            throw new IllegalStateException("This method cannot be invoked in the DISCARDED state.");
        }
        return this.model.getMode();
    }

    public void cancel() {
        if (this.model.getState() == 4) {
            throw new IllegalStateException("This method cannot be invoked in the DISCARDED state.");
        }
        this.model.cancel();
    }

    public void close() {
        if (this.model.getState() == 4) {
            throw new IllegalStateException("This method cannot be invoked in the DISCARDED state.");
        }
        this.firePropertyChange("closeClassifier", Boolean.FALSE, Boolean.TRUE);
    }

    public void classifyImages(Set paths) {
        if (this.model.getState() == 4) {
            throw new IllegalStateException("This method cannot be invoked in the DISCARDED state.");
        }
        if (paths == null || paths.size() == 0) {
            UserNotifier un = TreeViewerAgent.getRegistry().getUserNotifier();
            un.notifyInfo(TITLE, "No images to classify.");
            return;
        }
        int m = this.model.getMode();
        if (m == 0) {
            this.model.fireClassificationSaving(paths);
        } else if (m == 1) {
            this.model.fireDeclassificationSaving(paths);
        }
        this.fireStateChange();
    }
}

