/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.treeviewer.browser;

import java.util.Iterator;
import org.openmicroscopy.shoola.agents.treeviewer.browser.TreeImageDisplay;
import org.openmicroscopy.shoola.agents.treeviewer.browser.TreeImageDisplayVisitor;
import org.openmicroscopy.shoola.agents.treeviewer.browser.TreeImageNode;

public class TreeImageSet
extends TreeImageDisplay {
    private Boolean containsImages;
    private Boolean childrenLoaded = null;

    protected void doAccept(TreeImageDisplayVisitor visitor) {
        visitor.visit(this);
    }

    public TreeImageSet(Object hierarchyObject) {
        super(hierarchyObject);
    }

    public void addChildDisplay(TreeImageDisplay child) {
        if (child == null) {
            throw new NullPointerException("No child.");
        }
        Class<?> childClass = child.getClass();
        if (this.containsImages == null) {
            this.containsImages = new Boolean(childClass.equals(TreeImageNode.class));
        } else if (this.containsImages.booleanValue()) {
            if (!childClass.equals(TreeImageNode.class)) {
                throw new IllegalArgumentException("This node can only contain TreeImageNodes.");
            }
        } else if (!childClass.equals(TreeImageSet.class)) {
            throw new IllegalArgumentException("This node can only contain TreeImageSets.");
        }
        super.addChildDisplay(child);
    }

    public boolean containsImages() {
        if (this.containsImages == null) {
            return false;
        }
        return this.containsImages;
    }

    public void setNumberItems(int value) {
        this.numberItems = value;
    }

    public int getNumberItems() {
        return this.numberItems;
    }

    public boolean isChildrenLoaded() {
        if (this.childrenLoaded == null) {
            return false;
        }
        return this.childrenLoaded;
    }

    public void setChildrenLoaded(Boolean childrenLoaded) {
        this.childrenLoaded = childrenLoaded;
    }

    public TreeImageDisplay copy() {
        TreeImageSet copy = new TreeImageSet(this.getUserObject());
        copy.setChildrenLoaded(new Boolean(this.isChildrenLoaded()));
        copy.setNumberItems(this.getNumberItems());
        copy.setHighLight(this.getHighLight());
        copy.setToolTip(this.getToolTip());
        copy.setExpanded(this.isExpanded());
        Iterator i = this.getChildrenDisplay().iterator();
        while (i.hasNext()) {
            copy.addChildDisplay(((TreeImageDisplay)i.next()).copy());
        }
        return copy;
    }
}

