/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.treeviewer.browser;

import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.openmicroscopy.shoola.agents.treeviewer.browser.BrowserModel;

class FilterMenu
extends JPopupMenu {
    static final String FILTER_SELECTED_PROPERTY = "filterSelected";
    private static final String NAME_DATASET = "Images in datasets";
    private static final String DESCRIPTION_DATASET = "Retrieve images contained in the selected datasets.";
    private static final String NAME_CATEGORY = "Images in categories";
    private static final String DESCRIPTION_CATEGORY = "Retrieve images contained in the selected categories.";
    private static final String NAME = "'s Images";
    private static final String DESCRIPTION = "Retrieve all ";
    private JRadioButtonMenuItem dataset;
    private JRadioButtonMenuItem category;
    private JRadioButtonMenuItem allImages;
    private BrowserModel model;

    private void createMenuItems() {
        int type = this.model.getFilterType();
        this.dataset = new JRadioButtonMenuItem(NAME_DATASET);
        this.dataset.setToolTipText(DESCRIPTION_DATASET);
        this.dataset.setSelected(type == 201);
        this.category = new JRadioButtonMenuItem(NAME_CATEGORY);
        this.category.setToolTipText(DESCRIPTION_CATEGORY);
        this.category.setSelected(type == 202);
        this.allImages = new JRadioButtonMenuItem(this.model.getExperimenterNames() + NAME);
        this.allImages.setToolTipText("Retrieve all 's Images");
        this.allImages.setSelected(type == 200);
        this.dataset.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent ce) {
                JRadioButtonMenuItem i = (JRadioButtonMenuItem)ce.getSource();
                if (i.isSelected()) {
                    FilterMenu.this.firePropertyChange(FilterMenu.FILTER_SELECTED_PROPERTY, new Integer(FilterMenu.this.model.getFilterType()), new Integer(201));
                }
            }
        });
        this.category.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent ce) {
                JRadioButtonMenuItem i = (JRadioButtonMenuItem)ce.getSource();
                if (i.isSelected()) {
                    FilterMenu.this.firePropertyChange(FilterMenu.FILTER_SELECTED_PROPERTY, new Integer(FilterMenu.this.model.getFilterType()), new Integer(202));
                }
            }
        });
        this.allImages.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent ce) {
                JRadioButtonMenuItem i = (JRadioButtonMenuItem)ce.getSource();
                if (i.isSelected()) {
                    FilterMenu.this.firePropertyChange(FilterMenu.FILTER_SELECTED_PROPERTY, new Integer(FilterMenu.this.model.getFilterType()), new Integer(200));
                }
            }
        });
        ButtonGroup group = new ButtonGroup();
        group.add(this.dataset);
        group.add(this.category);
        group.add(this.allImages);
    }

    private void buildGUI() {
        this.setBorder(BorderFactory.createBevelBorder(0));
        this.add(this.dataset);
        this.add(this.category);
        this.add(this.allImages);
    }

    FilterMenu(BrowserModel model) {
        if (model == null) {
            throw new IllegalArgumentException("No model.");
        }
        this.model = model;
        this.createMenuItems();
        this.buildGUI();
    }
}

