/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.treeviewer.browser;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import org.openmicroscopy.shoola.agents.treeviewer.browser.TreeImageSet;
import pojos.CategoryData;
import pojos.DatasetData;

public class ContainersManager {
    private int totalIDs;
    private Set processedIDs;
    private Map providers;
    private JTree tree;

    public ContainersManager(JTree tree, Set containerNodes) {
        if (containerNodes == null) {
            throw new IllegalArgumentException("No container nodes.");
        }
        if (tree == null) {
            throw new IllegalArgumentException("No tree.");
        }
        this.tree = tree;
        this.totalIDs = 0;
        this.processedIDs = new HashSet();
        this.providers = new HashMap();
        Iterator i = containerNodes.iterator();
        Long id = null;
        while (i.hasNext()) {
            TreeImageSet node = (TreeImageSet)i.next();
            Object userObject = node.getUserObject();
            if (userObject instanceof DatasetData) {
                id = new Long(((DatasetData)userObject).getId());
            } else if (userObject instanceof CategoryData) {
                id = new Long(((CategoryData)userObject).getId());
            }
            if (id == null) continue;
            HashSet<TreeImageSet> p = (HashSet<TreeImageSet>)this.providers.get(id);
            if (p == null) {
                ++this.totalIDs;
                p = new HashSet<TreeImageSet>();
                this.providers.put(id, p);
            }
            p.add(node);
        }
    }

    public void setNumberItems(long containerID, int value) {
        if (value < 0) {
            throw new IllegalArgumentException("Value not valid.");
        }
        Long id = new Long(containerID);
        Set p = (Set)this.providers.get(id);
        if (p != null) {
            Iterator i = p.iterator();
            DefaultTreeModel dtm = (DefaultTreeModel)this.tree.getModel();
            while (i.hasNext()) {
                TreeImageSet node = (TreeImageSet)i.next();
                node.setNumberItems(value);
                if (value == 0 && dtm.getChildCount(node) == 1) {
                    dtm.removeNodeFromParent((DefaultMutableTreeNode)dtm.getChild(node, 0));
                }
                dtm.reload(node);
            }
            this.processedIDs.add(id);
        }
    }

    public boolean isDone() {
        return this.processedIDs.size() == this.totalIDs;
    }
}

