/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.treeviewer.browser;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.ToolTipManager;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import org.openmicroscopy.shoola.agents.treeviewer.actions.FilterMenuAction;
import org.openmicroscopy.shoola.agents.treeviewer.browser.BrowserControl;
import org.openmicroscopy.shoola.agents.treeviewer.browser.BrowserModel;
import org.openmicroscopy.shoola.agents.treeviewer.browser.FilterMenu;
import org.openmicroscopy.shoola.agents.treeviewer.browser.TreeImageDisplay;
import org.openmicroscopy.shoola.agents.treeviewer.browser.TreeImageSet;
import org.openmicroscopy.shoola.agents.treeviewer.cmd.DeleteCmd;
import org.openmicroscopy.shoola.agents.treeviewer.cmd.ViewCmd;
import org.openmicroscopy.shoola.agents.treeviewer.util.TreeCellRenderer;
import org.openmicroscopy.shoola.agents.util.ViewerSorter;
import pojos.DataObject;
import pojos.ExperimenterData;

class BrowserUI
extends JPanel {
    private static final String LOADING_MSG = "Loading...";
    private static final String EMPTY_MSG = "Empty";
    private JTree treeDisplay;
    private JTree goIntoTree;
    private JToolBar menuBar;
    private BrowserControl controller;
    private BrowserModel model;
    private ViewerSorter sorter = new ViewerSorter();
    private TreeExpansionListener listener;
    private TreeSelectionListener selectionListener;
    private JScrollPane scrollPane;
    private Set<TreeImageDisplay> nodesToReset = new HashSet<TreeImageDisplay>();
    private JToggleButton partialButton;

    private void buildGUI() {
        this.setLayout(new BorderLayout(0, 0));
        JPanel p = new JPanel();
        p.setLayout(new FlowLayout(2, 0, 0));
        p.setBorder(null);
        p.add(this.menuBar);
        p.setPreferredSize(this.menuBar.getPreferredSize());
        this.add((Component)p, "North");
        this.scrollPane = new JScrollPane(this.treeDisplay);
        this.add((Component)this.scrollPane, "Center");
    }

    private void createMenuBar() {
        this.menuBar = new JToolBar();
        this.menuBar.setBorder(null);
        this.menuBar.setRollover(true);
        this.menuBar.setFloatable(false);
        JButton button = new JButton(this.controller.getAction(BrowserControl.BACKWARD_NAV));
        button.setBorderPainted(false);
        button = new JButton(this.controller.getAction(BrowserControl.FORWARD_NAV));
        ButtonGroup group = new ButtonGroup();
        JToggleButton b = new JToggleButton();
        group.add(b);
        b.setBorderPainted(true);
        b.setSelected(true);
        b.setAction(this.controller.getAction(BrowserControl.SORT));
        this.menuBar.add(b);
        b = new JToggleButton(this.controller.getAction(BrowserControl.SORT_DATE));
        b.setBorderPainted(true);
        group.add(b);
        this.menuBar.add(b);
        this.partialButton = new JToggleButton(this.controller.getAction(BrowserControl.PARTIAL_NAME));
        this.partialButton.setBorderPainted(true);
        this.menuBar.add(this.partialButton);
        button = new JButton(this.controller.getAction(BrowserControl.FILTER_MENU));
        button.addMouseListener((FilterMenuAction)this.controller.getAction(BrowserControl.FILTER_MENU));
        button.setBorderPainted(false);
        if (this.model.getBrowserType() == 102) {
            this.menuBar.add(button);
        }
        this.menuBar.add(new JSeparator(1));
        button = new JButton(this.controller.getAction(BrowserControl.COLLAPSE));
        button.setBorderPainted(false);
        this.menuBar.add(button);
    }

    private void onNodeNavigation(TreeExpansionEvent tee, boolean expanded) {
        TreeImageDisplay node = (TreeImageDisplay)tee.getPath().getLastPathComponent();
        node.setExpanded(expanded);
        this.controller.onNodeNavigation(node, expanded);
    }

    private void onClick(MouseEvent me, boolean released) {
        Point p = me.getPoint();
        JTree tree = this.getSelectedTree();
        int row = tree.getRowForLocation(p.x, p.y);
        if (row != -1) {
            if (me.getClickCount() == 1) {
                this.model.setClickPoint(p);
                if (me.isPopupTrigger()) {
                    this.controller.showPopupMenu();
                }
            } else if (me.getClickCount() == 2 && released) {
                this.model.viewDataObject();
            }
        }
    }

    private void rollOver(MouseEvent e) {
        if (!this.model.getParentModel().isRollOver()) {
            return;
        }
        JTree tree = this.treeDisplay;
        TreePath path = this.treeDisplay.getClosestPathForLocation(e.getX(), e.getY());
        Rectangle bounds = tree.getPathBounds(path);
        if (!bounds.contains(e.getPoint())) {
            return;
        }
        TreeImageDisplay node = (TreeImageDisplay)path.getLastPathComponent();
        Object uo = node.getUserObject();
        if (!(uo instanceof DataObject)) {
            return;
        }
        this.model.getParentModel().showProperties((DataObject)uo, 101);
    }

    private void createTrees(ExperimenterData exp) {
        this.treeDisplay = new JTree();
        this.treeDisplay.setVisible(true);
        ToolTipManager.sharedInstance().registerComponent(this.treeDisplay);
        this.treeDisplay.setCellRenderer(new TreeCellRenderer());
        this.treeDisplay.setShowsRootHandles(true);
        this.treeDisplay.getSelectionModel().setSelectionMode(4);
        TreeImageSet root = new TreeImageSet("");
        if (exp != null) {
            root.setUserObject(exp);
        }
        DefaultTreeModel treeModel = (DefaultTreeModel)this.treeDisplay.getModel();
        treeModel.insertNodeInto(new DefaultMutableTreeNode(EMPTY_MSG), root, root.getChildCount());
        this.treeDisplay.setModel(new DefaultTreeModel(root));
        this.treeDisplay.collapsePath(new TreePath(root.getPath()));
        this.treeDisplay.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                BrowserUI.this.onClick(e, false);
            }

            public void mouseReleased(MouseEvent e) {
                BrowserUI.this.onClick(e, true);
            }
        });
        this.treeDisplay.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseMoved(MouseEvent e) {
                BrowserUI.this.rollOver(e);
            }
        });
        this.treeDisplay.addTreeExpansionListener(this.listener);
        this.selectionListener = new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent e) {
                BrowserUI.this.controller.onClick();
            }
        };
        this.treeDisplay.addTreeSelectionListener(this.selectionListener);
        this.treeDisplay.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                block0 : switch (e.getKeyCode()) {
                    case 10: {
                        ViewCmd cmd = new ViewCmd(BrowserUI.this.model.getParentModel());
                        cmd.execute();
                        break;
                    }
                    case 127: {
                        switch (BrowserUI.this.model.getState()) {
                            case 2: 
                            case 3: 
                            case 4: {
                                break block0;
                            }
                        }
                        DeleteCmd c = new DeleteCmd(BrowserUI.this.model.getParentModel());
                        c.execute();
                    }
                }
            }
        });
        this.goIntoTree = new JTree();
        this.goIntoTree.setVisible(true);
        ToolTipManager.sharedInstance().registerComponent(this.goIntoTree);
        this.goIntoTree.setCellRenderer(new TreeCellRenderer());
        this.goIntoTree.setShowsRootHandles(true);
        this.goIntoTree.putClientProperty("JTree.lineStyle", "Angled");
        this.goIntoTree.getSelectionModel().setSelectionMode(4);
        TreeImageSet r = new TreeImageSet("");
        treeModel = (DefaultTreeModel)this.goIntoTree.getModel();
        this.goIntoTree.setModel(new DefaultTreeModel(r));
        this.goIntoTree.expandPath(new TreePath(r.getPath()));
        this.goIntoTree.setRootVisible(false);
        this.goIntoTree.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                BrowserUI.this.onClick(e, false);
            }

            public void mouseReleased(MouseEvent e) {
                BrowserUI.this.onClick(e, true);
            }
        });
        this.goIntoTree.addTreeSelectionListener(new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent e) {
                BrowserUI.this.controller.onClick();
            }
        });
    }

    private void buildTreeNode(TreeImageDisplay parent, Collection nodes, DefaultTreeModel tm) {
        if (nodes.size() == 0) {
            tm.insertNodeInto(new DefaultMutableTreeNode(EMPTY_MSG), parent, parent.getChildCount());
            return;
        }
        Iterator i = nodes.iterator();
        parent.removeAllChildren();
        while (i.hasNext()) {
            TreeImageDisplay display = (TreeImageDisplay)i.next();
            tm.insertNodeInto(display, parent, parent.getChildCount());
            if (!(display instanceof TreeImageSet)) continue;
            Set children = display.getChildrenDisplay();
            if (children.size() != 0) {
                if (display.containsImages()) {
                    display.setExpanded(true);
                    this.setExpandedParent(display, false);
                    this.nodesToReset.add(display);
                    this.buildTreeNode(display, this.sorter.sort(children), tm);
                    this.expandNode(display);
                    tm.reload(display);
                    continue;
                }
                if (display.isExpanded()) {
                    this.setExpandedParent(display, false);
                    this.nodesToReset.add(display);
                }
                this.buildTreeNode(display, this.sorter.sort(children), tm);
                continue;
            }
            tm.insertNodeInto(new DefaultMutableTreeNode(EMPTY_MSG), display, display.getChildCount());
        }
        if (parent.isExpanded()) {
            this.expandNode(parent);
            tm.reload(parent);
        }
    }

    private void setExpandedParent(TreeImageDisplay n, boolean b) {
        TreeImageDisplay p = n.getParentDisplay();
        if (p != null) {
            p.setExpanded(b);
            this.setExpandedParent(p, b);
        }
    }

    private void buildEmptyNode(DefaultMutableTreeNode node) {
        DefaultTreeModel tm = (DefaultTreeModel)this.treeDisplay.getModel();
        tm.insertNodeInto(new DefaultMutableTreeNode(EMPTY_MSG), node, node.getChildCount());
    }

    private void expandNode(TreeImageDisplay node) {
        node.setExpanded(true);
        this.treeDisplay.removeTreeExpansionListener(this.listener);
        this.treeDisplay.expandPath(new TreePath(node.getPath()));
        this.treeDisplay.addTreeExpansionListener(this.listener);
    }

    private void expandGoIntoTreeNode(DefaultMutableTreeNode node) {
        this.goIntoTree.removeTreeExpansionListener(this.listener);
        this.goIntoTree.expandPath(new TreePath(node.getPath()));
        this.goIntoTree.addTreeExpansionListener(this.listener);
    }

    private void selectGoIntoTreeFoundNode(TreeImageDisplay node) {
        TreePath path = new TreePath(node.getPath());
        this.goIntoTree.setSelectionPath(path);
        TreeCellRenderer renderer = (TreeCellRenderer)this.goIntoTree.getCellRenderer();
        renderer.getTreeCellRendererComponent(this.goIntoTree, node, this.goIntoTree.isPathSelected(path), false, true, 0, false);
    }

    private void loadGoIntoTree() {
        DefaultTreeModel dtm = (DefaultTreeModel)this.goIntoTree.getModel();
        DefaultMutableTreeNode r = (DefaultMutableTreeNode)dtm.getRoot();
        TreeImageDisplay d = this.model.getLastSelectedDisplay();
        r.removeAllChildren();
        TreeImageDisplay copy = d.copy();
        dtm.insertNodeInto(copy, r, r.getChildCount());
        this.buildTreeNode(copy, this.sorter.sort(copy.getChildrenDisplay()), dtm);
        dtm.reload(r);
        if (copy.isChildrenLoaded()) {
            this.expandGoIntoTreeNode(copy);
        }
        this.scrollPane.getViewport().removeAll();
        this.scrollPane.getViewport().add(this.goIntoTree);
        this.repaint();
    }

    BrowserUI() {
        this.listener = new TreeExpansionListener(){

            public void treeCollapsed(TreeExpansionEvent e) {
                BrowserUI.this.onNodeNavigation(e, false);
            }

            public void treeExpanded(TreeExpansionEvent e) {
                BrowserUI.this.onNodeNavigation(e, true);
            }
        };
    }

    void initialize(BrowserControl controller, BrowserModel model, ExperimenterData exp) {
        this.controller = controller;
        this.model = model;
        this.createMenuBar();
        this.createTrees(exp);
        this.buildGUI();
    }

    void loadAction(TreeImageDisplay parent) {
        DefaultTreeModel tm = (DefaultTreeModel)this.treeDisplay.getModel();
        parent.removeAllChildren();
        tm.insertNodeInto(new DefaultMutableTreeNode(LOADING_MSG), parent, parent.getChildCount());
        tm.reload(parent);
    }

    void setViews(Set nodes) {
        DefaultTreeModel dtm = (DefaultTreeModel)this.treeDisplay.getModel();
        TreeImageDisplay root = (TreeImageDisplay)dtm.getRoot();
        root.removeAllChildren();
        root.setChildrenLoaded(Boolean.TRUE);
        root.setExpanded(true);
        dtm.reload();
        if (nodes.size() != 0) {
            Iterator i = nodes.iterator();
            while (i.hasNext()) {
                root.addChildDisplay((TreeImageDisplay)i.next());
            }
            this.buildTreeNode(root, this.sorter.sort(nodes), (DefaultTreeModel)this.treeDisplay.getModel());
        } else {
            this.buildEmptyNode(root);
        }
        if (!this.model.isMainTree()) {
            this.loadGoIntoTree();
        }
        Iterator<TreeImageDisplay> j = this.nodesToReset.iterator();
        while (j.hasNext()) {
            this.setExpandedParent(j.next(), true);
        }
    }

    void setViews(Set nodes, TreeImageDisplay parent) {
        parent.removeAllChildren();
        parent.setChildrenLoaded(Boolean.TRUE);
        DefaultTreeModel dtm = (DefaultTreeModel)this.treeDisplay.getModel();
        if (nodes.size() != 0) {
            Iterator i = nodes.iterator();
            while (i.hasNext()) {
                parent.addChildDisplay((TreeImageDisplay)i.next());
            }
            this.buildTreeNode(parent, this.sorter.sort(nodes), dtm);
        } else {
            this.buildEmptyNode(parent);
        }
        dtm.reload(parent);
        if (!this.model.isMainTree()) {
            this.loadGoIntoTree();
        }
    }

    void setLeavesViews(Set nodes, TreeImageSet parent) {
        DefaultTreeModel dtm = (DefaultTreeModel)this.treeDisplay.getModel();
        parent.removeAllChildren();
        parent.setChildrenLoaded(Boolean.TRUE);
        if (nodes.size() != 0) {
            Iterator i = nodes.iterator();
            while (i.hasNext()) {
                parent.addChildDisplay((TreeImageDisplay)i.next());
            }
            this.buildTreeNode(parent, this.sorter.sort(nodes), dtm);
        } else {
            this.buildEmptyNode(parent);
        }
        dtm.reload(parent);
        if (!this.model.isMainTree()) {
            this.loadGoIntoTree();
        }
    }

    JTree getTreeDisplay() {
        return this.treeDisplay;
    }

    JTree getSelectedTree() {
        if (this.model.isMainTree()) {
            return this.treeDisplay;
        }
        return this.goIntoTree;
    }

    TreeImageDisplay getTreeRoot() {
        if (this.treeDisplay == null) {
            return null;
        }
        DefaultTreeModel dtm = (DefaultTreeModel)this.treeDisplay.getModel();
        if (dtm == null) {
            return null;
        }
        return (TreeImageDisplay)dtm.getRoot();
    }

    String getBrowserTitle() {
        switch (this.model.getBrowserType()) {
            case 100: {
                return "Projects";
            }
            case 101: {
                return "Categories";
            }
            case 102: {
                return "Images";
            }
        }
        return "";
    }

    void showFilterMenu(Component c, Point p) {
        FilterMenu filterMenu = new FilterMenu(this.model);
        filterMenu.addPropertyChangeListener("filterSelected", this.controller);
        filterMenu.show(c, p.x, p.y);
    }

    void selectFoundNode(TreeImageDisplay node) {
        TreePath path = new TreePath(node.getPath());
        this.treeDisplay.setSelectionPath(path);
        TreeCellRenderer renderer = (TreeCellRenderer)this.treeDisplay.getCellRenderer();
        renderer.getTreeCellRendererComponent(this.treeDisplay, node, this.treeDisplay.isPathSelected(path), false, true, 0, false);
        if (!this.model.isMainTree()) {
            this.loadGoIntoTree();
            this.selectGoIntoTreeFoundNode(node);
        }
    }

    void clearTree() {
        DefaultTreeModel dtm = (DefaultTreeModel)this.treeDisplay.getModel();
        TreeImageDisplay root = (TreeImageDisplay)dtm.getRoot();
        root.removeAllChildren();
        root.removeAllChildrenDisplay();
        this.buildEmptyNode(root);
        dtm.reload();
        this.collapsePath(root);
        if (!this.model.isMainTree()) {
            this.loadGoIntoTree();
        }
    }

    void collapsePath(DefaultMutableTreeNode node) {
        this.treeDisplay.removeTreeExpansionListener(this.listener);
        this.treeDisplay.collapsePath(new TreePath(node.getPath()));
        this.treeDisplay.addTreeExpansionListener(this.listener);
    }

    void cancel(DefaultMutableTreeNode node) {
        if (node == null) {
            return;
        }
        if (node.getChildCount() <= 1 && node.getUserObject() instanceof String) {
            node.removeAllChildren();
            this.buildEmptyNode(node);
        }
        ((DefaultTreeModel)this.treeDisplay.getModel()).reload(node);
        this.collapsePath(node);
    }

    void updateNodes(List nodes, DataObject object) {
        DefaultTreeModel dtm = (DefaultTreeModel)this.treeDisplay.getModel();
        for (TreeImageDisplay node : nodes) {
            node.setUserObject(object);
            dtm.nodeChanged(node);
        }
        if (!this.model.isMainTree()) {
            this.loadGoIntoTree();
        }
    }

    void removeNodes(List nodes, TreeImageDisplay parentDisplay) {
        if (parentDisplay == null) {
            parentDisplay = this.getTreeRoot();
        }
        Iterator i = nodes.iterator();
        DefaultTreeModel dtm = (DefaultTreeModel)this.treeDisplay.getModel();
        while (i.hasNext()) {
            TreeImageDisplay node = (TreeImageDisplay)i.next();
            TreeImageDisplay parent = node.getParentDisplay();
            if (!parent.isChildrenLoaded()) continue;
            parent.removeChildDisplay(node);
            parent.remove(node);
            dtm.reload(parent);
            if (!parent.equals(parentDisplay)) continue;
            this.treeDisplay.setSelectionPath(new TreePath(parent.getPath()));
        }
        if (!this.model.isMainTree()) {
            this.loadGoIntoTree();
        }
    }

    void createNodes(List nodes, TreeImageDisplay newNode, TreeImageDisplay parentDisplay) {
        if (parentDisplay == null) {
            parentDisplay = this.getTreeRoot();
        }
        Iterator i = nodes.iterator();
        DefaultTreeModel dtm = (DefaultTreeModel)this.treeDisplay.getModel();
        boolean toLoad = false;
        while (i.hasNext()) {
            TreeImageDisplay parent = (TreeImageDisplay)i.next();
            if (parent.isChildrenLoaded()) {
                parent.addChildDisplay(newNode);
                List list = this.sorter.sort(parent.getChildrenDisplay());
                parent.removeAllChildren();
                Iterator j = list.iterator();
                while (j.hasNext()) {
                    dtm.insertNodeInto((TreeImageDisplay)j.next(), parent, parent.getChildCount());
                }
                dtm.reload(parent);
                this.expandNode(parent);
                if (!parent.equals(parentDisplay)) continue;
                this.treeDisplay.setSelectionPath(new TreePath(newNode.getPath()));
                continue;
            }
            if (!parent.equals(parentDisplay)) continue;
            toLoad = true;
        }
        if (toLoad) {
            if (parentDisplay.getParentDisplay() == null) {
                this.controller.loadData();
            } else {
                this.controller.loadLeaves();
            }
        }
        if (!this.model.isMainTree()) {
            this.loadGoIntoTree();
        }
    }

    void setSortedNodes(List nodes, TreeImageDisplay parentNode) {
        DefaultTreeModel dtm = (DefaultTreeModel)this.treeDisplay.getModel();
        parentNode.removeAllChildren();
        Iterator i = nodes.iterator();
        boolean b = parentNode.equals(dtm.getRoot());
        while (i.hasNext()) {
            TreeImageDisplay child = (TreeImageDisplay)i.next();
            if (b) {
                parentNode.addChildDisplay(child);
            }
            dtm.insertNodeInto(child, parentNode, parentNode.getChildCount());
        }
        dtm.reload(parentNode);
        this.expandNode(parentNode);
        if (!this.model.isMainTree()) {
            i = nodes.iterator();
            ArrayList<TreeImageDisplay> copies = new ArrayList<TreeImageDisplay>(nodes.size());
            while (i.hasNext()) {
                copies.add(((TreeImageDisplay)i.next()).copy());
            }
            dtm = (DefaultTreeModel)this.goIntoTree.getModel();
            DefaultMutableTreeNode r = (DefaultMutableTreeNode)dtm.getRoot();
            TreeImageDisplay d = this.model.getLastSelectedDisplay();
            r.removeAllChildren();
            TreeImageDisplay copy = d.copy();
            dtm.insertNodeInto(copy, r, r.getChildCount());
            this.buildTreeNode(copy, copies, dtm);
            dtm.reload(r);
            if (copy.isChildrenLoaded()) {
                this.expandGoIntoTreeNode(copy);
            }
            this.scrollPane.getViewport().removeAll();
            this.scrollPane.getViewport().add(this.goIntoTree);
            this.repaint();
        }
    }

    void sortNodes(int type) {
        this.sorter.setByDate(type == 300);
        DefaultTreeModel dtm = (DefaultTreeModel)this.treeDisplay.getModel();
        TreeImageDisplay root = (TreeImageDisplay)dtm.getRoot();
        Set children = root.getChildrenDisplay();
        root.removeAllChildren();
        dtm.reload(root);
        if (children.size() != 0) {
            this.buildTreeNode(root, this.sorter.sort(children), dtm);
        } else {
            this.buildEmptyNode(root);
        }
        if (!this.model.isMainTree()) {
            this.loadGoIntoTree();
        }
        Iterator<TreeImageDisplay> j = this.nodesToReset.iterator();
        while (j.hasNext()) {
            this.setExpandedParent(j.next(), true);
        }
    }

    void loadRoot() {
        this.treeDisplay.expandPath(new TreePath(this.getTreeRoot().getPath()));
    }

    void navigate() {
        if (this.model.isMainTree()) {
            this.scrollPane.getViewport().removeAll();
            this.scrollPane.getViewport().add(this.treeDisplay);
            this.repaint();
        } else {
            this.loadGoIntoTree();
        }
    }

    void onStateChanged(boolean b) {
        this.model.getParentModel().onComponentStateChange(b);
    }

    void onComponentStateChange(boolean b) {
        this.treeDisplay.setEnabled(b);
        this.goIntoTree.setEnabled(b);
    }

    void setNullSelectedNode() {
        if (this.getTreeRoot() != null) {
            this.treeDisplay.setSelectionRow(-1);
            this.goIntoTree.setSelectionRow(-1);
        }
    }

    boolean isPartialName() {
        return !this.partialButton.isSelected();
    }

    void removeTreePaths(List paths) {
        this.treeDisplay.removeTreeSelectionListener(this.selectionListener);
        Iterator j = paths.iterator();
        while (j.hasNext()) {
            this.treeDisplay.removeSelectionPath((TreePath)j.next());
        }
        this.treeDisplay.addTreeSelectionListener(this.selectionListener);
    }

    void setRootNode(ExperimenterData experimenter) {
        if (experimenter == null) {
            this.getTreeRoot().setUserObject("");
        } else {
            this.getTreeRoot().setUserObject(experimenter);
        }
    }
}

