/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.treeviewer.browser;

import java.awt.Point;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JTree;
import org.openmicroscopy.shoola.agents.treeviewer.ContainerCounterLoader;
import org.openmicroscopy.shoola.agents.treeviewer.ContainerLoader;
import org.openmicroscopy.shoola.agents.treeviewer.DataBrowserLoader;
import org.openmicroscopy.shoola.agents.treeviewer.HierarchyLoader;
import org.openmicroscopy.shoola.agents.treeviewer.ImagesInContainerLoader;
import org.openmicroscopy.shoola.agents.treeviewer.ImagesLoader;
import org.openmicroscopy.shoola.agents.treeviewer.RefreshDataLoader;
import org.openmicroscopy.shoola.agents.treeviewer.browser.Browser;
import org.openmicroscopy.shoola.agents.treeviewer.browser.ContainersManager;
import org.openmicroscopy.shoola.agents.treeviewer.browser.TreeImageDisplay;
import org.openmicroscopy.shoola.agents.treeviewer.browser.TreeImageNode;
import org.openmicroscopy.shoola.agents.treeviewer.browser.TreeImageSet;
import org.openmicroscopy.shoola.agents.treeviewer.cmd.ViewCmd;
import org.openmicroscopy.shoola.agents.treeviewer.view.TreeViewer;
import pojos.CategoryData;
import pojos.CategoryGroupData;
import pojos.DataObject;
import pojos.DatasetData;
import pojos.ImageData;
import pojos.ProjectData;

class BrowserModel {
    private int browserType;
    private Set selectedNodes;
    private int state = 1;
    private Point clickPoint;
    private DataBrowserLoader currentLoader;
    private int filterType;
    private List foundNodes;
    private int foundNodeIndex;
    private ContainersManager containersManager;
    private boolean selected;
    private boolean mainTree;
    private boolean displayed;
    private TreeImageDisplay goIntoNode;
    private TreeViewer parent;
    private Set filteredNodes;
    protected Browser component;

    private void checkBrowserType(int type) {
        switch (type) {
            case 100: 
            case 101: 
            case 102: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Browser type not valid.");
            }
        }
    }

    protected BrowserModel(int browserType, TreeViewer parent) {
        this.parent = parent;
        this.checkBrowserType(browserType);
        this.browserType = browserType;
        this.clickPoint = null;
        this.filterType = 201;
        this.foundNodeIndex = -1;
        this.selectedNodes = new HashSet();
        this.mainTree = true;
        this.displayed = true;
    }

    void initialize(Browser component) {
        this.component = component;
    }

    int getState() {
        return this.state;
    }

    void setState(int state) {
        this.state = state;
    }

    long getRootID() {
        return this.parent.getRootID();
    }

    TreeImageDisplay getLastSelectedDisplay() {
        int n = this.selectedNodes.size();
        if (n == 0) {
            return null;
        }
        Iterator i = this.selectedNodes.iterator();
        int index = 0;
        while (i.hasNext()) {
            if (index == n - 1) {
                return (TreeImageDisplay)i.next();
            }
            ++index;
        }
        return null;
    }

    TreeImageDisplay[] getSelectedDisplays() {
        if (this.selectedNodes.size() == 0) {
            return new TreeImageDisplay[0];
        }
        return this.selectedNodes.toArray(new TreeImageDisplay[this.selectedNodes.size()]);
    }

    void setSelectedDisplays(TreeImageDisplay[] nodes) {
        this.selectedNodes.removeAll(this.selectedNodes);
        for (int i = 0; i < nodes.length; ++i) {
            TreeImageDisplay node = nodes[i];
            if (node == null || node.getUserObject() instanceof String) continue;
            this.selectedNodes.add(node);
        }
    }

    void setSelectedDisplay(TreeImageDisplay selectedDisplay) {
        this.selectedNodes.removeAll(this.selectedNodes);
        if (selectedDisplay == null) {
            return;
        }
        if (selectedDisplay.getUserObject() instanceof String) {
            return;
        }
        this.selectedNodes.add(selectedDisplay);
    }

    Point getClickPoint() {
        return this.clickPoint;
    }

    void setClickPoint(Point p) {
        this.clickPoint = p;
    }

    int getBrowserType() {
        return this.browserType;
    }

    void fireDataLoading() {
        if (this.browserType == 100) {
            this.currentLoader = new HierarchyLoader(this.component, 0);
        } else if (this.browserType == 101) {
            this.currentLoader = new HierarchyLoader(this.component, 1);
        } else {
            throw new IllegalArgumentException("BrowserType not valid.");
        }
        this.currentLoader.load();
        this.state = 2;
    }

    Set getFilteredNodes() {
        return this.filteredNodes;
    }

    void fireFilteredImageDataLoading(Set nodes) {
        this.filteredNodes = nodes;
        HashSet<Long> ids = new HashSet<Long>(nodes.size());
        Iterator i = nodes.iterator();
        Class<DatasetData> klass = null;
        if (this.filterType == 201) {
            while (i.hasNext()) {
                ids.add(new Long(((DatasetData)i.next()).getId()));
            }
            klass = DatasetData.class;
        } else if (this.filterType == 202) {
            while (i.hasNext()) {
                ids.add(new Long(((CategoryData)i.next()).getId()));
            }
            klass = CategoryData.class;
        }
        this.state = 2;
        this.currentLoader = new ImagesInContainerLoader(this.component, klass, ids);
        this.currentLoader.load();
    }

    void fireLeavesLoading() {
        TreeImageDisplay n = this.getLastSelectedDisplay();
        if (n instanceof TreeImageNode) {
            return;
        }
        Object ho = n.getUserObject();
        int type = -1;
        if (ho instanceof DatasetData) {
            type = 2;
        } else if (ho instanceof CategoryData) {
            type = 3;
        }
        if (type == -1) {
            return;
        }
        this.state = 3;
        this.currentLoader = new HierarchyLoader(this.component, type, (TreeImageSet)n);
        this.currentLoader.load();
    }

    void fireFilterDataLoading() {
        this.currentLoader = this.filterType == 201 ? new HierarchyLoader(this.component, 2, false, true) : (this.filterType == 202 ? new HierarchyLoader(this.component, 3, false, true) : new ImagesLoader(this.component, this.parent.getRootID()));
        this.currentLoader.load();
        this.state = 2;
    }

    void fireContainerLoading() {
        TreeImageDisplay selectedDisplay = this.getLastSelectedDisplay();
        if (selectedDisplay == null) {
            return;
        }
        Object ho = selectedDisplay.getUserObject();
        long id = -1L;
        Class<ProjectData> nodeType = null;
        if (ho instanceof ProjectData) {
            id = ((ProjectData)ho).getId();
            nodeType = ProjectData.class;
        } else if (ho instanceof CategoryGroupData) {
            id = ((CategoryGroupData)ho).getId();
            nodeType = CategoryGroupData.class;
        }
        if (nodeType != null) {
            this.currentLoader = new ContainerLoader(this.component, nodeType, id);
            this.currentLoader.load();
            this.state = 2;
        }
    }

    void fireContainerCountLoading() {
        Set containers = this.component.getContainersWithImages();
        if (containers.size() == 0) {
            this.state = 5;
            return;
        }
        this.state = 4;
        this.currentLoader = new ContainerCounterLoader(this.component, containers);
        this.currentLoader.load();
    }

    void discard() {
        this.cancel();
        this.state = 6;
    }

    void cancel() {
        if (this.currentLoader != null) {
            this.currentLoader.cancel();
            this.currentLoader = null;
        }
        this.state = 5;
    }

    void setFilterType(int type) {
        this.filteredNodes = null;
        this.filterType = type;
    }

    int getFilterType() {
        return this.filterType;
    }

    void refreshSelectedDisplay() {
        TreeImageDisplay selectedDisplay = this.getLastSelectedDisplay();
        if (selectedDisplay == null) {
            return;
        }
        Object ho = selectedDisplay.getUserObject();
        if (ho instanceof DatasetData || ho instanceof CategoryData) {
            this.fireLeavesLoading();
        } else {
            this.fireContainerLoading();
        }
    }

    void setContainerCountValue(JTree tree, long containerID, int value) {
        if (this.containersManager == null) {
            this.containersManager = new ContainersManager(tree, this.component.getContainersWithImagesNodes());
        }
        this.containersManager.setNumberItems(containerID, value);
        if (this.containersManager.isDone()) {
            this.state = 5;
            this.containersManager = null;
        }
    }

    void setSelected(boolean selected) {
        this.selected = selected;
    }

    boolean isSelected() {
        return this.selected;
    }

    void setFoundNodes(List nodes) {
        this.foundNodes = nodes;
    }

    void setFoundNodeIndex(int i) {
        this.foundNodeIndex = i;
    }

    int getFoundNodeIndex() {
        return this.foundNodeIndex;
    }

    List getFoundNodes() {
        return this.foundNodes;
    }

    long getUserID() {
        return this.parent.getUserDetails().getId();
    }

    long getUserGroupID() {
        return this.parent.getUserGroupID();
    }

    void viewDataObject() {
        TreeImageDisplay d = this.getLastSelectedDisplay();
        if (d == null) {
            return;
        }
        Object o = d.getUserObject();
        if (o instanceof ImageData) {
            ViewCmd cmd = new ViewCmd(this.parent, (DataObject)o);
            cmd.execute();
        }
    }

    boolean isMainTree() {
        return this.mainTree;
    }

    void setMainTree(boolean b, TreeImageDisplay goIntoNode) {
        this.goIntoNode = goIntoNode;
        this.mainTree = b;
    }

    TreeImageDisplay getGoIntoNode() {
        return this.goIntoNode;
    }

    TreeViewer getParentModel() {
        return this.parent;
    }

    boolean isDisplayed() {
        return this.displayed;
    }

    void setDisplayed(boolean displayed) {
        this.displayed = displayed;
    }

    void loadRefreshedData(List nodes, Map expandedTopNodes) {
        Class<ProjectData> klass = null;
        if (this.browserType == 100) {
            klass = ProjectData.class;
        } else if (this.browserType == 101) {
            klass = CategoryGroupData.class;
        }
        if (klass == null) {
            return;
        }
        this.state = 2;
        this.currentLoader = new RefreshDataLoader(this.component, klass, nodes, expandedTopNodes);
        this.currentLoader.load();
    }

    String getExperimenterNames() {
        return this.parent.getExperimenterNames();
    }
}

