/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.treeviewer.browser;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.swing.Action;
import javax.swing.JTree;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.tree.TreePath;
import org.openmicroscopy.shoola.agents.treeviewer.TreeViewerAgent;
import org.openmicroscopy.shoola.agents.treeviewer.actions.CloseAction;
import org.openmicroscopy.shoola.agents.treeviewer.actions.CollapseAction;
import org.openmicroscopy.shoola.agents.treeviewer.actions.FilterMenuAction;
import org.openmicroscopy.shoola.agents.treeviewer.actions.NavigationAction;
import org.openmicroscopy.shoola.agents.treeviewer.actions.ShowNameAction;
import org.openmicroscopy.shoola.agents.treeviewer.actions.SortAction;
import org.openmicroscopy.shoola.agents.treeviewer.actions.SortByDateAction;
import org.openmicroscopy.shoola.agents.treeviewer.browser.Browser;
import org.openmicroscopy.shoola.agents.treeviewer.browser.BrowserUI;
import org.openmicroscopy.shoola.agents.treeviewer.browser.TreeImageDisplay;
import org.openmicroscopy.shoola.env.ui.UserNotifier;
import pojos.CategoryData;
import pojos.DatasetData;
import pojos.ExperimenterData;

class BrowserControl
implements ChangeListener,
PropertyChangeListener {
    static final Integer COLLAPSE = new Integer(0);
    static final Integer CLOSE = new Integer(1);
    static final Integer SORT = new Integer(2);
    static final Integer SORT_DATE = new Integer(3);
    static final Integer FILTER_MENU = new Integer(4);
    static final Integer BACKWARD_NAV = new Integer(6);
    static final Integer FORWARD_NAV = new Integer(7);
    static final Integer PARTIAL_NAME = new Integer(8);
    private Browser model;
    private BrowserUI view;
    private Map<Integer, Action> actionsMap;

    private void createActions() {
        this.actionsMap.put(COLLAPSE, new CollapseAction(this.model));
        this.actionsMap.put(CLOSE, new CloseAction(this.model));
        this.actionsMap.put(SORT, new SortAction(this.model));
        this.actionsMap.put(SORT_DATE, new SortByDateAction(this.model));
        this.actionsMap.put(FILTER_MENU, new FilterMenuAction(this.model));
        this.actionsMap.put(FORWARD_NAV, new NavigationAction(this.model, true));
        this.actionsMap.put(BACKWARD_NAV, new NavigationAction(this.model, false));
        this.actionsMap.put(PARTIAL_NAME, new ShowNameAction(this.model));
    }

    private void filterNodes(Set nodes) {
        if (nodes == null || nodes.size() == 0) {
            return;
        }
        if (this.model.getBrowserType() != 102) {
            return;
        }
        TreeImageDisplay root = this.view.getTreeRoot();
        root.removeAllChildrenDisplay();
        this.view.loadAction(root);
        this.model.loadFilteredImageData(nodes);
    }

    BrowserControl(Browser model) {
        if (model == null) {
            throw new NullPointerException("No model.");
        }
        this.model = model;
        this.actionsMap = new HashMap<Integer, Action>();
        this.createActions();
    }

    void initialize(BrowserUI view) {
        if (view == null) {
            throw new NullPointerException("No view.");
        }
        this.view = view;
        this.model.addPropertyChangeListener(this);
        this.model.addChangeListener(this);
    }

    void onNodeNavigation(TreeImageDisplay display, boolean expanded) {
        if (!expanded) {
            this.model.cancel();
            return;
        }
        int state = this.model.getState();
        if (state == 2 || state == 3 || state == 4) {
            return;
        }
        Object ho = display.getUserObject();
        this.model.setSelectedDisplay(display);
        if (ho instanceof DatasetData || ho instanceof CategoryData) {
            if (!display.isChildrenLoaded()) {
                this.view.loadAction(display);
                this.model.loadLeaves();
            }
        } else {
            TreeImageDisplay root = this.view.getTreeRoot();
            if (root.equals(display) && root.getChildrenDisplay().size() == 0) {
                if (this.model.getBrowserType() == 102) {
                    this.model.loadFilteredImagesForHierarchy();
                } else {
                    this.view.loadAction(root);
                    this.model.loadData();
                }
            }
        }
    }

    void showPopupMenu() {
        this.model.showPopupMenu();
    }

    void onClick() {
        JTree tree = this.view.getSelectedTree();
        TreePath[] paths = tree.getSelectionPaths();
        if (paths == null) {
            return;
        }
        int n = paths.length;
        if (n == 0) {
            return;
        }
        Object pathComponent = paths[0].getLastPathComponent();
        if (!(pathComponent instanceof TreeImageDisplay)) {
            return;
        }
        TreeImageDisplay node = (TreeImageDisplay)pathComponent;
        ArrayList<TreePath> pathsToRemove = new ArrayList<TreePath>();
        ArrayList<TreeImageDisplay> l = new ArrayList<TreeImageDisplay>();
        l.add(node);
        Class<?> nodeClass = node.getUserObject().getClass();
        for (int i = 1; i < n; ++i) {
            Object o = paths[i].getLastPathComponent();
            if (!(o instanceof TreeImageDisplay)) continue;
            TreeImageDisplay no = (TreeImageDisplay)o;
            Object uo = no.getUserObject();
            if (uo instanceof ExperimenterData) {
                pathsToRemove.add(paths[i]);
                continue;
            }
            if (uo.getClass().equals(nodeClass)) {
                l.add(no);
                continue;
            }
            pathsToRemove.add(paths[i]);
        }
        if (l.size() != n) {
            UserNotifier un = TreeViewerAgent.getRegistry().getUserNotifier();
            un.notifyInfo("Node selection", "You can only select node of the same type e.g. images.");
            this.view.removeTreePaths(pathsToRemove);
        }
        if (l.size() == 0) {
            return;
        }
        TreeImageDisplay[] nodes = l.toArray(new TreeImageDisplay[l.size()]);
        this.model.setSelectedDisplays(nodes);
    }

    Action getAction(Integer id) {
        return this.actionsMap.get(id);
    }

    void loadLeaves() {
        this.model.loadLeaves();
    }

    void loadData() {
        this.model.loadData();
    }

    public void stateChanged(ChangeEvent e) {
        this.view.onStateChanged(this.model.getState() == 5);
    }

    public void propertyChange(PropertyChangeEvent pce) {
        String name = pce.getPropertyName();
        if (name.equals("filterNodes")) {
            Map map = (Map)pce.getNewValue();
            if (map.get(this.model) != null) {
                this.filterNodes((Set)map.get(this.model));
            }
        } else if (name.equals("filterSelected")) {
            this.model.setFilterType((Integer)pce.getNewValue());
        } else if (name.equals("close")) {
            this.view.onStateChanged(true);
            this.view.collapsePath(this.view.getTreeRoot());
        }
    }
}

