/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.treeviewer.browser;

import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JTree;
import javax.swing.tree.TreePath;
import org.openmicroscopy.shoola.agents.treeviewer.IconManager;
import org.openmicroscopy.shoola.agents.treeviewer.TreeViewerTranslator;
import org.openmicroscopy.shoola.agents.treeviewer.browser.Browser;
import org.openmicroscopy.shoola.agents.treeviewer.browser.BrowserControl;
import org.openmicroscopy.shoola.agents.treeviewer.browser.BrowserModel;
import org.openmicroscopy.shoola.agents.treeviewer.browser.BrowserUI;
import org.openmicroscopy.shoola.agents.treeviewer.browser.ContainerFinder;
import org.openmicroscopy.shoola.agents.treeviewer.browser.PartialNameVisitor;
import org.openmicroscopy.shoola.agents.treeviewer.browser.TreeImageDisplay;
import org.openmicroscopy.shoola.agents.treeviewer.browser.TreeImageDisplayVisitor;
import org.openmicroscopy.shoola.agents.treeviewer.browser.TreeImageSet;
import org.openmicroscopy.shoola.agents.treeviewer.cmd.ClassificationVisitor;
import org.openmicroscopy.shoola.agents.treeviewer.cmd.EditVisitor;
import org.openmicroscopy.shoola.agents.treeviewer.cmd.LeavesVisitor;
import org.openmicroscopy.shoola.agents.treeviewer.cmd.RefreshVisitor;
import org.openmicroscopy.shoola.agents.treeviewer.util.FilterWindow;
import org.openmicroscopy.shoola.util.ui.UIUtilities;
import org.openmicroscopy.shoola.util.ui.component.AbstractComponent;
import pojos.CategoryGroupData;
import pojos.DataObject;
import pojos.ExperimenterData;
import pojos.ImageData;
import pojos.ProjectData;

class BrowserComponent
extends AbstractComponent
implements Browser {
    private BrowserModel model;
    private BrowserUI view;
    private BrowserControl controller;
    private TreeImageDisplay toSelectAfterSave;

    private JFrame getViewParent(Container c) {
        if (c instanceof JFrame) {
            return (JFrame)c;
        }
        return this.getViewParent(c.getParent());
    }

    private void removeNodes(List nodes) {
        TreeImageDisplay parentDisplay = this.getLastSelectedDisplay() == null ? this.view.getTreeRoot() : this.getLastSelectedDisplay().getParentDisplay();
        if (parentDisplay == null) {
            parentDisplay = this.view.getTreeRoot();
        }
        this.setSelectedDisplay(parentDisplay);
        this.view.removeNodes(nodes, parentDisplay);
    }

    private void createNodes(List nodes, TreeImageDisplay display, TreeImageDisplay parentDisplay) {
        this.setSelectedDisplay(display);
        this.view.createNodes(nodes, display, parentDisplay);
    }

    private void handleNodeDisplay(TreeImageDisplay node) {
        this.view.selectFoundNode(node);
        Object ho = node.getUserObject();
        if (ho instanceof DataObject) {
            this.model.getParentModel().showProperties((DataObject)ho, 101);
        }
    }

    private void hasDataToSave(TreeImageDisplay node) {
        if (this.model.getParentModel().hasDataToSave()) {
            this.toSelectAfterSave = node;
            this.model.getParentModel().showPreSavingDialog();
            return;
        }
    }

    private void setSelectedNode() {
        if (this.toSelectAfterSave == null) {
            return;
        }
        this.setSelectedDisplay(this.toSelectAfterSave);
        this.toSelectAfterSave = null;
    }

    private void refreshTree(boolean visit) {
        switch (this.model.getState()) {
            case 2: 
            case 3: {
                this.model.cancel();
            }
            case 6: {
                return;
            }
        }
        TreeImageDisplay root = this.view.getTreeRoot();
        if (!root.isChildrenLoaded()) {
            return;
        }
        if (!this.model.isSelected()) {
            // empty if block
        }
        if (this.model.getBrowserType() == 102) {
            root.removeAllChildrenDisplay();
            this.model.setSelectedDisplay(null);
            Set nodes = this.model.getFilteredNodes();
            if (nodes != null) {
                this.loadFilteredImageData(nodes);
            } else {
                this.loadFilteredImagesForHierarchy();
            }
        } else if (visit) {
            RefreshVisitor visitor = new RefreshVisitor(this);
            this.accept(visitor, 1);
            root.removeAllChildrenDisplay();
            this.model.setSelectedDisplay(null);
            this.model.loadRefreshedData(visitor.getFoundNodes(), visitor.getExpandedTopNodes());
        } else {
            root.removeAllChildrenDisplay();
            this.model.setSelectedDisplay(null);
            this.model.loadRefreshedData(null, null);
        }
    }

    BrowserComponent(BrowserModel model) {
        if (model == null) {
            throw new NullPointerException("No model.");
        }
        this.model = model;
        this.controller = new BrowserControl(this);
        this.view = new BrowserUI();
    }

    void initialize(ExperimenterData exp) {
        this.model.initialize(this);
        this.controller.initialize(this.view);
        this.view.initialize(this.controller, this.model, exp);
    }

    BrowserModel getModel() {
        return this.model;
    }

    public int getState() {
        return this.model.getState();
    }

    public void activate() {
        int state = this.model.getState();
        switch (state) {
            case 1: {
                this.view.loadRoot();
                break;
            }
            case 6: {
                throw new IllegalStateException("This method can't be invoked in the DISCARDED state.");
            }
        }
    }

    public void discard() {
        if (this.model.getState() != 6) {
            this.model.discard();
            this.fireStateChange();
        }
    }

    public JComponent getUI() {
        if (this.model.getState() == 6) {
            throw new IllegalStateException("This method cannot be invoked in the DISCARDED state.");
        }
        return this.view;
    }

    public void setNodes(Set nodes) {
        if (this.model.getState() != 2) {
            throw new IllegalStateException("This method can only be invoked in the LOADING_DATA state.");
        }
        if (nodes == null) {
            throw new NullPointerException("No nodes.");
        }
        long userID = this.model.getUserID();
        long groupID = this.model.getUserGroupID();
        Set visNodes = TreeViewerTranslator.transformHierarchy(nodes, userID, groupID);
        this.view.setViews(visNodes);
        if (!this.view.isPartialName()) {
            PartialNameVisitor v = new PartialNameVisitor(this.view.isPartialName());
            this.accept(v, 0);
        }
        this.model.setState(5);
        this.model.getParentModel().setStatus(false, "", true);
        this.fireStateChange();
    }

    public int getBrowserType() {
        return this.model.getBrowserType();
    }

    public void cancel() {
        int state = this.model.getState();
        if (state == 2 || state == 3 || state == 4) {
            this.model.cancel();
            if (state != 4) {
                this.view.cancel(this.model.getLastSelectedDisplay());
            }
            this.fireStateChange();
        }
    }

    public void loadData() {
        int state = this.model.getState();
        if (state == 6 || state == 3) {
            throw new IllegalStateException("This method cannot be invoked in the DISCARDED orLOADING_LEAVES state.");
        }
        if (this.model.getBrowserType() == 102) {
            throw new IllegalArgumentException("Method should only be invoked by the Hiearchy and Category Explorer.");
        }
        this.model.fireDataLoading();
        this.model.getParentModel().setStatus(true, "Loading...", false);
        this.fireStateChange();
    }

    public void loadFilteredImagesForHierarchy() {
        int state = this.model.getState();
        if (state == 6 || state == 3) {
            throw new IllegalStateException("This method cannot be invoked in the DISCARDED orLOADING_LEAVES state.");
        }
        if (this.model.getBrowserType() != 102) {
            throw new IllegalArgumentException("Method should only be invoked by the Images Explorer.");
        }
        this.view.loadAction(this.view.getTreeRoot());
        this.model.fireFilterDataLoading();
        this.model.getParentModel().setStatus(true, "Loading...", false);
        this.fireStateChange();
    }

    public void loadLeaves() {
        int state = this.model.getState();
        if (state == 6 || state == 3) {
            throw new IllegalStateException("This method cannot be invoked in the DISCARDED or LOADING_LEAVES state.");
        }
        this.model.fireLeavesLoading();
        this.model.getParentModel().setStatus(true, "Loading...", false);
        this.fireStateChange();
    }

    public void setLeaves(Set leaves, TreeImageSet parent) {
        if (this.model.getState() != 3) {
            throw new IllegalStateException("This method can only be invoked in the LOADING_LEAVES state.");
        }
        if (leaves == null) {
            throw new NullPointerException("No leaves.");
        }
        long userID = this.model.getUserID();
        long groupID = this.model.getUserGroupID();
        Set visLeaves = TreeViewerTranslator.transformHierarchy(leaves, userID, groupID);
        this.view.setLeavesViews(visLeaves, parent);
        if (!this.view.isPartialName()) {
            PartialNameVisitor v = new PartialNameVisitor(this.view.isPartialName());
            this.accept(v, 0);
        }
        this.model.setState(5);
        this.model.getParentModel().setStatus(false, "", true);
        this.fireStateChange();
    }

    public void setSelectedDisplay(TreeImageDisplay display) {
        Object ho;
        switch (this.model.getState()) {
            case 6: {
                throw new IllegalStateException("This method cannot be invoked in the LOADING_DATA,  LOADING_LEAVES or DISCARDED state.");
            }
        }
        this.hasDataToSave(display);
        TreeImageDisplay oldDisplay = this.model.getLastSelectedDisplay();
        if (display != null && ((ho = display.getUserObject()) instanceof String || ho instanceof ExperimenterData)) {
            display = null;
        }
        this.model.setSelectedDisplay(display);
        if (display == null) {
            this.view.setNullSelectedNode();
        }
        this.firePropertyChange("selectedDisplay", oldDisplay, display);
    }

    public void showPopupMenu() {
        switch (this.model.getState()) {
            case 2: 
            case 3: 
            case 6: {
                return;
            }
        }
        this.firePropertyChange("popupMenu", null, this.view.getSelectedTree());
    }

    public Point getClickPoint() {
        return this.model.getClickPoint();
    }

    public TreeImageDisplay getLastSelectedDisplay() {
        return this.model.getLastSelectedDisplay();
    }

    public void close() {
        switch (this.model.getState()) {
            case 2: 
            case 3: 
            case 6: {
                throw new IllegalStateException("This method can only be invoked in the LOADING_DATA,  LOADING_LEAVES or DISCARDED state.");
            }
        }
        this.firePropertyChange("close", null, this);
    }

    public void collapse(TreeImageDisplay node) {
        if (node == null) {
            return;
        }
        this.view.collapsePath(node);
    }

    public void accept(TreeImageDisplayVisitor visitor) {
        this.accept(visitor, 2);
    }

    public void accept(TreeImageDisplayVisitor visitor, int algoType) {
        this.view.setCursor(Cursor.getPredefinedCursor(3));
        this.view.getTreeRoot().accept(visitor, algoType);
        this.view.setCursor(Cursor.getPredefinedCursor(0));
    }

    public String getTitle() {
        return this.view.getBrowserTitle();
    }

    public Icon getIcon() {
        IconManager im = IconManager.getInstance();
        switch (this.model.getBrowserType()) {
            case 100: {
                return im.getIcon(IconManager.HIERARCHY_EXPLORER);
            }
            case 101: {
                return im.getIcon(IconManager.CATEGORY_EXPLORER);
            }
            case 102: {
                return im.getIcon(IconManager.IMAGES_EXPLORER);
            }
        }
        return null;
    }

    public void sortTreeNodes(int sortType) {
        switch (this.model.getState()) {
            case 2: 
            case 3: 
            case 4: 
            case 6: {
                throw new IllegalStateException("This method cannot be invoked in the LOADING_DATA,  LOADING_LEAVES or DISCARDED state.");
            }
        }
        switch (sortType) {
            case 300: 
            case 301: {
                break;
            }
            default: {
                throw new IllegalArgumentException("SortType not supported.");
            }
        }
        this.view.setCursor(Cursor.getPredefinedCursor(3));
        this.view.sortNodes(sortType);
        this.view.setCursor(Cursor.getPredefinedCursor(0));
    }

    public void setFilterNodes(Set nodes, int type) {
        if (this.model.getState() != 2) {
            throw new IllegalStateException("This method can only be invoked in the LOADING_DATAstate.");
        }
        if (nodes == null) {
            throw new NullPointerException("No nodes.");
        }
        int index = -1;
        if (type == 201) {
            index = 0;
        } else if (type == 202) {
            index = 1;
        }
        if (index == -1) {
            throw new IllegalStateException("Index not valid.");
        }
        this.model.setState(5);
        this.model.getParentModel().setStatus(false, "", true);
        this.fireStateChange();
        JFrame frame = this.getViewParent(this.view.getParent());
        long userID = this.model.getRootID();
        long groupID = this.model.getUserGroupID();
        Set n = TreeViewerTranslator.transformDataObjectsCheckNode(nodes, userID, groupID);
        FilterWindow window = new FilterWindow(this, frame, index, n);
        window.addPropertyChangeListener("filterNodes", this.controller);
        window.addPropertyChangeListener("close", this.controller);
        UIUtilities.centerAndShow(window);
    }

    public void showFilterMenu(Component c, Point p) {
        this.view.showFilterMenu(c, p);
    }

    public void loadFilteredImageData(Set nodes) {
        int state = this.model.getState();
        if (state == 6 || state == 3) {
            throw new IllegalStateException("This method cannot be invoked in the DISCARDED orLOADING_LEAVES state.");
        }
        if (this.model.getBrowserType() != 102) {
            throw new IllegalArgumentException("BrowserType not valid.");
        }
        if (this.model.getFilterType() == 200) {
            throw new IllegalArgumentException("The method cannot be invoked for the NO_IMAGES_FILTER filter type.");
        }
        if (nodes == null || nodes.size() == 0) {
            throw new IllegalArgumentException("No nodes.");
        }
        this.model.fireFilteredImageDataLoading(nodes);
        this.model.getParentModel().setStatus(true, "Loading...", false);
        this.fireStateChange();
    }

    public void refreshTree() {
        this.refreshTree(true);
    }

    public void switchUser() {
        this.refreshTree(false);
    }

    public void setContainerNodes(Set nodes, TreeImageDisplay parent) {
        int state = this.model.getState();
        if (state != 2) {
            throw new IllegalStateException("This method can only be invoked in the LOADING_DATA state.");
        }
        if (nodes == null) {
            throw new NullPointerException("No nodes.");
        }
        TreeImageDisplay parentDisplay = this.model.getLastSelectedDisplay();
        long userID = this.model.getUserID();
        long groupID = this.model.getUserGroupID();
        if (parent == null) {
            this.view.setViews(TreeViewerTranslator.transformHierarchy(nodes, userID, groupID));
        } else {
            this.view.setViews(TreeViewerTranslator.transformContainers(nodes, userID, groupID), parentDisplay);
        }
        if (parentDisplay != null) {
            parentDisplay.setChildrenLoaded(Boolean.TRUE);
        }
        this.model.fireContainerCountLoading();
        this.model.getParentModel().setStatus(false, "", true);
        this.fireStateChange();
    }

    public long getRootID() {
        if (this.model.getState() == 6) {
            throw new IllegalStateException("This method can't only be invoked in the DISCARDED state.");
        }
        return this.model.getRootID();
    }

    public void setContainerCountValue(long containerID, int value) {
        int state = this.model.getState();
        switch (state) {
            case 4: {
                this.model.setContainerCountValue(this.view.getTreeDisplay(), containerID, value);
                if (this.model.getState() != 5) break;
                this.fireStateChange();
                break;
            }
            case 5: {
                this.model.setContainerCountValue(this.view.getTreeDisplay(), containerID, value);
                this.view.getTreeDisplay().repaint();
                break;
            }
            default: {
                throw new IllegalStateException("This method can only be invoked in the COUNTING_ITEMS or READY state.");
            }
        }
        this.model.getParentModel().setStatus(false, "", true);
    }

    public Set getContainersWithImagesNodes() {
        ContainerFinder finder = new ContainerFinder();
        this.accept(finder, 1);
        return finder.getContainerNodes();
    }

    public Set getContainersWithImages() {
        ContainerFinder finder = new ContainerFinder();
        this.accept(finder, 1);
        return finder.getContainers();
    }

    public void setFoundInBrowser(Set nodes) {
        if (nodes == null || nodes.size() == 0) {
            this.model.setFoundNodes(null);
            this.model.setFoundNodeIndex(-1);
            this.view.getTreeDisplay().repaint();
            return;
        }
        ArrayList list = new ArrayList(nodes.size());
        Iterator i = nodes.iterator();
        final JTree tree = this.view.getTreeDisplay();
        while (i.hasNext()) {
            list.add(i.next());
        }
        Comparator c = new Comparator(){

            public int compare(Object o1, Object o2) {
                TreeImageDisplay node1 = (TreeImageDisplay)o1;
                TreeImageDisplay node2 = (TreeImageDisplay)o2;
                int i1 = tree.getRowForPath(new TreePath(node1.getPath()));
                int i2 = tree.getRowForPath(new TreePath(node2.getPath()));
                return i1 - i2;
            }
        };
        Collections.sort(list, c);
        this.model.setFoundNodes(list);
        this.model.setFoundNodeIndex(0);
        this.handleNodeDisplay((TreeImageDisplay)list.get(0));
        tree.repaint();
    }

    public void findNext() {
        int n;
        List l = this.model.getFoundNodes();
        if (l == null || l.size() == 0) {
            return;
        }
        int index = this.model.getFoundNodeIndex();
        if (index < (n = l.size() - 1)) {
            ++index;
        } else if (index == n) {
            index = 0;
        }
        this.model.setFoundNodeIndex(index);
        this.handleNodeDisplay((TreeImageDisplay)l.get(index));
    }

    public void findPrevious() {
        List l = this.model.getFoundNodes();
        if (l == null || l.size() == 0) {
            return;
        }
        int index = this.model.getFoundNodeIndex();
        if (index > 0) {
            --index;
        } else if (index == 0) {
            index = l.size() - 1;
        }
        this.model.setFoundNodeIndex(index);
        this.handleNodeDisplay((TreeImageDisplay)l.get(index));
    }

    public void setSelected(boolean b) {
        switch (this.model.getState()) {
            case 6: {
                throw new IllegalStateException("This method can only be invoked in the NEW or READY state.");
            }
        }
        boolean old = this.model.isSelected();
        if (old == b) {
            return;
        }
        this.setSelectedDisplay(null);
        this.model.setSelected(b);
    }

    public void refreshEdition(DataObject object, int op) {
        switch (this.model.getState()) {
            case 1: 
            case 5: {
                break;
            }
            default: {
                new IllegalStateException("This method can only be invoked in the NEW or READY state.");
            }
        }
        Object o = object;
        List<TreeImageDisplay> nodes = null;
        TreeImageDisplay parentDisplay = null;
        if (op == 300) {
            TreeImageDisplay node = this.getLastSelectedDisplay();
            if (object instanceof ProjectData || object instanceof CategoryGroupData) {
                nodes = new ArrayList<TreeImageDisplay>(1);
                nodes.add(this.view.getTreeRoot());
                parentDisplay = this.view.getTreeRoot();
            } else {
                o = node.getUserObject();
            }
        }
        if (nodes == null) {
            EditVisitor visitor = new EditVisitor(this, o);
            this.accept(visitor, 2);
            nodes = visitor.getFoundNodes();
        }
        if (op == 301) {
            this.view.updateNodes(nodes, object);
        } else if (op == 302) {
            this.removeNodes(nodes);
        } else if (op == 300) {
            long userID = this.model.getUserID();
            long groupID = this.model.getUserGroupID();
            if (parentDisplay == null) {
                parentDisplay = this.getLastSelectedDisplay();
            }
            this.createNodes(nodes, TreeViewerTranslator.transformDataObject(object, userID, groupID), parentDisplay);
        }
        this.setSelectedNode();
    }

    public void refreshClassification(ImageData[] images, Set categories, int m) {
        switch (this.model.getState()) {
            case 1: 
            case 5: {
                break;
            }
            default: {
                new IllegalStateException("This method can only be invoked in the NEW or READY state.");
            }
        }
        if (categories == null) {
            throw new IllegalArgumentException("Categories shouln't be null.");
        }
        if (images == null) {
            throw new IllegalArgumentException("No image.");
        }
        if (images.length == 0) {
            throw new IllegalArgumentException("No image.");
        }
        if (m != 0 && m != 1) {
            throw new IllegalArgumentException("Classification mode not supported.");
        }
        int editorType = this.model.getBrowserType();
        if (editorType == 101) {
            this.refreshTree();
            return;
        }
        for (int i = 0; i < images.length; ++i) {
            ImageData img = images[i];
            ClassificationVisitor visitor = new ClassificationVisitor(this, img, categories);
            this.accept(visitor, 0);
            List nodes = visitor.getFoundNodes();
            this.view.updateNodes(nodes, (DataObject)img);
        }
    }

    public void setFilterType(int type) {
        switch (this.model.getState()) {
            case 2: 
            case 3: 
            case 6: {
                throw new IllegalStateException("This method cannot be invoked in the LOADING_DATA,  LOADING_LEAVES or DISCARDED state.");
            }
        }
        if (this.model.getBrowserType() != 102) {
            throw new IllegalArgumentException("This method can only be invoked by the Images Explorer.");
        }
        switch (type) {
            case 200: 
            case 201: 
            case 202: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Filter not supported.");
            }
        }
        this.model.setFilterType(type);
        this.refreshTree();
    }

    public Set getLeaves() {
        if (this.model.getBrowserType() != 102) {
            throw new IllegalArgumentException("This method sould only be invoked for the Images Explorer.");
        }
        LeavesVisitor visitor = new LeavesVisitor(this);
        this.accept(visitor);
        return visitor.getNodeIDs();
    }

    public TreeImageDisplay[] getSelectedDisplays() {
        return this.model.getSelectedDisplays();
    }

    public List getSelectedDataObjects() {
        TreeImageDisplay[] nodes = this.getSelectedDisplays();
        if (nodes == null || nodes.length == 0) {
            return null;
        }
        ArrayList<DataObject> objects = new ArrayList<DataObject>();
        for (int i = 0; i < nodes.length; ++i) {
            Object uo = nodes[i].getUserObject();
            if (!(uo instanceof DataObject)) continue;
            objects.add((DataObject)uo);
        }
        return objects;
    }

    public void setSelectedDisplays(TreeImageDisplay[] nodes) {
        if (nodes.length == 0) {
            return;
        }
        TreeImageDisplay oldDisplay = this.model.getLastSelectedDisplay();
        TreeImageDisplay display = nodes[nodes.length - 1];
        this.hasDataToSave(display);
        if (oldDisplay != null && oldDisplay.equals(display)) {
            return;
        }
        this.model.setSelectedDisplays(nodes);
        this.firePropertyChange("selectedDisplay", oldDisplay, display);
    }

    public void navigate(boolean v) {
        TreeImageDisplay display = this.getLastSelectedDisplay();
        if (display == null) {
            return;
        }
        if (display.containsImages()) {
            this.controller.getAction(BrowserControl.FORWARD_NAV).setEnabled(!v);
        } else {
            this.controller.getAction(BrowserControl.FORWARD_NAV).setEnabled(v);
        }
        this.controller.getAction(BrowserControl.BACKWARD_NAV).setEnabled(!v);
        long id = -1L;
        if (this.model.getGoIntoNode() != null) {
            id = this.model.getGoIntoNode().getUserObjectId();
        }
        if (v) {
            this.model.setMainTree(v, null);
            this.view.navigate();
        } else if (!v && display.getUserObjectId() != id) {
            this.model.setMainTree(v, display);
            this.view.navigate();
        }
    }

    public void onComponentStateChange(boolean b) {
        this.view.onComponentStateChange(b);
    }

    public boolean isDisplayed() {
        return this.model.isDisplayed();
    }

    public void setDisplayed(boolean displayed) {
        if (this.model.getState() == 6) {
            throw new IllegalStateException("This method cannot be invoked in the DISCARDED state.");
        }
        this.model.setDisplayed(displayed);
    }

    public void setRefreshedHierarchy(Map nodes, Map expandedTopNodes) {
        if (this.model.getState() != 2) {
            throw new IllegalStateException("This method cannot be invoked in the LOADING_DATA state.");
        }
        long userID = this.model.getUserID();
        long groupID = this.model.getUserGroupID();
        this.view.setViews(TreeViewerTranslator.refreshHierarchy(nodes, expandedTopNodes, userID, groupID));
        this.model.fireContainerCountLoading();
        this.model.getParentModel().setStatus(false, "", true);
        PartialNameVisitor v = new PartialNameVisitor(this.view.isPartialName());
        this.accept(v, 0);
        this.fireStateChange();
    }

    public boolean isMainTree() {
        return this.model.isMainTree();
    }

    public void displaysImagesName() {
        if (this.model.getState() == 6) {
            throw new IllegalStateException("This method cannot be invoked in the DISCARDED state.");
        }
        PartialNameVisitor v = new PartialNameVisitor(this.view.isPartialName());
        this.accept(v, 0);
        this.view.repaint();
    }

    public void setRootNode(ExperimenterData experimenter) {
        if (this.model.getState() == 6) {
            throw new IllegalStateException("This method cannot be invoked in the DISCARDED state.");
        }
        this.view.setRootNode(experimenter);
    }

    public void cleanFilteredNodes() {
        if (this.model.getState() == 6) {
            throw new IllegalStateException("This method cannot be invoked in the DISCARDED state.");
        }
        if (this.model.getBrowserType() == 102) {
            this.model.setFilterType(this.model.getFilterType());
        }
    }
}

