/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.treeviewer.actions;

import java.awt.event.ActionEvent;
import org.openmicroscopy.shoola.agents.treeviewer.IconManager;
import org.openmicroscopy.shoola.agents.treeviewer.actions.TreeViewerAction;
import org.openmicroscopy.shoola.agents.treeviewer.browser.Browser;
import org.openmicroscopy.shoola.agents.treeviewer.browser.TreeImageDisplay;
import org.openmicroscopy.shoola.agents.treeviewer.browser.TreeImageSet;
import org.openmicroscopy.shoola.agents.treeviewer.cmd.ViewCmd;
import org.openmicroscopy.shoola.agents.treeviewer.view.TreeViewer;
import org.openmicroscopy.shoola.util.ui.UIUtilities;
import pojos.DataObject;
import pojos.ImageData;

public class ViewAction
extends TreeViewerAction {
    private static final String VIEW = "View";
    private static final String BROWSE = "Browse";
    private static final String DESCRIPTION = "Browse the selected nodes";
    private static final String DESCRIPTION_IMAGE = "View the selected image";
    private static IconManager icons;

    protected void onDisplayChange(TreeImageDisplay selectedDisplay) {
        if (selectedDisplay == null) {
            this.setEnabled(false);
            this.putValue("SmallIcon", icons.getIcon(IconManager.BROWSER));
            return;
        }
        if (selectedDisplay.getParentDisplay() == null) {
            this.name = BROWSE;
            this.setEnabled(false);
            this.putValue("SmallIcon", icons.getIcon(IconManager.BROWSER));
            return;
        }
        Object ho = selectedDisplay.getUserObject();
        if (ho == null || !(ho instanceof DataObject)) {
            this.setEnabled(false);
        } else {
            Browser browser = this.model.getSelectedBrowser();
            if (browser != null && browser.getSelectedDisplays().length > 1) {
                this.setEnabled(true);
                this.name = BROWSE;
                this.putValue("SmallIcon", icons.getIcon(IconManager.BROWSER));
                return;
            }
            if (ho instanceof ImageData) {
                this.name = VIEW;
                this.description = DESCRIPTION_IMAGE;
                this.putValue("ShortDescription", UIUtilities.formatToolTipText(this.description));
                this.putValue("SmallIcon", icons.getIcon(IconManager.VIEWER));
            } else {
                this.name = BROWSE;
                this.putValue("SmallIcon", icons.getIcon(IconManager.BROWSER));
            }
            if (selectedDisplay instanceof TreeImageSet) {
                this.setEnabled(((TreeImageSet)selectedDisplay).getNumberItems() > 0);
            } else {
                this.setEnabled(true);
            }
        }
    }

    public ViewAction(TreeViewer model) {
        super(model);
        this.name = BROWSE;
        icons = IconManager.getInstance();
        this.putValue("ShortDescription", UIUtilities.formatToolTipText(DESCRIPTION));
        this.putValue("SmallIcon", icons.getIcon(IconManager.BROWSER));
    }

    public void actionPerformed(ActionEvent e) {
        ViewCmd cmd = new ViewCmd(this.model);
        cmd.execute();
    }
}

