/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.treeviewer.actions;

import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.openmicroscopy.shoola.agents.treeviewer.browser.Browser;
import org.openmicroscopy.shoola.agents.treeviewer.browser.TreeImageDisplay;
import org.openmicroscopy.shoola.agents.treeviewer.view.TreeViewer;

public abstract class TreeViewerAction
extends AbstractAction
implements ChangeListener,
PropertyChangeListener {
    protected TreeViewer model;
    protected String name;
    protected String description;

    protected void onDisplayChange(TreeImageDisplay selectedDisplay) {
    }

    protected void onBrowserStateChange(Browser browser) {
    }

    protected void onBrowserSelection(Browser browser) {
    }

    public TreeViewerAction(TreeViewer model) {
        this.setEnabled(false);
        if (model == null) {
            throw new IllegalArgumentException("no TreeViewer");
        }
        this.model = model;
        model.addPropertyChangeListener("selectedBrowser", this);
        model.addPropertyChangeListener("onComponentStateChanged", this);
        Map browsers = model.getBrowsers();
        for (Browser browser : browsers.values()) {
            browser.addPropertyChangeListener("selectedDisplay", this);
            browser.addChangeListener(this);
        }
    }

    public String getActionName() {
        if (this.name == null || this.name.length() == 0) {
            return (String)this.getValue("Name");
        }
        return this.name;
    }

    public String getActionDescription() {
        if (this.description == null || this.description.length() == 0) {
            return (String)this.getValue("ShortDescription");
        }
        return this.description;
    }

    public void actionPerformed(ActionEvent e) {
    }

    public void propertyChange(PropertyChangeEvent evt) {
        String name = evt.getPropertyName();
        if (name.equals("selectedBrowser")) {
            this.onBrowserSelection((Browser)evt.getNewValue());
            return;
        }
        if (name.equals("onComponentStateChanged")) {
            Browser browser = this.model.getSelectedBrowser();
            TreeImageDisplay v = null;
            if (browser != null) {
                v = browser.getLastSelectedDisplay();
            }
            this.onDisplayChange(v);
            return;
        }
        Object newValue = evt.getNewValue();
        if (newValue == null) {
            this.onDisplayChange(null);
            return;
        }
        if (newValue.equals(evt.getOldValue())) {
            return;
        }
        this.onDisplayChange((TreeImageDisplay)newValue);
    }

    public void stateChanged(ChangeEvent e) {
        Object source = e.getSource();
        if (source instanceof Browser) {
            this.onBrowserStateChange((Browser)source);
        }
    }
}

