/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.treeviewer.actions;

import java.awt.event.ActionEvent;
import org.openmicroscopy.shoola.agents.treeviewer.IconManager;
import org.openmicroscopy.shoola.agents.treeviewer.actions.BrowserAction;
import org.openmicroscopy.shoola.agents.treeviewer.browser.Browser;
import org.openmicroscopy.shoola.agents.treeviewer.browser.TreeImageDisplay;
import org.openmicroscopy.shoola.util.ui.UIUtilities;
import pojos.ImageData;

public class NavigationAction
extends BrowserAction {
    private static final String DESCRIPTION_FORWARD = "Go into selected node.";
    private static final String DESCRIPTION_BACKWARD = "Go back to the tree.";
    private boolean v;

    protected void onDisplayChange(TreeImageDisplay selectedDisplay) {
        if (!this.v) {
            return;
        }
        if (selectedDisplay == null) {
            this.setEnabled(false);
            return;
        }
        Object ho = selectedDisplay.getUserObject();
        this.setEnabled(ho != null && !(ho instanceof ImageData));
        if (selectedDisplay.containsImages()) {
            this.setEnabled(this.model.isMainTree());
        }
    }

    protected void onStateChange() {
        if (!this.v) {
            return;
        }
        switch (this.model.getState()) {
            case 2: 
            case 3: 
            case 4: {
                this.setEnabled(false);
                break;
            }
            default: {
                this.onDisplayChange(this.model.getLastSelectedDisplay());
            }
        }
    }

    public NavigationAction(Browser model, boolean forward) {
        super(model);
        this.v = forward;
        IconManager im = IconManager.getInstance();
        if (forward) {
            this.putValue("ShortDescription", UIUtilities.formatToolTipText(DESCRIPTION_FORWARD));
            this.putValue("SmallIcon", im.getIcon(IconManager.FORWARD_NAV));
        } else {
            this.putValue("ShortDescription", UIUtilities.formatToolTipText(DESCRIPTION_BACKWARD));
            this.putValue("SmallIcon", im.getIcon(IconManager.BACKWARD_NAV));
        }
    }

    public void actionPerformed(ActionEvent e) {
        this.model.navigate(!this.v);
    }
}

