/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.treeviewer.actions;

import java.awt.Component;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import org.openmicroscopy.shoola.agents.treeviewer.IconManager;
import org.openmicroscopy.shoola.agents.treeviewer.actions.TreeViewerAction;
import org.openmicroscopy.shoola.agents.treeviewer.browser.Browser;
import org.openmicroscopy.shoola.agents.treeviewer.browser.TreeImageDisplay;
import org.openmicroscopy.shoola.agents.treeviewer.view.TreeViewer;
import org.openmicroscopy.shoola.util.ui.UIUtilities;
import pojos.CategoryData;
import pojos.CategoryGroupData;
import pojos.DatasetData;
import pojos.ExperimenterData;
import pojos.ProjectData;

public class ManagerAction
extends TreeViewerAction
implements MouseListener {
    private static final String DESCRIPTION = "Manage the data. Press (Shift) to keep the menu on screen when making selection.";
    private Point point;

    protected void onBrowserStateChange(Browser browser) {
        if (browser == null) {
            return;
        }
        switch (browser.getState()) {
            case 2: 
            case 3: 
            case 4: {
                this.setEnabled(false);
                break;
            }
            default: {
                this.onDisplayChange(browser.getLastSelectedDisplay());
            }
        }
    }

    protected void onDisplayChange(TreeImageDisplay selectedDisplay) {
        if (selectedDisplay == null) {
            this.setEnabled(false);
            return;
        }
        Object ho = selectedDisplay.getUserObject();
        if (ho instanceof String || ho instanceof ExperimenterData) {
            this.setEnabled(false);
        } else if (ho instanceof ProjectData) {
            this.setEnabled(this.model.isObjectWritable(ho));
        } else if (ho instanceof CategoryGroupData) {
            this.setEnabled(this.model.isObjectWritable(ho));
        } else if (ho instanceof CategoryData) {
            this.setEnabled(this.model.isObjectWritable(ho));
        } else if (ho instanceof DatasetData) {
            this.setEnabled(this.model.isObjectWritable(ho));
        } else {
            this.setEnabled(false);
        }
    }

    public ManagerAction(TreeViewer model) {
        super(model);
        this.putValue("ShortDescription", UIUtilities.formatToolTipText(DESCRIPTION));
        IconManager im = IconManager.getInstance();
        this.putValue("SmallIcon", im.getIcon(IconManager.DATA_MANAGER));
    }

    public void mousePressed(MouseEvent me) {
        this.point = me.getPoint();
    }

    public void mouseReleased(MouseEvent me) {
        Object source = me.getSource();
        if (source instanceof Component && this.isEnabled()) {
            this.model.showMenu(0, (Component)source, this.point);
        }
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mouseClicked(MouseEvent e) {
    }
}

