/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.treeviewer.actions;

import java.awt.event.ActionEvent;
import org.openmicroscopy.shoola.agents.treeviewer.IconManager;
import org.openmicroscopy.shoola.agents.treeviewer.actions.TreeViewerAction;
import org.openmicroscopy.shoola.agents.treeviewer.browser.Browser;
import org.openmicroscopy.shoola.agents.treeviewer.browser.TreeImageDisplay;
import org.openmicroscopy.shoola.agents.treeviewer.view.TreeViewer;
import org.openmicroscopy.shoola.util.ui.UIUtilities;
import pojos.ImageData;

public class GoIntoAction
extends TreeViewerAction {
    private static final String NAME = "Go Into";
    private static final String DESCRIPTION = "Go into the selected node.";

    protected void onDisplayChange(TreeImageDisplay selectedDisplay) {
        if (selectedDisplay == null) {
            this.setEnabled(false);
            return;
        }
        Object ho = selectedDisplay.getUserObject();
        this.setEnabled(ho != null && !(ho instanceof ImageData));
    }

    protected void onBrowserStateChange(Browser browser) {
        if (browser == null) {
            return;
        }
        switch (browser.getState()) {
            case 2: 
            case 3: 
            case 4: {
                this.setEnabled(false);
                break;
            }
            default: {
                this.setEnabled(true);
                this.onDisplayChange(this.model.getSelectedBrowser().getLastSelectedDisplay());
            }
        }
    }

    public GoIntoAction(TreeViewer model) {
        super(model);
        this.name = NAME;
        this.putValue("ShortDescription", UIUtilities.formatToolTipText(DESCRIPTION));
        IconManager im = IconManager.getInstance();
        this.putValue("SmallIcon", im.getIcon(IconManager.FORWARD_NAV));
    }

    public void actionPerformed(ActionEvent e) {
        this.model.navigate();
    }
}

