/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.treeviewer.actions;

import java.awt.Component;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import org.openmicroscopy.shoola.agents.treeviewer.IconManager;
import org.openmicroscopy.shoola.agents.treeviewer.actions.BrowserAction;
import org.openmicroscopy.shoola.agents.treeviewer.browser.Browser;
import org.openmicroscopy.shoola.util.ui.UIUtilities;

public class FilterMenuAction
extends BrowserAction
implements MouseListener {
    private static final String DESCRIPTION = "Menu";
    private Point pressedPoint;

    public FilterMenuAction(Browser model) {
        super(model);
        IconManager im = IconManager.getInstance();
        this.putValue("ShortDescription", UIUtilities.formatToolTipText(DESCRIPTION));
        this.putValue("SmallIcon", im.getIcon(IconManager.FILTER_MENU));
        this.setEnabled(model.getBrowserType() == 102);
    }

    public void mousePressed(MouseEvent me) {
        this.pressedPoint = me.getPoint();
    }

    public void mouseReleased(MouseEvent me) {
        Object source = me.getSource();
        if (source instanceof Component && this.isEnabled()) {
            this.model.showFilterMenu((Component)source, this.pressedPoint);
        }
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mouseClicked(MouseEvent e) {
    }
}

