/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.treeviewer.actions;

import java.awt.event.ActionEvent;
import org.openmicroscopy.shoola.agents.treeviewer.IconManager;
import org.openmicroscopy.shoola.agents.treeviewer.actions.TreeViewerAction;
import org.openmicroscopy.shoola.agents.treeviewer.browser.Browser;
import org.openmicroscopy.shoola.agents.treeviewer.browser.TreeImageDisplay;
import org.openmicroscopy.shoola.agents.treeviewer.cmd.DeleteCmd;
import org.openmicroscopy.shoola.agents.treeviewer.view.TreeViewer;
import org.openmicroscopy.shoola.util.ui.UIUtilities;
import pojos.CategoryData;
import pojos.CategoryGroupData;
import pojos.DatasetData;
import pojos.ImageData;
import pojos.ProjectData;

public class DeleteAction
extends TreeViewerAction {
    private static final String NAME = "Remove";
    private static final String NAME_ROOT_P = "Remove projects";
    private static final String NAME_ROOT_CG = "Remove categoryGroups";
    private static final String NAME_PROJECT = "Remove from current project";
    private static final String NAME_CATEGORYGROUP = "Remove from current category group";
    private static final String NAME_DATASET = "Remove from current dataset";
    private static final String NAME_CATEGORY = "Remove from current category";
    private static final String DESCRIPTION = "Remove the selected item.";
    private static final String DESCRIPTION_ROOT_P = "Remove the selected project.";
    private static final String DESCRIPTION_ROOT_CG = "Remove the selected categoryGroup.";
    private static final String DESCRIPTION_PROJECT = "Remove the selected datasets from the project.";
    private static final String DESCRIPTION_CATEGORYGROUP = "Remove the selected categories from the categoryGroup.";
    private static final String DESCRIPTION_DATASET = "Remove the selected images from the dataset.";
    private static final String DESCRIPTION_CATEGORY = "Remove the selected images from the category.";

    protected void onBrowserStateChange(Browser browser) {
        if (browser == null) {
            return;
        }
        switch (browser.getState()) {
            case 2: 
            case 3: 
            case 4: {
                this.setEnabled(false);
                break;
            }
            default: {
                this.onDisplayChange(browser.getLastSelectedDisplay());
            }
        }
    }

    protected void onDisplayChange(TreeImageDisplay selectedDisplay) {
        if (selectedDisplay == null) {
            this.name = NAME;
            this.description = DESCRIPTION;
            this.putValue("ShortDescription", UIUtilities.formatToolTipText(DESCRIPTION));
            this.setEnabled(false);
            return;
        }
        Browser browser = this.model.getSelectedBrowser();
        if (browser == null) {
            this.name = NAME;
            this.putValue("ShortDescription", UIUtilities.formatToolTipText(DESCRIPTION));
            this.setEnabled(false);
            this.description = DESCRIPTION;
            return;
        }
        if (browser.getBrowserType() == 102) {
            this.name = NAME;
            this.putValue("ShortDescription", UIUtilities.formatToolTipText(DESCRIPTION));
            this.setEnabled(false);
            this.description = DESCRIPTION;
            return;
        }
        Object ho = selectedDisplay.getUserObject();
        if (ho instanceof ProjectData) {
            this.name = NAME_ROOT_P;
            this.putValue("ShortDescription", UIUtilities.formatToolTipText(DESCRIPTION_ROOT_P));
            this.setEnabled(this.model.isObjectWritable(ho));
        } else if (ho instanceof CategoryGroupData) {
            this.name = NAME_ROOT_CG;
            this.putValue("ShortDescription", UIUtilities.formatToolTipText(DESCRIPTION_ROOT_CG));
            this.setEnabled(this.model.isObjectWritable(ho));
        } else if (ho instanceof DatasetData) {
            this.name = NAME_PROJECT;
            this.putValue("ShortDescription", UIUtilities.formatToolTipText(DESCRIPTION_PROJECT));
            TreeImageDisplay parent = selectedDisplay.getParentDisplay();
            if (parent == null) {
                this.setEnabled(false);
            } else if (parent.getUserObject() instanceof ProjectData) {
                this.setEnabled(this.model.isObjectWritable(ho));
            } else {
                this.setEnabled(false);
            }
        } else if (ho instanceof CategoryData) {
            this.name = NAME_CATEGORYGROUP;
            this.putValue("ShortDescription", UIUtilities.formatToolTipText(DESCRIPTION_CATEGORYGROUP));
            TreeImageDisplay parent = selectedDisplay.getParentDisplay();
            if (parent == null) {
                this.setEnabled(false);
            } else if (parent.getUserObject() instanceof CategoryGroupData) {
                this.setEnabled(this.model.isObjectWritable(ho));
            } else {
                this.setEnabled(false);
            }
        } else if (ho instanceof ImageData) {
            TreeImageDisplay parent = selectedDisplay.getParentDisplay();
            if (parent == null) {
                this.setEnabled(false);
            } else {
                if (parent.getUserObject() instanceof DatasetData) {
                    this.name = NAME_DATASET;
                    this.putValue("ShortDescription", UIUtilities.formatToolTipText(DESCRIPTION_DATASET));
                } else {
                    this.name = NAME_CATEGORY;
                    this.putValue("ShortDescription", UIUtilities.formatToolTipText(DESCRIPTION_CATEGORY));
                }
                this.setEnabled(this.model.isObjectWritable(ho));
            }
        } else {
            this.setEnabled(false);
            this.putValue("ShortDescription", UIUtilities.formatToolTipText(DESCRIPTION));
        }
        this.description = (String)this.getValue("ShortDescription");
    }

    public DeleteAction(TreeViewer model) {
        super(model);
        this.name = NAME;
        this.putValue("Name", this.name);
        this.putValue("ShortDescription", UIUtilities.formatToolTipText(DESCRIPTION));
        IconManager im = IconManager.getInstance();
        this.putValue("SmallIcon", im.getIcon(IconManager.DELETE));
    }

    public void actionPerformed(ActionEvent e) {
        DeleteCmd cmd = new DeleteCmd(this.model);
        cmd.execute();
    }
}

