/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.treeviewer.actions;

import java.awt.event.ActionEvent;
import org.openmicroscopy.shoola.agents.treeviewer.IconManager;
import org.openmicroscopy.shoola.agents.treeviewer.actions.TreeViewerAction;
import org.openmicroscopy.shoola.agents.treeviewer.browser.Browser;
import org.openmicroscopy.shoola.agents.treeviewer.browser.TreeImageDisplay;
import org.openmicroscopy.shoola.agents.treeviewer.cmd.CutCmd;
import org.openmicroscopy.shoola.agents.treeviewer.view.TreeViewer;
import org.openmicroscopy.shoola.util.ui.UIUtilities;
import pojos.CategoryData;
import pojos.DatasetData;
import pojos.ImageData;

public class CutAction
extends TreeViewerAction {
    private static final String NAME = "Cut";
    private static final String DESCRIPTION = "Cut the selected elements.";

    protected void onBrowserStateChange(Browser browser) {
        if (browser == null) {
            return;
        }
        switch (browser.getState()) {
            case 2: 
            case 3: 
            case 4: {
                this.setEnabled(false);
                break;
            }
            default: {
                this.onDisplayChange(browser.getLastSelectedDisplay());
            }
        }
    }

    protected void onDisplayChange(TreeImageDisplay selectedDisplay) {
        if (selectedDisplay == null) {
            this.setEnabled(false);
            return;
        }
        Object ho = selectedDisplay.getUserObject();
        if (ho instanceof DatasetData || ho instanceof ImageData || ho instanceof CategoryData) {
            this.setEnabled(this.model.isObjectWritable(ho));
        } else {
            this.setEnabled(false);
        }
    }

    public CutAction(TreeViewer model) {
        super(model);
        this.name = NAME;
        this.putValue("Name", NAME);
        this.putValue("ShortDescription", UIUtilities.formatToolTipText(DESCRIPTION));
        IconManager im = IconManager.getInstance();
        this.putValue("SmallIcon", im.getIcon(IconManager.CUT));
    }

    public void actionPerformed(ActionEvent e) {
        CutCmd cmd = new CutCmd(this.model);
        cmd.execute();
    }
}

