/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.treeviewer.actions;

import java.awt.event.ActionEvent;
import org.openmicroscopy.shoola.agents.treeviewer.IconManager;
import org.openmicroscopy.shoola.agents.treeviewer.actions.TreeViewerAction;
import org.openmicroscopy.shoola.agents.treeviewer.browser.Browser;
import org.openmicroscopy.shoola.agents.treeviewer.cmd.CreateCmd;
import org.openmicroscopy.shoola.agents.treeviewer.view.TreeViewer;
import org.openmicroscopy.shoola.util.ui.UIUtilities;

public class CreateTopContainerAction
extends TreeViewerAction {
    private static final String NAME = "New...";
    private static final String NAME_PROJECT = "New Project...";
    private static final String NAME_CATEGORY_GROUP = "New Category Group...";
    private static final String DESCRIPTION_PROJECT = "Create a new Project.";
    private static final String DESCRIPTION_CATEGORY_GROUP = "Create a new Category Group.";
    private int nodeType;

    protected void onBrowserStateChange(Browser browser) {
        if (browser == null) {
            return;
        }
        switch (browser.getState()) {
            case 2: 
            case 3: 
            case 4: {
                this.setEnabled(false);
                break;
            }
            default: {
                this.setEnabled(this.model.isForCurrentUser());
            }
        }
    }

    protected void onBrowserSelection(Browser browser) {
        this.nodeType = -1;
        if (browser == null) {
            this.setEnabled(false);
            this.name = NAME;
        } else {
            switch (browser.getBrowserType()) {
                case 100: {
                    this.setEnabled(this.model.isForCurrentUser());
                    this.name = NAME_PROJECT;
                    this.nodeType = 0;
                    this.putValue("ShortDescription", UIUtilities.formatToolTipText(DESCRIPTION_PROJECT));
                    break;
                }
                case 101: {
                    this.setEnabled(this.model.isForCurrentUser());
                    this.name = NAME_CATEGORY_GROUP;
                    this.nodeType = 2;
                    this.putValue("ShortDescription", UIUtilities.formatToolTipText(DESCRIPTION_CATEGORY_GROUP));
                    break;
                }
                case 102: {
                    this.setEnabled(false);
                    this.name = NAME;
                }
            }
        }
        this.description = (String)this.getValue("ShortDescription");
    }

    public CreateTopContainerAction(TreeViewer model) {
        super(model);
        this.onBrowserSelection(model.getSelectedBrowser());
        this.putValue("ShortDescription", UIUtilities.formatToolTipText(DESCRIPTION_PROJECT));
        IconManager im = IconManager.getInstance();
        this.putValue("SmallIcon", im.getIcon(IconManager.ADD_CONTAINER));
    }

    public void actionPerformed(ActionEvent e) {
        if (this.nodeType == -1) {
            return;
        }
        CreateCmd cmd = new CreateCmd(this.model, this.nodeType);
        cmd.execute();
    }
}

