/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.treeviewer.actions;

import java.awt.event.ActionEvent;
import org.openmicroscopy.shoola.agents.treeviewer.IconManager;
import org.openmicroscopy.shoola.agents.treeviewer.actions.TreeViewerAction;
import org.openmicroscopy.shoola.agents.treeviewer.browser.Browser;
import org.openmicroscopy.shoola.agents.treeviewer.browser.TreeImageDisplay;
import org.openmicroscopy.shoola.agents.treeviewer.cmd.CreateCmd;
import org.openmicroscopy.shoola.agents.treeviewer.view.TreeViewer;
import org.openmicroscopy.shoola.util.ui.UIUtilities;
import pojos.CategoryData;
import pojos.CategoryGroupData;
import pojos.DatasetData;
import pojos.ExperimenterData;
import pojos.ProjectData;

public class CreateAction
extends TreeViewerAction {
    private static final String NAME = "New...";
    private static final String NAME_DATASET = "New Dataset...";
    private static final String NAME_CATEGORY = "New Category...";
    private static final String NAME_IMAGE = "Import Image...";
    private static final String DESCRIPTION_DATASET = "Create a new dataset and add it to the selected project.";
    private static final String DESCRIPTION_CATEGORY = "Create a new category and add it to the selected category group.";
    private static final String DESCRIPTION_IMAGE = "Import image into the selected dataset.";
    private static final String DESCRIPTION = "Create a new element.";
    private int nodeType;

    protected void onBrowserStateChange(Browser browser) {
        if (browser == null) {
            return;
        }
        switch (browser.getState()) {
            case 2: 
            case 3: 
            case 4: {
                this.setEnabled(false);
                break;
            }
            default: {
                this.onDisplayChange(browser.getLastSelectedDisplay());
            }
        }
    }

    protected void onDisplayChange(TreeImageDisplay selectedDisplay) {
        if (selectedDisplay == null) {
            this.setEnabled(false);
            this.name = NAME;
            this.putValue("ShortDescription", UIUtilities.formatToolTipText(DESCRIPTION));
            return;
        }
        Object ho = selectedDisplay.getUserObject();
        if (ho instanceof String || ho instanceof ExperimenterData) {
            this.setEnabled(false);
            this.name = NAME;
            this.putValue("ShortDescription", UIUtilities.formatToolTipText(DESCRIPTION));
        } else if (ho instanceof ProjectData) {
            this.setEnabled(this.model.isObjectWritable(ho));
            this.name = NAME_DATASET;
            this.nodeType = 1;
            this.putValue("ShortDescription", UIUtilities.formatToolTipText(DESCRIPTION_DATASET));
        } else if (ho instanceof CategoryGroupData) {
            this.setEnabled(this.model.isObjectWritable(ho));
            this.name = NAME_CATEGORY;
            this.putValue("ShortDescription", UIUtilities.formatToolTipText(DESCRIPTION_CATEGORY));
            this.nodeType = 3;
        } else if (ho instanceof CategoryData) {
            this.setEnabled(this.model.isObjectWritable(ho));
            this.setEnabled(false);
            this.name = NAME_IMAGE;
            this.putValue("ShortDescription", UIUtilities.formatToolTipText(DESCRIPTION_IMAGE));
        } else if (ho instanceof DatasetData) {
            this.setEnabled(this.model.isObjectWritable(ho));
            this.setEnabled(false);
            this.name = NAME_IMAGE;
            this.putValue("ShortDescription", UIUtilities.formatToolTipText(DESCRIPTION_IMAGE));
        } else {
            this.setEnabled(false);
            this.name = NAME;
            this.putValue("ShortDescription", UIUtilities.formatToolTipText(DESCRIPTION));
        }
        this.description = (String)this.getValue("ShortDescription");
    }

    public CreateAction(TreeViewer model) {
        super(model);
        this.name = NAME;
        this.putValue("ShortDescription", UIUtilities.formatToolTipText(DESCRIPTION));
        this.description = (String)this.getValue("ShortDescription");
        IconManager im = IconManager.getInstance();
        this.putValue("SmallIcon", im.getIcon(IconManager.CREATE));
    }

    public void actionPerformed(ActionEvent e) {
        CreateCmd cmd = new CreateCmd(this.model, this.nodeType);
        cmd.execute();
    }
}

